/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mdd.auth.entitle;

import com.devexperts.auth.AuthToken;
import com.devexperts.logging.Logging;
import com.devexperts.mdd.auth.util.SignedToken;
import com.devexperts.qd.qtp.MessageAdapterConnectionFactory;
import com.devexperts.qd.qtp.auth.QDLoginHandler;
import com.devexperts.qd.qtp.auth.QDLoginHandlerFactory;
import com.devexperts.util.InvalidFormatException;
import com.dxfeed.promise.Promise;
import java.time.Duration;

public class EntitleLoginHandlerFactory
implements QDLoginHandlerFactory {
    public static final String ENTITLE_SCHEME = "entitle";
    private static final Logging log = Logging.getLogging(EntitleLoginHandlerFactory.class);
    public static volatile String appToken;

    public EntitleLoginHandlerFactory() {
        log.info("Registering auth scheme 'entitle'");
    }

    public static String getAppToken() {
        return appToken;
    }

    public static void setAppToken(String appToken) {
        EntitleLoginHandlerFactory.appToken = appToken;
    }

    public static String createToken(String issuer, String sessionType, String user, String secret) {
        return SignedToken.newBuilder().setIssuer(issuer).setSubject(sessionType).setMessage(user).setIssuedNow().setExpirationFromNow(Duration.ofDays(1L)).toToken().signToken(secret);
    }

    @Override
    public QDLoginHandler createLoginHandler(String login, MessageAdapterConnectionFactory factory) throws InvalidFormatException {
        String token;
        boolean hasToken;
        if (!login.startsWith(ENTITLE_SCHEME)) {
            return null;
        }
        boolean bl = hasToken = login.length() > ENTITLE_SCHEME.length();
        if (hasToken && login.charAt(ENTITLE_SCHEME.length()) != ':') {
            log.error("Auth scheme 'entitle' login must be specified as: entitle[:<token>]");
            return null;
        }
        String string = token = hasToken ? login.substring(ENTITLE_SCHEME.length() + 1) : EntitleLoginHandlerFactory.getAppToken();
        if (token == null || token.isEmpty()) {
            log.error("No token available for scheme 'entitle'");
            return null;
        }
        log.info("Using auth scheme 'entitle' with token: " + token);
        return new AutherLoginHandler(token);
    }

    protected static class AutherLoginHandler
    implements QDLoginHandler {
        private final AuthToken token;

        public AutherLoginHandler(String token) {
            this.token = AuthToken.createBearerToken(token);
        }

        @Override
        public Promise<AuthToken> login(String reason) {
            if (reason != null) {
                log.error("Server rejected token: " + reason);
                return Promise.failed(new SecurityException(reason));
            }
            return Promise.completed(this.token);
        }

        @Override
        public AuthToken getAuthToken() {
            return this.token;
        }
    }
}

