/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import com.motivewave.common.Enums$Text$Align;
import com.motivewave.common.Enums$Text$Outline;
import com.motivewave.common.h;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.common.util.aa;
import com.motivewave.common.util.w;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javafx.geometry.Dimension2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject$Null;
import org.json.JSONString;
import org.json.JSONTokener;

public class JSONObject
implements aa {
    private Map map = new HashMap(1);
    public static final Object NULL = new JSONObject$Null();

    public static JSONObject of(Object ... objectArray) {
        JSONObject jSONObject = new JSONObject();
        for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
            jSONObject.put(h.b(objectArray[i2]), objectArray[i2 + 1]);
        }
        return jSONObject;
    }

    public static JSONObject parse(String string) {
        if (h.g(string)) {
            return new JSONObject();
        }
        try {
            return new JSONObject(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new JSONObject();
        }
    }

    public static boolean isJSON(String string) {
        if (h.g(string)) {
            return true;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isWhitespace(c2)) continue;
            return c2 == '{' || c2 == '[';
        }
        return false;
    }

    @Override
    public JSONObject clone() {
        try {
            JSONObject jSONObject = (JSONObject)super.clone();
            jSONObject.map = new HashMap();
            for (String string : this.map.keySet()) {
                Object object = this.map.get(string);
                if (object instanceof aa) {
                    object = ((aa)object).clone();
                }
                jSONObject.map.put(string, object);
            }
            return jSONObject;
        }
        catch (Exception exception) {
            h.a.warning("JSONObject::clone() " + exception.getMessage());
            return null;
        }
    }

    public JSONObject() {
    }

    public JSONObject(JSONObject jSONObject, String[] stringArray) {
        this();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                this.putOnce(stringArray[i2], jSONObject.opt(stringArray[i2]));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JSONObject(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof Map) {
                object = new JSONObject((Map)object);
            }
            if (object instanceof List) {
                object = new JSONArray((List)object);
            }
            this.map.put((String)entry.getKey(), object);
        }
    }

    public JSONObject(JSONTokener jSONTokener) {
        this();
        if (jSONTokener == null) {
            return;
        }
        if (jSONTokener.nextClean() != '{') {
            throw jSONTokener.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c2 = jSONTokener.nextClean();
            switch (c2) {
                case '\u0000': {
                    throw jSONTokener.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            jSONTokener.back();
            String string = jSONTokener.nextValue().toString();
            c2 = jSONTokener.nextClean();
            if (c2 == '=') {
                if (jSONTokener.next() != '>') {
                    jSONTokener.back();
                }
            } else if (c2 != ':') {
                throw jSONTokener.syntaxError("Expected a ':' after a key");
            }
            this.putOnce(string, jSONTokener.nextValue());
            switch (jSONTokener.nextClean()) {
                case ',': 
                case ';': {
                    if (jSONTokener.nextClean() == '}') {
                        return;
                    }
                    jSONTokener.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw jSONTokener.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(String string) {
        this(h.g(string) ? null : new JSONTokener(string));
    }

    public String getString(String string) {
        return this.str(string);
    }

    public Object get(String string) {
        Object object = this.opt(string);
        if (this.isNullValue(object)) {
            return null;
        }
        return object;
    }

    public JSONObject accumulate(String string, Object object) {
        JSONObject.testValidity(object);
        Object object2 = this.opt(string);
        if (object2 == null) {
            this.put(string, object instanceof JSONArray ? new JSONArray().put(object) : object);
        } else if (object2 instanceof JSONArray) {
            ((JSONArray)object2).put(object);
        } else {
            this.put(string, new JSONArray().put(object2).put(object));
        }
        return this;
    }

    public JSONObject append(String string, Object object) {
        JSONObject.testValidity(object);
        Object object2 = this.opt(string);
        if (object2 == null) {
            this.put(string, new JSONArray().put(object));
        } else if (object2 instanceof JSONArray) {
            this.put(string, ((JSONArray)object2).put(object));
        } else {
            throw new JSONException("JSONObject[" + string + "] is not a JSONArray.");
        }
        return this;
    }

    public static String doubleToString(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            return "null";
        }
        String string = Double.toString(d2);
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public boolean is(String ... stringArray) {
        return this.is(this.key(stringArray), true);
    }

    public boolean is(String string, boolean bl2) {
        Object v2 = this.map.get(string);
        if (this.isNullValue(v2)) {
            return bl2;
        }
        return h.c(v2);
    }

    public Boolean getBoolean(String string) {
        Object v2 = this.map.get(string);
        if (this.isNullValue(v2)) {
            return null;
        }
        return h.c(v2);
    }

    public Double getDoubleObj(String string) {
        return this.has(string) ? Double.valueOf(this.getDouble(string, 0.0)) : null;
    }

    public double getDouble(String ... stringArray) {
        return this.getDouble(this.key(stringArray), 0.0);
    }

    public double getDouble(String string, double d2) {
        Object v2 = this.map.get(string);
        if (this.isNullValue(v2)) {
            return d2;
        }
        return h.a(v2);
    }

    public float getFloat(String ... stringArray) {
        return this.getFloat(this.key(stringArray), 0.0f);
    }

    public float getFloat(String string, float f2) {
        Object v2 = this.map.get(string);
        if (this.isNullValue(v2)) {
            return f2;
        }
        return h.a(v2);
    }

    public int getInt(String ... stringArray) {
        return this.getInt(this.key(stringArray), 0);
    }

    public int getInt(String string, int n2) {
        Object v2 = this.map.get(string);
        if (this.isNullValue(v2)) {
            return n2;
        }
        return h.a(v2);
    }

    public Integer getInteger(String string) {
        Object v2 = this.map.get(string);
        if (this.isNullValue(v2)) {
            return null;
        }
        return h.a(v2);
    }

    public JSONArray getJSONArray(String string) {
        Object object = this.opt(string);
        if (this.isNullValue(object)) {
            return null;
        }
        try {
            return (JSONArray)object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List getStringList(String string) {
        Object v2 = this.map.get(string);
        if (this.isNullValue(v2)) {
            return Collections.EMPTY_LIST;
        }
        try {
            if (v2 instanceof String) {
                return h.b(new String[]{(String)v2});
            }
            JSONArray jSONArray = (JSONArray)v2;
            Object object = h.b(new String[0]);
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                object.add(jSONArray.getString(i2));
            }
            return object;
        }
        catch (Exception exception) {
            return Collections.EMPTY_LIST;
        }
    }

    public List getFloatList(String string) {
        Object v2 = this.map.get(string);
        if (this.isNullValue(v2)) {
            return Collections.EMPTY_LIST;
        }
        try {
            JSONArray jSONArray = (JSONArray)v2;
            Object object = h.b((Object[])new Float[0]);
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                object.add(Float.valueOf(jSONArray.getFloat(i2)));
            }
            return object;
        }
        catch (Exception exception) {
            return Collections.EMPTY_LIST;
        }
    }

    public List getList(String string) {
        Object v2 = this.map.get(string);
        if (this.isNullValue(v2)) {
            return Collections.EMPTY_LIST;
        }
        try {
            JSONArray jSONArray = (JSONArray)v2;
            Object object = h.b(new Object[0]);
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                object.add(jSONArray.get(i2));
            }
            return object;
        }
        catch (Exception exception) {
            return Collections.EMPTY_LIST;
        }
    }

    public List getObjList(String string) {
        Object v2 = this.map.get(string);
        if (this.isNullValue(v2)) {
            return Collections.EMPTY_LIST;
        }
        try {
            JSONArray jSONArray = (JSONArray)v2;
            Object object = h.b(new JSONObject[0]);
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                object.add(jSONArray.getJSONObject(i2));
            }
            return object;
        }
        catch (Exception exception) {
            try {
                return h.b(new JSONObject[]{(JSONObject)v2});
            }
            catch (Exception exception2) {
                return Collections.EMPTY_LIST;
            }
        }
    }

    public JSONObject obj(String string) {
        Object object = this.opt(string);
        if (this.isNullValue(object)) {
            return null;
        }
        try {
            return (JSONObject)object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Map map(String string) {
        JSONObject jSONObject = this.obj(string);
        if (jSONObject == null) {
            return null;
        }
        return jSONObject.toMap();
    }

    public boolean exists(String string) {
        return !this.isNullValue(this.opt(string));
    }

    public long getLong(String string) {
        Object object = this.opt(string);
        if (this.isNullValue(object)) {
            return 0L;
        }
        return h.a(object);
    }

    public Date getDate(String string) {
        Object object = this.opt(string);
        if (this.isNullValue(object)) {
            return null;
        }
        return new Date(h.a(object));
    }

    public long getLong(String string, long l2) {
        Object object = this.opt(string);
        if (this.isNullValue(object)) {
            return l2;
        }
        return h.a(object);
    }

    public static String[] getNames(JSONObject jSONObject) {
        int n2 = jSONObject.length();
        if (n2 == 0) {
            return null;
        }
        Iterator iterator = jSONObject.keys();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (iterator.hasNext()) {
            stringArray[n3] = (String)iterator.next();
            ++n3;
        }
        return stringArray;
    }

    public static String[] getNames(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        Field[] fieldArray = clazz.getFields();
        int n2 = fieldArray.length;
        if (n2 == 0) {
            return null;
        }
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = fieldArray[i2].getName();
        }
        return stringArray;
    }

    public boolean in(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            if (!h.a((Object)this.str(string), (Object)string2)) continue;
            return true;
        }
        return false;
    }

    public boolean ini(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            if (!h.b((Object)this.str(string), (Object)string2)) continue;
            return true;
        }
        return false;
    }

    public String str(String ... stringArray) {
        String string = this.key(stringArray);
        Object object = this.opt(string);
        if (this.isNullValue(object)) {
            return null;
        }
        return object.toString();
    }

    public String key(String ... stringArray) {
        for (String string : stringArray) {
            if (!this.has(string)) continue;
            return string;
        }
        return null;
    }

    public String strDef(String string, String string2) {
        Object object = this.opt(string);
        if (this.isNullValue(object)) {
            return string2;
        }
        return object.toString();
    }

    public File getFile(String string) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        return new File(string2);
    }

    public javafx.scene.paint.Color getColorFX(String string) {
        if (this.get(string) instanceof javafx.scene.paint.Color) {
            return (javafx.scene.paint.Color)this.get(string);
        }
        return UIUtil.a(this.getColor(string));
    }

    public javafx.scene.paint.Color getColorFX(String string, javafx.scene.paint.Color color) {
        return UIUtil.a(this.getColor(string, UIUtil.a(color)));
    }

    public Color getColor(String string) {
        return this.getColor(string, null);
    }

    public Color getColor(String string, Color color) {
        Object object = this.get(string);
        if (object instanceof Color) {
            return (Color)object;
        }
        if (object instanceof javafx.scene.paint.Color) {
            return UIUtil.a((javafx.scene.paint.Color)object);
        }
        return this.readColor(this.str(string), color);
    }

    public Locale getLocale(String string) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        List list = h.a(string2, '_');
        if (list.size() == 1) {
            return new Locale((String)list.get(0));
        }
        if (list.size() == 2) {
            return new Locale((String)list.get(0), (String)list.get(1));
        }
        if (list.size() == 3) {
            return new Locale((String)list.get(0), (String)list.get(1), (String)list.get(2));
        }
        list = h.a(string2, '|');
        if (list.size() != 3) {
            return null;
        }
        return new Locale((String)list.get(0), (String)list.get(1), (String)list.get(2));
    }

    private Color readColor(String string, Color color) {
        if (h.g(string)) {
            return color;
        }
        List list = h.a(string, ',');
        if (list == null || list.size() < 3 || list.size() > 4) {
            return color;
        }
        if (list.size() == 4) {
            return UIUtil.c(h.b((String)list.get(0)), h.b((String)list.get(1)), h.b((String)list.get(2)), h.b((String)list.get(3)));
        }
        return UIUtil.a(h.b((String)list.get(0)), h.b((String)list.get(1)), h.b((String)list.get(2)));
    }

    public List getColors(String string) {
        List list = this.getStringList(string);
        if (h.a((Collection)list)) {
            return new ArrayList();
        }
        ArrayList<Color> arrayList = new ArrayList<Color>();
        for (String string2 : list) {
            Color color = this.readColor(string2, null);
            if (color == null) continue;
            arrayList.add(color);
        }
        return arrayList;
    }

    public List getFXColors(String string) {
        List list = this.getStringList(string);
        if (h.a((Collection)list)) {
            return new ArrayList();
        }
        ArrayList<javafx.scene.paint.Color> arrayList = new ArrayList<javafx.scene.paint.Color>();
        for (String string2 : list) {
            Color color = this.readColor(string2, null);
            if (color == null) continue;
            arrayList.add(UIUtil.a(color));
        }
        return arrayList;
    }

    public BasicStroke getStroke(String string) {
        if (this.get(string) instanceof BasicStroke) {
            return (BasicStroke)this.get(string);
        }
        JSONObject jSONObject = this.obj(string);
        if (jSONObject == null) {
            return null;
        }
        float f2 = jSONObject.getFloat("width", 1.0f);
        float[] fArray = this.getDash("dash");
        if (fArray != null) {
            return new BasicStroke(f2, 1, 0, 1.0f, fArray, 0.0f);
        }
        return new BasicStroke(f2);
    }

    public Enums$Text$Align getTextAlign(String string) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        try {
            return Enums$Text$Align.valueOf(string2);
        }
        catch (Exception exception) {
            return Enums$Text$Align.LEFT;
        }
    }

    public Enums$Text$Align getTextAlign(String string, Enums$Text$Align enums$Text$Align) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return enums$Text$Align;
        }
        try {
            return Enums$Text$Align.valueOf(string2);
        }
        catch (Exception exception) {
            return enums$Text$Align;
        }
    }

    public Enums$Text$Outline getTextOutline(String string) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        try {
            return Enums$Text$Outline.valueOf(string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public javafx.scene.text.Font getFontFX(String string) {
        if (this.get(string) instanceof javafx.scene.text.Font) {
            return (javafx.scene.text.Font)this.get(string);
        }
        return UIUtil.a(this.getFont(string));
    }

    public javafx.scene.text.Font getFontFX(String string, javafx.scene.text.Font font) {
        if (this.get(string) instanceof javafx.scene.text.Font) {
            return (javafx.scene.text.Font)this.get(string);
        }
        Font font2 = this.getFont(string);
        return font2 == null ? font : UIUtil.a(font2);
    }

    public Font getFont(String string) {
        return this.getFont(string, null);
    }

    public Font getFont(String string, Font font) {
        if (this.get(string) instanceof Font) {
            return (Font)this.get(string);
        }
        String string2 = this.str(string);
        if (h.g(string2)) {
            return font;
        }
        List list = h.a(string2, '|');
        if (h.a((Collection)list) || list.size() < 2) {
            return font;
        }
        String string3 = (String)list.get(0);
        float f2 = h.b((String)list.get(1));
        String string4 = list.size() > 2 ? (String)list.get(2) : "";
        int n2 = 0;
        if (!h.g(string4)) {
            if (string4.indexOf("B") != -1) {
                n2 |= 1;
            }
            if (string4.indexOf("I") != -1) {
                n2 |= 2;
            }
        }
        Font font2 = new Font(string3, n2, (int)f2);
        font2 = font2.deriveFont(f2);
        if (string4 != null && string4.indexOf("U") != -1) {
            font2 = h.a(font2, true);
        }
        return font2;
    }

    public Point2D getPoint2D(String string) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        List list = h.a(string2, ',');
        if (list.size() != 2) {
            return null;
        }
        return new Point2D.Double(h.a((String)list.get(0)), h.a((String)list.get(1)));
    }

    public java.awt.geom.Rectangle2D getRectangle2D(String string) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        List list = h.a(string2, ',');
        if (list.size() != 4) {
            return null;
        }
        return new Rectangle2D.Double(h.a((String)list.get(0)), h.a((String)list.get(1)), h.a((String)list.get(2)), h.a((String)list.get(3)));
    }

    public Rectangle2D getRectangle2DFX(String string) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        List list = h.a(string2, ',');
        if (list.size() != 4) {
            return null;
        }
        return new Rectangle2D(h.a((String)list.get(0)), h.a((String)list.get(1)), h.a((String)list.get(2)), h.a((String)list.get(3)));
    }

    public Point getPoint(String string) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        List list = h.a(string2, ',');
        if (list.size() != 2) {
            return null;
        }
        return new Point(h.b((String)list.get(0)), h.b((String)list.get(1)));
    }

    public Dimension2D getDimension2D(String string) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        List list = h.a(string2, ',');
        if (list.size() != 2) {
            return null;
        }
        return new Dimension2D((double)h.b((String)list.get(0)), (double)h.b((String)list.get(1)));
    }

    public double[] getDoubleArray(String string) {
        Object object = this.get(string);
        if (object instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object;
            double[] dArray = new double[jSONArray.length()];
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                dArray[i2] = h.a(jSONArray.get(i2));
            }
            return dArray;
        }
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        List list = h.a(string2, ',');
        if (h.a((Collection)list)) {
            return null;
        }
        double[] dArray = new double[list.size()];
        for (int i3 = 0; i3 < list.size(); ++i3) {
            dArray[i3] = h.a((String)list.get(i3));
        }
        return dArray;
    }

    public String[] getStringArray(String string) {
        Object object = this.get(string);
        if (object instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object;
            String[] stringArray = new String[jSONArray.length()];
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                try {
                    stringArray[i2] = jSONArray.getString(i2);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return stringArray;
        }
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        List list = h.a(string2, ',');
        if (h.a((Collection)list)) {
            return null;
        }
        String[] stringArray = new String[list.size()];
        for (int i3 = 0; i3 < list.size(); ++i3) {
            stringArray[i3] = (String)list.get(i3);
        }
        return stringArray;
    }

    public String[][] getStringArray2(String string) {
        Object object = this.get(string);
        if (!(object instanceof JSONArray)) {
            return null;
        }
        JSONArray jSONArray = (JSONArray)object;
        String[][] stringArray = new String[jSONArray.length()][];
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            try {
                JSONArray jSONArray2 = jSONArray.getJSONArray(i2);
                if (jSONArray2 == null) continue;
                stringArray[i2] = jSONArray2.asStringArray();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringArray;
    }

    public boolean[] getBooleanArray(String string) {
        Object object = this.get(string);
        if (object instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object;
            boolean[] blArray = new boolean[jSONArray.length()];
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                blArray[i2] = h.c(jSONArray.get(i2));
            }
            return blArray;
        }
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        List list = h.a(string2, ',');
        if (h.a((Collection)list)) {
            return null;
        }
        boolean[] blArray = new boolean[list.size()];
        for (int i3 = 0; i3 < list.size(); ++i3) {
            blArray[i3] = h.c(list.get(i3));
        }
        return blArray;
    }

    public float[] getDash(String string) {
        Object object = this.get(string);
        if (object instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object;
            float[] fArray = new float[jSONArray.length()];
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                fArray[i2] = h.a(jSONArray.get(i2));
            }
            return fArray;
        }
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        List list = h.a(string2, ',');
        if (h.a((Collection)list)) {
            return null;
        }
        float[] fArray = new float[list.size()];
        for (int i3 = 0; i3 < list.size(); ++i3) {
            fArray[i3] = h.b((String)list.get(i3));
        }
        return fArray;
    }

    public Insets getInsets(String string) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        List list = h.a(string2, ',');
        if (h.a((Collection)list) || list.size() != 4) {
            return null;
        }
        return new Insets(h.b((String)list.get(0)), h.b((String)list.get(1)), h.b((String)list.get(2)), h.b((String)list.get(3)));
    }

    public KeyCombination getKeyCombination(String string) {
        String string2 = this.str(string);
        if (h.g(string2)) {
            return null;
        }
        List list = h.a(string2, '|');
        KeyCode keyCode = KeyCode.valueOf((String)((String)list.get(0)));
        ArrayList<KeyCombination.Modifier> arrayList = new ArrayList<KeyCombination.Modifier>();
        block14: for (int i2 = 1; i2 < list.size(); ++i2) {
            switch ((String)list.get(i2)) {
                case "A": {
                    arrayList.add(KeyCombination.ALT_DOWN);
                    continue block14;
                }
                case "C": {
                    arrayList.add(KeyCombination.CONTROL_DOWN);
                    continue block14;
                }
                case "S": {
                    arrayList.add(KeyCombination.SHIFT_DOWN);
                    continue block14;
                }
                case "M": {
                    arrayList.add(KeyCombination.META_DOWN);
                    continue block14;
                }
                case "SC": {
                    arrayList.add(KeyCombination.SHORTCUT_DOWN);
                    continue block14;
                }
            }
        }
        return new KeyCodeCombination(keyCode, arrayList.toArray(new KeyCombination.Modifier[0]));
    }

    public boolean has(String ... stringArray) {
        for (String string : stringArray) {
            if (!this.map.containsKey(string) || this.map.get(string) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isNull(String string) {
        Object object = this.opt(string);
        return object == null || NULL.equals(object);
    }

    public boolean isEmpty(String string) {
        Object object = this.opt(string);
        if (object == null || NULL.equals(object)) {
            return true;
        }
        if (object instanceof JSONArray) {
            return ((JSONArray)object).isEmpty();
        }
        return h.b(object);
    }

    boolean isNullValue(Object object) {
        return object == null || NULL.equals(object);
    }

    public JSONArray names() {
        JSONArray jSONArray = new JSONArray();
        Iterator iterator = this.keys();
        while (iterator.hasNext()) {
            jSONArray.put(iterator.next());
        }
        return jSONArray.length() == 0 ? null : jSONArray;
    }

    public Iterator keys() {
        return this.map.keySet().iterator();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int length() {
        return this.map.size();
    }

    public static String numberToString(Number number) {
        if (number == null) {
            throw new JSONException("Null pointer");
        }
        JSONObject.testValidity(number);
        String string = number.toString();
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public Object opt(String string) {
        return string == null ? null : this.map.get(string);
    }

    public JSONObject put(String string, boolean bl2) {
        this.map.put(string, bl2);
        return this;
    }

    public JSONObject put(String string, Collection collection) {
        if (collection == null) {
            this.map.put(string, null);
        } else {
            this.map.put(string, new JSONArray(collection));
        }
        return this;
    }

    public JSONObject put(String string, double d2) {
        this.map.put(string, d2);
        return this;
    }

    public JSONObject put(String string, float f2) {
        this.map.put(string, Float.valueOf(f2));
        return this;
    }

    public JSONObject put(String string, int n2) {
        this.map.put(string, n2);
        return this;
    }

    public JSONObject put(String string, long l2) {
        this.map.put(string, l2);
        return this;
    }

    public JSONObject put(String string, Object object) {
        if (object != null) {
            this.map.put(string, object);
        } else {
            this.remove(string);
        }
        return this;
    }

    public JSONObject putOnce(String string, Object object) {
        if (string != null && object != null) {
            if (this.opt(string) != null) {
                throw new JSONException("Duplicate key \"" + string + "\"");
            }
            this.put(string, object);
        }
        return this;
    }

    public JSONObject putOpt(String string, Object object) {
        if (string != null && object != null) {
            this.put(string, object);
        }
        return this;
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c2 = '\u0000';
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 + 4);
        stringBuffer.append('\"');
        block9: for (int i2 = 0; i2 < n2; ++i2) {
            char c3 = c2;
            c2 = string.charAt(i2);
            switch (c2) {
                case '\"': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c2);
                    continue block9;
                }
                case '/': {
                    if (c3 == '<') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c2);
                    continue block9;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block9;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block9;
                }
                default: {
                    if (c2 < ' ' || c2 >= '\u0080' && c2 < '\u00a0' || c2 >= '\u2000' && c2 < '\u2100') {
                        String string2 = "000" + Integer.toHexString(c2);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4));
                        continue block9;
                    }
                    stringBuffer.append(c2);
                }
            }
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public Object remove(String string) {
        return this.map.remove(string);
    }

    public void remove(String ... stringArray) {
        for (String string : stringArray) {
            this.map.remove(string);
        }
    }

    public Iterator sortedKeys() {
        return new TreeSet(this.map.keySet()).iterator();
    }

    public static Object stringToValue(String string) {
        if (string.equals("")) {
            return string;
        }
        if (string.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("null")) {
            return NULL;
        }
        char c2 = string.charAt(0);
        if (c2 >= '0' && c2 <= '9' || c2 == '.' || c2 == '-' || c2 == '+') {
            if (c2 == '0' && string.length() > 2 && (string.charAt(1) == 'x' || string.charAt(1) == 'X')) {
                try {
                    return Integer.parseInt(string.substring(2), 16);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                if (string.indexOf(46) > -1 || string.indexOf(101) > -1 || string.indexOf(69) > -1) {
                    return Double.valueOf(string);
                }
                Long l2 = Long.valueOf(string);
                if (l2 == (long)l2.intValue()) {
                    return l2.intValue();
                }
                return l2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    static void testValidity(Object object) {
        if (object != null && (object instanceof Double ? ((Double)object).isInfinite() || ((Double)object).isNaN() : object instanceof Float && (((Float)object).isInfinite() || ((Float)object).isNaN()))) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    public JSONArray toJSONArray(JSONArray jSONArray) {
        if (jSONArray == null || jSONArray.length() == 0) {
            return null;
        }
        JSONArray jSONArray2 = new JSONArray();
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            jSONArray2.put(this.opt(jSONArray.getString(i2)));
        }
        return jSONArray2;
    }

    public Map toMap() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry : this.map.entrySet()) {
            String string = (String)entry.getKey();
            Object v2 = entry.getValue();
            if (v2 == null) {
                linkedHashMap.put(string, v2);
                continue;
            }
            if (v2 instanceof JSONObject) {
                linkedHashMap.put(string, ((JSONObject)v2).toMap());
                continue;
            }
            if (v2 instanceof JSONArray) {
                linkedHashMap.put(string, ((JSONArray)v2).toList());
                continue;
            }
            linkedHashMap.put(string, v2);
        }
        return linkedHashMap;
    }

    public String toString() {
        try {
            Iterator iterator = this.keys();
            StringBuffer stringBuffer = new StringBuffer("{");
            while (iterator.hasNext()) {
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(',');
                }
                Object e2 = iterator.next();
                stringBuffer.append(JSONObject.quote(e2.toString()));
                stringBuffer.append(':');
                stringBuffer.append(JSONObject.valueToString(this.map.get(e2)));
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString(int n2) {
        return this.toString(n2, 0);
    }

    String toString(int n2, int n3) {
        int n4 = this.length();
        if (n4 == 0) {
            return "{}";
        }
        Iterator iterator = this.sortedKeys();
        StringBuffer stringBuffer = new StringBuffer("{");
        int n5 = n3 + n2;
        if (n4 == 1) {
            Object e2 = iterator.next();
            stringBuffer.append(JSONObject.quote(e2.toString()));
            stringBuffer.append(": ");
            stringBuffer.append(JSONObject.valueToString(this.map.get(e2), n2, n3));
        } else {
            int n6;
            while (iterator.hasNext()) {
                Object e3 = iterator.next();
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(",\n");
                } else {
                    stringBuffer.append('\n');
                }
                for (n6 = 0; n6 < n5; ++n6) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(JSONObject.quote(e3.toString()));
                stringBuffer.append(": ");
                stringBuffer.append(JSONObject.valueToString(this.map.get(e3), n2, n5));
            }
            if (stringBuffer.length() > 1) {
                stringBuffer.append('\n');
                for (n6 = 0; n6 < n3; ++n6) {
                    stringBuffer.append(' ');
                }
            }
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    static String valueToString(Object object) {
        if (object == null || object.equals(null)) {
            return "null";
        }
        if (object instanceof JSONString) {
            String string;
            try {
                string = ((JSONString)object).toJSONString();
            }
            catch (Exception exception) {
                throw new JSONException(exception);
            }
            if (string instanceof String) {
                return string;
            }
            throw new JSONException("Bad value from toJSONString: " + String.valueOf(string));
        }
        if (object instanceof Number) {
            return JSONObject.numberToString((Number)object);
        }
        if (object instanceof Boolean || object instanceof JSONObject || object instanceof JSONArray) {
            return object.toString();
        }
        if (object instanceof w) {
            return ((w)object).toJSON();
        }
        if (object instanceof Collection) {
            return new JSONArray((Collection)object).toString();
        }
        if (object.getClass().isArray()) {
            return new JSONArray(object).toString();
        }
        if (object instanceof String) {
            return JSONObject.quote(w.a(object));
        }
        try {
            Method method = h.a(object.getClass(), "toJson", 0);
            if (method != null) {
                Object object2 = method.invoke(object, new Object[0]);
                if (object2 == null) {
                    return "";
                }
                if (object2 instanceof Map) {
                    return w.a((Map)object2);
                }
                return JSONObject.valueToString(object2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return JSONObject.quote(w.a(object));
    }

    static String valueToString(Object object, int n2, int n3) {
        if (object == null || object.equals(null)) {
            return "null";
        }
        try {
            String string;
            if (object instanceof JSONString && (string = ((JSONString)object).toJSONString()) instanceof String) {
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object instanceof Number) {
            return JSONObject.numberToString((Number)object);
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof JSONObject) {
            return ((JSONObject)object).toString(n2, n3);
        }
        if (object instanceof JSONArray) {
            return ((JSONArray)object).toString(n2, n3);
        }
        if (object instanceof Collection) {
            return new JSONArray((Collection)object).toString(n2, n3);
        }
        if (object.getClass().isArray()) {
            return new JSONArray(object).toString(n2, n3);
        }
        return JSONObject.quote(object.toString());
    }

    static Object wrap(Object object) {
        try {
            if (object == null) {
                return NULL;
            }
            if (object instanceof Map) {
                return new JSONObject((Map)object);
            }
            if (object instanceof List) {
                return new JSONArray((List)object);
            }
            if (object instanceof JSONObject || object instanceof JSONArray || NULL.equals(object) || object instanceof JSONString || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String || object instanceof w) {
                return object;
            }
            if (object instanceof Collection) {
                return new JSONArray((Collection)object);
            }
            if (object.getClass().isArray()) {
                return new JSONArray(object);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Writer write(Writer writer) {
        try {
            boolean bl2 = false;
            Iterator iterator = this.keys();
            writer.write(123);
            while (iterator.hasNext()) {
                if (bl2) {
                    writer.write(44);
                }
                Object e2 = iterator.next();
                writer.write(JSONObject.quote(e2.toString()));
                writer.write(58);
                Object v2 = this.map.get(e2);
                if (v2 instanceof JSONObject) {
                    ((JSONObject)v2).write(writer);
                } else if (v2 instanceof JSONArray) {
                    ((JSONArray)v2).write(writer);
                } else {
                    writer.write(JSONObject.valueToString(v2));
                }
                bl2 = true;
            }
            writer.write(125);
            return writer;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException);
        }
    }
}

