/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.validation.decoration;

import java.util.Collection;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import org.controlsfx.control.decoration.Decoration;
import org.controlsfx.control.decoration.Decorator;
import org.controlsfx.validation.ValidationMessage;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.decoration.ValidationDecoration;

public abstract class AbstractValidationDecoration
implements ValidationDecoration {
    private static final String VALIDATION_DECORATION = "$org.controlsfx.decoration.vaidation$";

    private static boolean isValidationDecoration(Decoration decoration) {
        return decoration != null && decoration.getProperties().get(VALIDATION_DECORATION) == Boolean.TRUE;
    }

    private static void setValidationDecoration(Decoration decoration) {
        if (decoration != null) {
            decoration.getProperties().put(VALIDATION_DECORATION, Boolean.TRUE);
        }
    }

    protected abstract Collection createValidationDecorations(ValidationMessage var1);

    protected abstract Collection createRequiredDecorations(Control var1);

    @Override
    public void removeDecorations(Control control) {
        ObservableList observableList = Decorator.getDecorations((Node)control);
        if (observableList != null) {
            for (Decoration decoration : (Decoration[])Decorator.getDecorations((Node)control).toArray((Object[])new Decoration[0])) {
                if (!AbstractValidationDecoration.isValidationDecoration(decoration)) continue;
                Decorator.removeDecoration((Node)control, decoration);
            }
        }
    }

    @Override
    public void applyValidationDecoration(ValidationMessage validationMessage) {
        this.createValidationDecorations(validationMessage).stream().forEach(decoration -> this.decorate(validationMessage.getTarget(), (Decoration)decoration));
    }

    @Override
    public void applyRequiredDecoration(Control control) {
        if (ValidationSupport.isRequired(control)) {
            this.createRequiredDecorations(control).stream().forEach(decoration -> this.decorate(control, (Decoration)decoration));
        }
    }

    private void decorate(Control control, Decoration decoration) {
        AbstractValidationDecoration.setValidationDecoration(decoration);
        Decorator.addDecoration((Node)control, decoration);
    }
}

