/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.validation;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.scene.control.Control;
import org.controlsfx.tools.ValueExtractor;
import org.controlsfx.validation.ValidationMessage;
import org.controlsfx.validation.ValidationResult;
import org.controlsfx.validation.ValidationSupport$1;
import org.controlsfx.validation.ValidationSupport$2;
import org.controlsfx.validation.ValidationSupport$3;
import org.controlsfx.validation.Validator;
import org.controlsfx.validation.decoration.GraphicValidationDecoration;
import org.controlsfx.validation.decoration.ValidationDecoration;

public class ValidationSupport {
    private static final String CTRL_REQUIRED_FLAG = "$org.controlsfx.validation.required$";
    private ObservableSet controls = FXCollections.observableSet((Object[])new Control[0]);
    private ObservableMap validationResults = FXCollections.observableMap(new WeakHashMap());
    private AtomicBoolean dataChanged = new AtomicBoolean(false);
    private BooleanProperty errorDecorationEnabledProperty = new ValidationSupport$1(this, true);
    private ReadOnlyObjectWrapper validationResultProperty = new ReadOnlyObjectWrapper();
    private BooleanProperty invalidProperty = new SimpleBooleanProperty();
    private ObjectProperty validationDecoratorProperty = new ValidationSupport$2(this, this, "validationDecorator", new GraphicValidationDecoration());

    public static void setRequired(Control control, boolean bl2) {
        control.getProperties().put((Object)CTRL_REQUIRED_FLAG, (Object)bl2);
    }

    public static boolean isRequired(Control control) {
        Object object = control.getProperties().get((Object)CTRL_REQUIRED_FLAG);
        return object instanceof Boolean ? (Boolean)object : false;
    }

    public ValidationSupport() {
        this.validationResultProperty().addListener((observableValue, validationResult, validationResult2) -> {
            this.invalidProperty.set(!validationResult2.getErrors().isEmpty());
            this.redecorate();
        });
        this.validationResults.addListener(change -> this.validationResultProperty.set((Object)ValidationResult.fromResults(this.validationResults.values())));
    }

    public void initInitialDecoration() {
        this.dataChanged.set(true);
        this.redecorate();
    }

    public void redecorate() {
        try {
            Optional<ValidationDecoration> optional = Optional.ofNullable(this.getValidationDecorator());
            for (Control control : this.getRegisteredControls()) {
                optional.ifPresent(validationDecoration -> {
                    validationDecoration.removeDecorations(control);
                    validationDecoration.applyRequiredDecoration(control);
                    if (this.dataChanged.get() && this.isErrorDecorationEnabled()) {
                        this.getHighestMessage(control).ifPresent(validationMessage -> validationDecoration.applyValidationDecoration((ValidationMessage)validationMessage));
                    }
                });
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void clear() {
        this.controls.clear();
        this.validationResults.clear();
    }

    public BooleanProperty errorDecorationEnabledProperty() {
        return this.errorDecorationEnabledProperty;
    }

    public void setErrorDecorationEnabled(boolean bl2) {
        this.errorDecorationEnabledProperty.set(bl2);
    }

    private boolean isErrorDecorationEnabled() {
        return this.errorDecorationEnabledProperty.get();
    }

    public ValidationResult getValidationResult() {
        return (ValidationResult)this.validationResultProperty.get();
    }

    public ReadOnlyObjectProperty validationResultProperty() {
        return this.validationResultProperty.getReadOnlyProperty();
    }

    public Boolean isInvalid() {
        return this.invalidProperty.get();
    }

    public ReadOnlyBooleanProperty invalidProperty() {
        return this.invalidProperty;
    }

    public ObjectProperty validationDecoratorProperty() {
        return this.validationDecoratorProperty;
    }

    public ValidationDecoration getValidationDecorator() {
        return (ValidationDecoration)this.validationDecoratorProperty.get();
    }

    public void setValidationDecorator(ValidationDecoration validationDecoration) {
        this.validationDecoratorProperty.set((Object)validationDecoration);
    }

    public boolean registerValidator(Control control2, boolean bl2, Validator validator) {
        Optional.ofNullable(control2).ifPresent(control -> control.getProperties().addListener((MapChangeListener)new ValidationSupport$3(this)));
        ValidationSupport.setRequired(control2, bl2);
        return ValueExtractor.getObservableValueExtractor(control2).map(callback -> {
            ObservableValue observableValue2 = (ObservableValue)callback.call((Object)control2);
            Consumer<Object> consumer = object -> Platform.runLater(() -> this.validationResults.put((Object)control2, (Object)((ValidationResult)validator.apply(control2, object))));
            this.controls.add((Object)control2);
            observableValue2.addListener((observableValue, object, object2) -> {
                this.dataChanged.set(true);
                consumer.accept(object2);
            });
            consumer.accept(observableValue2.getValue());
            return callback;
        }).isPresent();
    }

    public boolean registerValidator(Control control, Validator validator) {
        return this.registerValidator(control, true, validator);
    }

    public Set getRegisteredControls() {
        return Collections.unmodifiableSet(this.controls);
    }

    public Optional getHighestMessage(Control control) {
        return Optional.ofNullable((ValidationResult)this.validationResults.get((Object)control)).flatMap(validationResult -> validationResult.getMessages().stream().max(ValidationMessage.COMPARATOR));
    }
}

