/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.scene.control.Control;
import org.controlsfx.validation.Severity;
import org.controlsfx.validation.SimpleValidationMessage;
import org.controlsfx.validation.ValidationMessage;

public class ValidationResult {
    private List errors = new ArrayList();
    private List warnings = new ArrayList();

    public static final ValidationResult fromMessageIf(Control control, String string, Severity severity, boolean bl2) {
        return new ValidationResult().addMessageIf(control, string, severity, bl2);
    }

    public static final ValidationResult fromErrorIf(Control control, String string, boolean bl2) {
        return new ValidationResult().addErrorIf(control, string, bl2);
    }

    public static final ValidationResult fromWarningIf(Control control, String string, boolean bl2) {
        return new ValidationResult().addWarningIf(control, string, bl2);
    }

    public static final ValidationResult fromError(Control control, String string) {
        return ValidationResult.fromMessages(ValidationMessage.error(control, string));
    }

    public static final ValidationResult fromWarning(Control control, String string) {
        return ValidationResult.fromMessages(ValidationMessage.warning(control, string));
    }

    public static final ValidationResult fromMessages(ValidationMessage ... validationMessageArray) {
        return new ValidationResult().addAll(validationMessageArray);
    }

    public static final ValidationResult fromMessages(Collection collection) {
        return new ValidationResult().addAll(collection);
    }

    public static final ValidationResult fromResults(ValidationResult ... validationResultArray) {
        return new ValidationResult().combineAll(validationResultArray);
    }

    public static final ValidationResult fromResults(Collection collection) {
        return new ValidationResult().combineAll(collection);
    }

    public ValidationResult copy() {
        return ValidationResult.fromMessages(this.getMessages());
    }

    public ValidationResult add(ValidationMessage validationMessage) {
        if (validationMessage != null) {
            switch (validationMessage.getSeverity()) {
                case ERROR: {
                    this.errors.add(validationMessage);
                    break;
                }
                case WARNING: {
                    this.warnings.add(validationMessage);
                    break;
                }
            }
        }
        return this;
    }

    public ValidationResult addMessageIf(Control control, String string, Severity severity, boolean bl2) {
        return bl2 ? this.add(new SimpleValidationMessage(control, string, severity)) : this;
    }

    public ValidationResult addErrorIf(Control control, String string, boolean bl2) {
        return this.addMessageIf(control, string, Severity.ERROR, bl2);
    }

    public ValidationResult addWarningIf(Control control, String string, boolean bl2) {
        return this.addMessageIf(control, string, Severity.WARNING, bl2);
    }

    public ValidationResult addAll(Collection collection) {
        collection.stream().forEach(validationMessage -> this.add((ValidationMessage)validationMessage));
        return this;
    }

    public ValidationResult addAll(ValidationMessage ... validationMessageArray) {
        return this.addAll(Arrays.asList(validationMessageArray));
    }

    public ValidationResult combine(ValidationResult validationResult) {
        return validationResult == null ? this.copy() : this.copy().addAll(validationResult.getMessages());
    }

    public ValidationResult combineAll(Collection collection) {
        return collection.stream().reduce(this.copy(), (validationResult, validationResult2) -> validationResult2 == null ? validationResult : validationResult.addAll(validationResult2.getMessages()));
    }

    public ValidationResult combineAll(ValidationResult ... validationResultArray) {
        return this.combineAll(Arrays.asList(validationResultArray));
    }

    public Collection getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public Collection getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    public Collection getMessages() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.errors);
        arrayList.addAll(this.warnings);
        return Collections.unmodifiableList(arrayList);
    }
}

