/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.skin;

import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.ComboBoxListViewSkin;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;
import org.controlsfx.control.TimePicker;
import org.controlsfx.control.skin.TimePickerContent;

public class TimePickerSkin
extends ComboBoxListViewSkin {
    private TimePicker timePicker;
    private TextField textFieldLocalTime;
    private TimePickerContent timePickerContent;
    private boolean updatingFromTextField = false;
    private static PseudoClass CONTAINS_FOCUS_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"contains-focus");

    public TimePickerSkin(TimePicker timePicker) {
        super((ComboBox)timePicker);
        this.timePicker = timePicker;
        this.textFieldLocalTime = timePicker.getEditor();
        this.initializeTextField();
        this.timePickerContent = new TimePickerContent(timePicker);
        timePicker.focusedProperty().addListener(observable -> this.updateTimePickerValueFromTextFieldText());
        this.textFieldLocalTime.addEventFilter(KeyEvent.ANY, keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER || keyEvent.getCode() == KeyCode.TAB) {
                this.updateTimePickerValueFromTextFieldText();
            }
        });
        timePicker.valueProperty().addListener((observableValue, localTime, localTime2) -> {
            if (this.updatingFromTextField) {
                return;
            }
            this.updateTextFieldTextFromTimePickerValue();
        });
    }

    public Node getPopupContent() {
        return this.timePickerContent;
    }

    protected void handleControlPropertyChanged(String string) {
        if ("CONVERTER".equals(string)) {
            this.updateTextFieldTextFromTimePickerValue();
        } else if ("SHOWING".equals(string)) {
            if (this.timePicker.isShowing()) {
                this.show();
            } else {
                this.hide();
            }
        } else if ("VALUE".equals(string)) {
            this.updateTextFieldTextFromTimePickerValue();
        } else if ("PRECISION".equals(string)) {
            this.timePickerContent.updateContent();
        }
    }

    public Node getDisplayNode() {
        return this.textFieldLocalTime;
    }

    protected TextField getEditor() {
        return ((TimePicker)this.getSkinnable()).getEditor();
    }

    protected StringConverter getConverter() {
        return ((TimePicker)this.getSkinnable()).getConverter();
    }

    public void hideTimePickerOnPopupHiding() {
        if (this.timePicker.isShowing()) {
            this.timePicker.hide();
        }
    }

    private void initializeTextField() {
        this.textFieldLocalTime.getStyleClass().add((Object)"date-picker-display-node");
        this.textFieldLocalTime.editableProperty().bindBidirectional((Property)this.timePicker.editableProperty());
        this.textFieldLocalTime.focusTraversableProperty().bindBidirectional((Property)this.timePicker.focusTraversableProperty());
        this.textFieldLocalTime.promptTextProperty().bind((ObservableValue)this.timePicker.promptTextProperty());
        this.textFieldLocalTime.focusedProperty().addListener(observable -> {
            if (this.textFieldLocalTime.isFocused()) {
                this.pseudoClassStateChanged(CONTAINS_FOCUS_PSEUDOCLASS_STATE, true);
            } else {
                this.updateTimePickerValueFromTextFieldText();
                this.pseudoClassStateChanged(CONTAINS_FOCUS_PSEUDOCLASS_STATE, false);
            }
        });
        this.updateTextFieldTextFromTimePickerValue();
    }

    private void updateTextFieldTextFromTimePickerValue() {
        if (this.textFieldLocalTime != null) {
            LocalTime localTime = (LocalTime)this.timePicker.getValue();
            StringConverter stringConverter = this.timePicker.getConverter();
            if (localTime != null && stringConverter != null) {
                this.textFieldLocalTime.setText(stringConverter.toString((Object)localTime));
            } else {
                this.textFieldLocalTime.setText("");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTimePickerValueFromTextFieldText() {
        this.updatingFromTextField = true;
        try {
            StringConverter stringConverter = this.timePicker.getConverter();
            LocalTime localTime = (LocalTime)this.timePicker.getValue();
            String string = this.textFieldLocalTime.getText();
            if (string == null || string.isEmpty()) {
                localTime = null;
            } else {
                try {
                    localTime = (LocalTime)stringConverter.fromString(string);
                }
                catch (DateTimeParseException dateTimeParseException) {
                    // empty catch block
                }
            }
            this.timePicker.setValue(localTime);
            this.updateTextFieldTextFromTimePickerValue();
        }
        finally {
            this.updatingFromTextField = false;
        }
    }
}

