/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.skin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import org.controlsfx.control.decoration.Decoration;
import org.controlsfx.control.skin.DecorationPane$1;

public class DecorationPane
extends StackPane {
    private final Map nodeDecorationMap = new WeakHashMap();
    ChangeListener visibilityListener = new DecorationPane$1(this);

    public DecorationPane() {
        this.setBackground(null);
    }

    public void setRoot(Node node) {
        this.getChildren().setAll((Object[])new Node[]{node});
    }

    public void updateDecorationsOnNode(Node node, List list, List list2) {
        this.removeAllDecorationsOnNode(node, list2);
        this.addAllDecorationsOnNode(node, list);
    }

    private void showDecoration(Node node, Decoration decoration) {
        Node node2 = decoration.applyDecoration(node);
        if (node2 != null) {
            ArrayList<Node> arrayList = (ArrayList<Node>)this.nodeDecorationMap.get(node);
            if (arrayList == null) {
                arrayList = new ArrayList<Node>();
                this.nodeDecorationMap.put(node, arrayList);
            }
            arrayList.add(node2);
            if (!this.getChildren().contains((Object)node2)) {
                this.getChildren().add((Object)node2);
                StackPane.setAlignment((Node)node2, (Pos)Pos.TOP_LEFT);
            }
        }
        node.visibleProperty().addListener(this.visibilityListener);
    }

    private void removeAllDecorationsOnNode(Node node, List list) {
        if (list == null || node == null) {
            return;
        }
        List list2 = (List)this.nodeDecorationMap.remove(node);
        if (list2 != null) {
            for (Object object : list2) {
                boolean bl2 = this.getChildren().remove(object);
                if (bl2) continue;
                throw new IllegalStateException("Could not remove decoration " + String.valueOf(object) + " from decoration pane children list: " + String.valueOf(this.getChildren()));
            }
        }
        for (Object object : list) {
            ((Decoration)object).removeDecoration(node);
        }
    }

    private void addAllDecorationsOnNode(Node node, List list) {
        if (list == null) {
            return;
        }
        for (Decoration decoration : list) {
            this.showDecoration(node, decoration);
        }
    }
}

