/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.i18n;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Localization {
    public static final String KEY_PREFIX = "@@";
    private static final String LOCALE_BUNDLE_NAME = "controlsfx";
    private static Locale locale = null;
    private static Locale resourceBundleLocale = null;
    private static ResourceBundle resourceBundle = null;

    private Localization() {
    }

    public static final Locale getLocale() {
        return locale == null ? Locale.getDefault() : locale;
    }

    public static final void setLocale(Locale locale) {
        Localization.locale = locale;
    }

    private static final synchronized ResourceBundle getLocaleBundle() {
        Locale locale = Localization.getLocale();
        if (!locale.equals(resourceBundleLocale)) {
            resourceBundleLocale = locale;
            resourceBundle = ResourceBundle.getBundle(LOCALE_BUNDLE_NAME, resourceBundleLocale, Localization.class.getClassLoader());
        }
        return resourceBundle;
    }

    public static final String getString(String string) {
        try {
            return Localization.getLocaleBundle().getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return String.format("<%s>", string);
        }
    }

    public static final String asKey(String string) {
        return KEY_PREFIX + string;
    }

    public static final boolean isKey(String string) {
        return string != null && string.startsWith(KEY_PREFIX);
    }

    public static String localize(String string) {
        return Localization.isKey(string) ? Localization.getString(string.substring(KEY_PREFIX.length()).trim()) : string;
    }
}

