/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.ui.draw.graph;

import com.motivewave.common.h;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.TradingHours;
import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.ui.draw.graph.TimeAxis;
import java.util.TimeZone;

enum TimeAxis$Interval {
    YEAR,
    M6,
    MONTH,
    WEEK,
    DAY,
    OPEN_CLOSE,
    HOUR,
    M30,
    M15,
    M5,
    M1,
    S15,
    S5,
    S1;


    long millis() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 31557600000L;
            case 1 -> 16070400000L;
            case 2 -> 2678400000L;
            case 3 -> 604800000L;
            case 4 -> 86400000L;
            case 5 -> 43200000L;
            case 6 -> 3600000L;
            case 7 -> 1800000L;
            case 8 -> 900000L;
            case 9 -> 300000L;
            case 10 -> 60000L;
            case 11 -> 15000L;
            case 12 -> 5000L;
            case 13 -> 1000L;
        };
    }

    String format(BarSize barSize, long l2, TimeZone timeZone) {
        switch (this.ordinal()) {
            case 0: {
                return TimeAxis.a(TimeAxis.b, timeZone, l2);
            }
            case 1: 
            case 2: {
                if (!barSize.isIntraday() || h.b(l2, timeZone) == h.b(System.currentTimeMillis(), timeZone)) {
                    return TimeAxis.a(TimeAxis.d, timeZone, l2);
                }
                return TimeAxis.a(TimeAxis.e, timeZone, l2);
            }
            case 3: 
            case 4: {
                return TimeAxis.a(TimeAxis.c, timeZone, l2);
            }
            case 11: 
            case 12: 
            case 13: {
                return TimeAxis.a(TimeAxis.h, timeZone, l2);
            }
        }
        if (l2 % 60000L == 0L) {
            return TimeAxis.a(TimeAxis.g, timeZone, l2);
        }
        return TimeAxis.a(TimeAxis.h, timeZone, l2);
    }

    TimeAxis$Interval nextLower() {
        int n2 = this.ordinal() + 1;
        if (n2 >= TimeAxis$Interval.values().length) {
            return null;
        }
        return TimeAxis$Interval.values()[n2];
    }

    long startPeriod(long l2, TimeZone timeZone, MWInstrument mWInstrument, boolean bl2) {
        switch (this.ordinal()) {
            case 0: {
                return h.n(l2, timeZone);
            }
            case 1: {
                return h.l(l2, timeZone);
            }
            case 2: {
                return h.k(l2, timeZone);
            }
            case 3: {
                long l3 = h.i(l2, timeZone);
                TradingHours tradingHours = mWInstrument.getTradingHours();
                return tradingHours != null && tradingHours.isTradeOnSunday(bl2) ? l3 : h.w(l3, timeZone);
            }
            case 4: {
                return h.a(l2, timeZone);
            }
            case 5: {
                return mWInstrument.getStartOfDay(l2, bl2);
            }
        }
        return l2;
    }

    long nextPeriod(long l2, TimeZone timeZone, MWInstrument mWInstrument, boolean bl2) {
        switch (this.ordinal()) {
            case 0: {
                return h.o(l2, timeZone);
            }
            case 1: {
                return h.m(l2, timeZone);
            }
            case 2: {
                return h.p(l2, timeZone);
            }
            case 3: {
                long l3 = h.j(l2, timeZone);
                TradingHours tradingHours = mWInstrument.getTradingHours();
                return tradingHours != null && tradingHours.isTradeOnSunday(bl2) ? l3 : h.w(l3, timeZone);
            }
            case 4: {
                return h.w(l2, timeZone);
            }
            case 5: {
                long l4 = mWInstrument.getEndOfDay(l2, bl2);
                if (l4 > l2) {
                    return l4;
                }
                return mWInstrument.getEndOfNextDay(l2, bl2);
            }
        }
        return l2 + this.millis();
    }
}

