/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.williams;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.williams.AwesomeOsc$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="AWESOME_OSC", rb="com.motivewave.platform.study.nls.strings", name="TITLE_AWESOME_OSC", label="LBL_AWESOME_OSC", desc="DESC_AWESOME_OSC", menu="MENU_BILL_WILLIAMS", overlay=false, helpLink="http://www.motivewave.com/studies/awesome_oscillator.htm")
public class AwesomeOsc
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.MIDPOINT)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("slowPeriod", this.get("LBL_SLOW_PERIOD", new Object[0]), 34, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("fastPeriod", this.get("LBL_FAST_PERIOD", new Object[0]), 5, 1, 9999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_SETTINGS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("LBL_UP_COLOR", new Object[0]), defaults.getGreen())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("LBL_DOWN_COLOR", new Object[0]), defaults.getRed())});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("slowPeriod", this.get("LBL_SLOW_PERIOD", new Object[0]), 34, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("fastPeriod", this.get("LBL_FAST_PERIOD", new Object[0]), 5, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"upColor", "downColor"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"slowPeriod", "fastPeriod"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)AwesomeOsc$Values.VAL, this.get("LBL_AWE", new Object[0]), new String[]{"input", "method", "slowPeriod", "fastPeriod"}));
        runtimeDescriptor.declareBars((Object)AwesomeOsc$Values.VAL);
        runtimeDescriptor.declareIndicator((Object)AwesomeOsc$Values.VAL, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{AwesomeOsc$Values.VAL});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("slowPeriod", 34);
        int n4 = this.getSettings().getInteger("fastPeriod", 5);
        if (n2 <= n3) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        Object object = this.getSettings().getInput("input");
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.ma(mAMethod, n2, n3, object);
        Double d3 = dataSeries.ma(mAMethod, n2, n4, object);
        if (d2 == null || d2.isNaN() || d3 == null || d3.isNaN()) {
            return;
        }
        Color color = this.getSettings().getColor("upColor");
        Color color2 = this.getSettings().getColor("downColor");
        double d4 = d3 - d2;
        dataSeries.setDouble(n2, (Object)AwesomeOsc$Values.VAL, Double.valueOf(d4));
        Double d5 = dataSeries.getDouble(n2 - 1, (Object)AwesomeOsc$Values.VAL);
        Color color3 = color;
        if (d5 != null && d5 > d4) {
            color3 = color2;
        }
        dataSeries.setBarColor(n2, (Object)AwesomeOsc$Values.VAL, color3);
        dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
    }
}

