/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.wilder;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.X11Colors;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.wilder.ParabolicSAR$Signals;
import com.motivewave.platform.study.wilder.ParabolicSAR$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="PSAR", rb="com.motivewave.platform.study.nls.strings", name="TITLE_PSAR", label="LBL_PSAR", desc="DESC_PSAR", menu="MENU_OVERLAY", menu2="MENU_WELLES_WILDER", overlay=true, signals=true, helpLink="http://www.motivewave.com/studies/parabolic_sar.htm")
public class ParabolicSAR
extends Study {
    static final String b = "initialAF";
    static final String c = "maxAF";
    static final String d = "step";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        this.a(settingTab);
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{b, c, d});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ParabolicSAR$Values.SAR, this.get("LBL_PSAR", new Object[0]), new String[]{b, c, d}));
        runtimeDescriptor.declarePath((Object)ParabolicSAR$Values.SAR, "line");
        runtimeDescriptor.declareIndicator((Object)ParabolicSAR$Values.SAR, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{ParabolicSAR$Values.SAR});
        runtimeDescriptor.declareSignal((Object)ParabolicSAR$Signals.SAR_LONG, this.get("LBL_SAR_LONG", new Object[0]));
        runtimeDescriptor.declareSignal((Object)ParabolicSAR$Signals.SAR_SHORT, this.get("LBL_SAR_SHORT", new Object[0]));
    }

    protected void a(SettingTab settingTab) {
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(b, this.get("LBL_INITIAL_AF", new Object[0]), 0.02, 0.001, 9.999, 0.001)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(c, this.get("LBL_MAX_AF", new Object[0]), 0.2, 0.001, 9.999, 0.001)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(d, this.get("LBL_STEP", new Object[0]), 0.02, 0.001, 9.999, 0.001)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_LINES", new Object[0]));
        Color color = Util.awtColor((int)95, (int)165, (int)220);
        PathDescriptor pathDescriptor = new PathDescriptor("line", this.get("LBL_PSAR", new Object[0]), color, Enums.PointType.DOT, Enums.Size.SMALL, true, true, false);
        pathDescriptor.setSupportsMaxPoints(true);
        pathDescriptor.setSupportsColorPolicy(false);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), color, X11Colors.WHITE, false, false, true)});
        SettingsDescriptor settingsDescriptor = this.getSettingsDescriptor();
        settingsDescriptor.addQuickSettings(new String[]{b, c, d, "line"});
    }

    protected void calculate(int n2, DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        if (n2 < 1) {
            return;
        }
        double d2 = this.getSettings().getDouble(b, 0.02);
        double d3 = this.getSettings().getDouble(c, 0.2);
        double d4 = this.getSettings().getDouble(d, 0.02);
        Instrument instrument = dataContext.getInstrument();
        boolean bl2 = n2 == dataSeries.size() - 1;
        double d5 = instrument.round((double)dataSeries.getHigh(n2));
        double d6 = instrument.round((double)dataSeries.getLow(n2));
        double d7 = instrument.round((double)dataSeries.getHigh(n2 - 1));
        double d8 = instrument.round((double)dataSeries.getLow(n2 - 1));
        double d9 = instrument.round((double)dataSeries.getHigh(n2 - 2));
        double d10 = instrument.round((double)dataSeries.getLow(n2 - 2));
        if (n2 == 1) {
            dataSeries.setDouble(n2, (Object)ParabolicSAR$Values.SAR, Double.valueOf(d7));
            dataSeries.setDouble(n2, (Object)ParabolicSAR$Values.AF, Double.valueOf(d2));
            dataSeries.setDouble(n2, (Object)ParabolicSAR$Values.EP, Double.valueOf(d7));
            dataSeries.setBoolean(n2, (Object)ParabolicSAR$Values.LONG, Boolean.valueOf(false));
            dataSeries.setComplete(n2, true);
            return;
        }
        Double d11 = dataSeries.getDouble(n2 - 1, (Object)ParabolicSAR$Values.SAR);
        if (d11 == null) {
            return;
        }
        double d12 = dataSeries.getDouble(n2 - 1, (Object)ParabolicSAR$Values.AF);
        double d13 = dataSeries.getDouble(n2 - 1, (Object)ParabolicSAR$Values.EP);
        boolean bl3 = dataSeries.getBoolean(n2 - 1, (Object)ParabolicSAR$Values.LONG);
        double d14 = d11;
        double d15 = d13;
        double d16 = d12;
        double d17 = d11;
        if (bl3 && d6 < d11) {
            if (d15 < d5) {
                d15 = d5;
            }
            dataSeries.setDouble(n2, (Object)ParabolicSAR$Values.SAR, Double.valueOf(d15));
            dataSeries.setDouble(n2, (Object)ParabolicSAR$Values.AF, Double.valueOf(d2));
            dataSeries.setDouble(n2, (Object)ParabolicSAR$Values.EP, Double.valueOf(Math.min(d6, d8)));
            dataSeries.setBoolean(n2, (Object)ParabolicSAR$Values.LONG, Boolean.valueOf(false));
            dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
            dataSeries.setBoolean(n2, (Object)ParabolicSAR$Signals.SAR_LONG, Boolean.valueOf(true));
            if (!bl2) {
                dataContext.signal(n2, (Object)ParabolicSAR$Signals.SAR_LONG, this.get("SIGNAL_SAR_LONG", new Object[]{instrument.format(d6), instrument.format(d17)}), (Object)d6);
            }
            return;
        }
        if (!bl3 && d5 > d11) {
            if (d15 > d6) {
                d15 = d6;
            }
            dataSeries.setDouble(n2, (Object)ParabolicSAR$Values.SAR, Double.valueOf(d15));
            dataSeries.setDouble(n2, (Object)ParabolicSAR$Values.AF, Double.valueOf(d2));
            dataSeries.setDouble(n2, (Object)ParabolicSAR$Values.EP, Double.valueOf(Math.max(d5, d7)));
            dataSeries.setBoolean(n2, (Object)ParabolicSAR$Values.LONG, Boolean.valueOf(true));
            dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
            dataSeries.setBoolean(n2, (Object)ParabolicSAR$Signals.SAR_SHORT, Boolean.valueOf(true));
            if (!bl2) {
                dataContext.signal(n2, (Object)ParabolicSAR$Signals.SAR_SHORT, this.get("SIGNAL_SAR_SHORT", new Object[]{instrument.format(d5), instrument.format(d17)}), (Object)d5);
            }
            return;
        }
        if (bl3) {
            d14 = d11 + d12 * (d13 - d11);
            if (d15 < d5 && d16 + d4 <= d3) {
                d16 += d4;
            }
            if (d14 > d8) {
                d14 = d8;
            }
            if (d14 > d10) {
                d14 = d10;
            }
            if (d14 > d6) {
                if (d15 < d5) {
                    d15 = d5;
                }
                dataSeries.setDouble(n2, (Object)ParabolicSAR$Values.SAR, Double.valueOf(d15));
                dataSeries.setDouble(n2, (Object)ParabolicSAR$Values.AF, Double.valueOf(d2));
                dataSeries.setDouble(n2, (Object)ParabolicSAR$Values.EP, Double.valueOf(Math.min(d6, d8)));
                dataSeries.setBoolean(n2, (Object)ParabolicSAR$Values.LONG, Boolean.valueOf(false));
                dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
                dataSeries.setBoolean(n2, (Object)ParabolicSAR$Signals.SAR_LONG, Boolean.valueOf(true));
                if (!bl2) {
                    dataContext.signal(n2, (Object)ParabolicSAR$Signals.SAR_LONG, this.get("SIGNAL_SAR_LONG", new Object[]{instrument.format(d6), instrument.format(d14)}), (Object)d6);
                }
                return;
            }
            if (d15 < d5) {
                d15 = d5;
            }
        } else {
            d14 = d11 - d12 * (d11 - d13);
            if (d15 > d6 && d16 + d4 <= d3) {
                d16 += d4;
            }
            if (d14 < d7) {
                d14 = d7;
            }
            if (d14 < d9) {
                d14 = d9;
            }
            if (d14 < d5) {
                if (d15 > d6) {
                    d15 = d6;
                }
                dataSeries.setDouble(n2, (Object)ParabolicSAR$Values.SAR, Double.valueOf(d15));
                dataSeries.setDouble(n2, (Object)ParabolicSAR$Values.AF, Double.valueOf(d2));
                dataSeries.setDouble(n2, (Object)ParabolicSAR$Values.EP, Double.valueOf(Math.max(d5, d7)));
                dataSeries.setBoolean(n2, (Object)ParabolicSAR$Values.LONG, Boolean.valueOf(true));
                dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
                dataSeries.setBoolean(n2, (Object)ParabolicSAR$Signals.SAR_SHORT, Boolean.valueOf(true));
                if (!bl2) {
                    dataContext.signal(n2, (Object)ParabolicSAR$Signals.SAR_SHORT, this.get("SIGNAL_SAR_SHORT", new Object[]{instrument.format(d5), instrument.format(d17)}), (Object)d5);
                }
                return;
            }
            if (d15 > d6) {
                d15 = d6;
            }
        }
        dataSeries.setDouble(n2, (Object)ParabolicSAR$Values.SAR, Double.valueOf(d14));
        dataSeries.setDouble(n2, (Object)ParabolicSAR$Values.AF, Double.valueOf(d16));
        dataSeries.setDouble(n2, (Object)ParabolicSAR$Values.EP, Double.valueOf(d15));
        dataSeries.setBoolean(n2, (Object)ParabolicSAR$Values.LONG, Boolean.valueOf(bl3));
        dataSeries.setComplete(n2);
    }
}

