/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.volume;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.volume.Vpci$Signals;
import com.motivewave.platform.study.volume.Vpci$Values;

@StudyHeader(namespace="com.motivewave", id="VPCI", rb="com.motivewave.platform.study.nls.strings2", label="LBL_VPCI", name="TITLE_VPCI", desc="DESC_VPCI", overlay=false, menu="MENU_VOLUME_BASED", requiresVolume=true, studyOverlay=true, signals=true)
public class Vpci
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_SHORT_PERIOD", new Object[0]), 7, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("LBL_LONG_PERIOD", new Object[0]), 28, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("signalPeriod", this.get("LBL_SIGNAL_PERIOD", new Object[0]), 20, 1, 9999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_VPCI_PATH", new Object[0]), defaults.getLineColor(), 1.5f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("LBL_TOP_FILL", new Object[0]), "line", 0.0, Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("LBL_BOTTOM_FILL", new Object[0]), "line", 0.0, Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("signalLine", this.get("LBL_SIGNAL_PATH", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_ADVANCED", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("LBL_MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_BULLISH_CROSS", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_BEARISH_CROSS", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_VPCI_IND", new Object[0]), null, null, false, true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new IndicatorDescriptor("signalInd", this.get("LBL_SIGNAL_IND", new Object[0]), defaults.getRed(), null, false, false, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_SHORT_PERIOD", new Object[0]), 7, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("LBL_LONG_PERIOD", new Object[0]), 28, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("signalPeriod", this.get("LBL_SIGNAL_PERIOD", new Object[0]), 20, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "topFill", "bottomFill", "signalLine"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"period", "period2", "signalPeriod"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Vpci$Values.VPCI, this.get("LBL_VPCI", new Object[0]), new String[]{"period", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Vpci$Values.SIGNAL, this.get("LBL_VPCI_SIGNAL", new Object[0]), new String[]{"signalPeriod"}));
        runtimeDescriptor.declarePath((Object)Vpci$Values.VPCI, "line");
        runtimeDescriptor.declarePath((Object)Vpci$Values.SIGNAL, "signalLine");
        runtimeDescriptor.declareIndicator((Object)Vpci$Values.VPCI, "ind");
        runtimeDescriptor.declareIndicator((Object)Vpci$Values.SIGNAL, "signalInd");
        runtimeDescriptor.setRangeKeys(new Object[]{Vpci$Values.VPCI});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
        runtimeDescriptor.declareSignal((Object)Vpci$Signals.BULLISH_CROSS, this.get("LBL_BULLISH_CROSS", new Object[0]));
        runtimeDescriptor.declareSignal((Object)Vpci$Signals.BEARISH_CROSS, this.get("LBL_BEARISH_CROSS", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculate(int n2, DataContext dataContext) {
        int n3;
        Object object = this.getSettings().getInput("input");
        int n4 = this.getSettings().getInteger("period");
        int n5 = this.getSettings().getInteger("period2");
        if (n2 < n5 + (n3 = this.getSettings().getInteger("signalPeriod").intValue())) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        try {
            Double d2 = dataSeries.vwma(n2, n5, object);
            Double d3 = dataSeries.sma(n2, n5, object);
            if (null == d2 || null == d3) {
                return;
            }
            double d4 = d2 - d3;
            Double d5 = dataSeries.vwma(n2, n4, object);
            Double d6 = dataSeries.sma(n2, n4, object);
            if (null == d5 || null == d6) {
                return;
            }
            double d7 = d5 / d6;
            Double d8 = dataSeries.sma(n2, n4, (Object)Enums.BarInput.VOLUME);
            Double d9 = dataSeries.sma(n2, n5, (Object)Enums.BarInput.VOLUME);
            double d10 = d8 / d9;
            double d11 = d4 * d7 * d10;
            Double d12 = dataSeries.sma(n2, n3, (Object)Vpci$Values.VPCI);
            dataSeries.setDouble(n2, (Object)Vpci$Values.VPCI, Double.valueOf(d11));
            dataSeries.setDouble(n2, (Object)Vpci$Values.SIGNAL, d12);
            this.a(n2, dataContext);
            this.b(n2, dataContext);
        }
        finally {
            dataSeries.setComplete(n2);
        }
    }

    private void a(int n2, DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.getDouble(n2, (Object)Vpci$Values.SIGNAL);
        Instrument instrument = dataContext.getInstrument();
        if (null == d2) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d2.doubleValue());
        if (this.crossedAbove(dataSeries, n2, (Object)Vpci$Values.VPCI, (Object)Vpci$Values.SIGNAL) && !dataSeries.getBoolean(n2, (Object)Vpci$Signals.BULLISH_CROSS, false)) {
            dataSeries.setBoolean(n2, (Object)Vpci$Signals.BULLISH_CROSS, Boolean.valueOf(true));
            MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo));
            }
            dataContext.signal(n2, (Object)Vpci$Signals.BULLISH_CROSS, this.get("LBL_BULLISH_CROSS", new Object[0]), (Object)Float.valueOf(instrument.round(dataSeries.getClose(n2))));
        }
    }

    private void b(int n2, DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.getDouble(n2, (Object)Vpci$Values.SIGNAL);
        Instrument instrument = dataContext.getInstrument();
        if (null == d2) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d2.doubleValue());
        if (this.crossedBelow(dataSeries, n2, (Object)Vpci$Values.VPCI, (Object)Vpci$Values.SIGNAL) && !dataSeries.getBoolean(n2, (Object)Vpci$Signals.BEARISH_CROSS, false)) {
            dataSeries.setBoolean(n2, (Object)Vpci$Signals.BEARISH_CROSS, Boolean.valueOf(true));
            MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo));
            }
            dataContext.signal(n2, (Object)Vpci$Signals.BEARISH_CROSS, this.get("LBL_BEARISH_CROSS", new Object[0]), (Object)Float.valueOf(instrument.round(dataSeries.getClose(n2))));
        }
    }
}

