/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.volume;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.volume.VolumeAccOscillator$Values;

@StudyHeader(namespace="com.motivewave", id="ID_VACOSC", rb="com.motivewave.platform.study.nls.strings2", label="LBL_VACOSC", name="NAME_VOLUME_ACCUMULATION_OSCILLATOR", desc="DESC_VACOSC", menu="MENU_MARC_CHAIKIN", helpLink="http://www.motivewave.com/studies/volume_accumulation_oscillator.htm", requiresVolume=true, signals=false, overlay=false, studyOverlay=true)
public class VolumeAccOscillator
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_VACOSC", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("INDICATOR", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -999.0, 999.0, 1.0, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup2 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "line", "topFill", "bottomFill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VolumeAccOscillator$Values.VACOSC, this.get("LBL_VACOSC", new Object[0]), new String[]{"input"}));
        runtimeDescriptor.declarePath((Object)VolumeAccOscillator$Values.VACOSC, "line");
        runtimeDescriptor.declareIndicator((Object)VolumeAccOscillator$Values.VACOSC, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{VolumeAccOscillator$Values.VACOSC});
        this.setMinBars(20);
    }

    protected void calculate(int n2, DataContext dataContext) {
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        double d3 = dataSeries.getHigh(n2);
        double d4 = dataSeries.getLow(n2);
        double d5 = dataSeries.getVolume(n2);
        double d6 = d5 * (d2 - (d3 + d4) / 2.0);
        dataSeries.setDouble(n2, (Object)VolumeAccOscillator$Values.VACOSC, Double.valueOf(d6));
        dataSeries.setComplete(n2);
    }
}

