/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.volume;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.PathInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.volume.Volume$Values;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="VOLUME", rb="com.motivewave.platform.study.nls.strings", name="TITLE_VOLUME", menu="MENU_VOLUME", desc="DESC_VOLUME", overlay=false, requiresVolume=true, requiresBarUpdates=true)
public class Volume
extends Study {
    static final String a = "volumeInd";
    static final String b = "vmaInd";
    private int a;
    private Enums.MAMethod a;
    private PathInfo a;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_VOLUME", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor("bar", this.get("LBL_VOLUME_BARS", new Object[0]), defaults.getBarColor(), 1.0f, null, true, false, true);
        pathDescriptor.setShowAsBars(true);
        pathDescriptor.setSupportsShowAsBars(true);
        pathDescriptor.setSupportsDisable(false);
        pathDescriptor.setColorPolicies(new Enums.ColorPolicy[]{Enums.ColorPolicy.PRICE_BAR, Enums.ColorPolicy.SOLID, Enums.ColorPolicy.HIGHER_LOWER, Enums.ColorPolicy.GRADIENT});
        pathDescriptor.setColorPolicy(Enums.ColorPolicy.PRICE_BAR);
        settingGroup.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor(a, this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingGroup = settingTab.addGroup(this.get("LBL_MOVING_AVERAGE", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 20, 1, 9999, 1)});
        PathDescriptor pathDescriptor2 = new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), Util.awtColor((int)225, (int)102, (int)0), 1.0f, null, false, false, true);
        pathDescriptor2.setShadeType(Enums.ShadeType.BELOW);
        settingGroup.addRow(new SettingDescriptor[]{pathDescriptor2});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor(b, this.get("LBL_INDICATOR", new Object[0]), null, null, false, false, true)});
        settingsDescriptor.addQuickSettings(new String[]{"bar", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 20, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Volume$Values.VOLUME, this.get("LBL_VOLUME", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Volume$Values.VMA, this.get("LBL_VMA", new Object[0]), new String[]{"method", "period"}));
        runtimeDescriptor.declarePath((Object)Volume$Values.VOLUME, "bar");
        runtimeDescriptor.declarePath((Object)Volume$Values.VMA, "line");
        runtimeDescriptor.setFixedBottomValue(Integer.valueOf(0));
        runtimeDescriptor.setBottomInsetPixels(0);
        runtimeDescriptor.setRangeKeys(new Object[]{Volume$Values.VOLUME, Volume$Values.VMA});
        runtimeDescriptor.setMinTopValue(Integer.valueOf(10));
        runtimeDescriptor.declareIndicator((Object)Volume$Values.VOLUME, a);
        runtimeDescriptor.declareIndicator((Object)Volume$Values.VMA, b);
        runtimeDescriptor.setMinTick(Double.valueOf(1.0));
        runtimeDescriptor.setTopInsetPixels(5);
        runtimeDescriptor.setBottomInsetPixels(0);
    }

    public void onSettingsUpdated(DataContext dataContext) {
        this.a = this.getSettings().getPath("line");
        this.a = this.getSettings().getInteger("period", 20);
        this.a = this.getSettings().getMAMethod("method", Enums.MAMethod.SMA);
    }

    protected void calculate(int n2, DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        float f2 = dataSeries.getVolumeAsFloat(n2);
        dataSeries.setFloat(n2, (Object)Volume$Values.VOLUME, Float.valueOf(f2));
        if (this.a != null && this.a.isEnabled() && n2 >= this.a) {
            dataSeries.setDouble(n2, (Object)Volume$Values.VMA, dataSeries.ma(this.a, n2, this.a, (Object)Volume$Values.VOLUME));
        }
        dataSeries.setComplete(n2);
    }
}

