/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.volume;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.volume.TFSVolumeOscillator$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="ID_TFSVO", rb="com.motivewave.platform.study.nls.strings2", name="NAME_TFS_VOLUME_OSCILLATOR", label="LBL_TFSVO", desc="DESC_TFSVO", helpLink="http://www.motivewave.com/studies/tfs_volume_oscillator.htm", signals=false, overlay=false, requiresVolume=true, studyOverlay=true)
public class TFSVolumeOscillator
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUT", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 7, 1, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("LBL_UP_COLOR", new Object[0]), defaults.getGreen())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("LBL_DOWN_COLOR", new Object[0]), defaults.getRed())});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -9999.1, 9999.1, 0.1, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 7, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"upColor", "downColor"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TFSVolumeOscillator$Values.TFSVO, this.get("LBL_TFSVO", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.declareBars((Object)TFSVolumeOscillator$Values.TFSVO);
        runtimeDescriptor.declareIndicator((Object)TFSVolumeOscillator$Values.TFSVO, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{TFSVolumeOscillator$Values.TFSVO});
    }

    public void onLoad(Defaults defaults) {
        this.setMinBars(this.getSettings().getInteger("period"));
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i2 = n2 - n3 + 1; i2 <= n2; ++i2) {
            d2 = dataSeries.getDouble(i2, (Object)Enums.BarInput.CLOSE, 0.0);
            d3 = dataSeries.getDouble(i2, (Object)Enums.BarInput.OPEN, 0.0);
            d4 = (double)dataSeries.getVolume(i2) / 1000000.0;
            if (d2 < d3) {
                d5 -= d4;
            }
            if (!(d2 > d3)) continue;
            d5 += d4;
        }
        double d6 = d5 / (double)n3;
        dataSeries.setDouble(n2, (Object)TFSVolumeOscillator$Values.TFSVO, Double.valueOf(d6));
        GuideInfo guideInfo = this.getSettings().getGuide("middleGuide");
        double d7 = guideInfo.getValue();
        Color color = this.getSettings().getColor("upColor");
        Color color2 = this.getSettings().getColor("downColor");
        if (d6 > d7) {
            dataSeries.setBarColor(n2, (Object)TFSVolumeOscillator$Values.TFSVO, color);
        } else {
            dataSeries.setBarColor(n2, (Object)TFSVolumeOscillator$Values.TFSVO, color2);
        }
        dataSeries.setComplete(n2);
    }
}

