/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.volume;

import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.ColorInfo;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.PathInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.X11Colors;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.EnabledDependency;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDependency;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.volume.RelativeVolume$Values;

@StudyHeader(namespace="com.motivewave", id="RELATIVE_VOLUME", rb="com.motivewave.platform.study.nls.strings", name="TITLE_RELATIVE_VOLUME", menu="MENU_VOLUME", desc="DESC_RELATIVE_VOLUME", overlay=false, requiresVolume=true, requiresBarUpdates=true)
public class RelativeVolume
extends Study {
    static final String a = "relVolInd";
    static final String b = "cumPath";
    static final String c = "cumVolInd";
    static final String d = "highBarColor";
    static final String e = "LOW_BAR_COLOR";
    static final String f = "highThreshold";
    static final String g = "lowThreshold";
    static final String h = "guide100";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_RELATIVE_VOLUME", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 10, 1, 9999, 1)});
        PathDescriptor pathDescriptor = new PathDescriptor("bar", this.get("LBL_BARS", new Object[0]), defaults.getBarColor(), 1.0f, null, true, false, true);
        pathDescriptor.setShowAsBars(true);
        pathDescriptor.setSupportsShowAsBars(true);
        pathDescriptor.setSupportsDisable(false);
        pathDescriptor.setColorPolicies(new Enums.ColorPolicy[]{Enums.ColorPolicy.PRICE_BAR, Enums.ColorPolicy.SOLID, Enums.ColorPolicy.HIGHER_LOWER, Enums.ColorPolicy.GRADIENT});
        pathDescriptor.setColorPolicy(Enums.ColorPolicy.SOLID);
        settingGroup.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor(a, this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingGroup.addRow(new SettingDescriptor[]{new ColorDescriptor(d, this.get("LBL_HIGH_BAR_COLOR", new Object[0]), Util.awtColor((int)192, (int)192, (int)192), true, true)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(f, this.get("LBL_HIGH_THRESHOLD", new Object[0]), 150, 1, 99999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new ColorDescriptor(e, this.get("LBL_LOW_BAR_COLOR", new Object[0]), Util.awtColor((int)75, (int)75, (int)75), true, true)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(g, this.get("LBL_LOW_THRESHOLD", new Object[0]), 50, 1, 99999, 1)});
        settingGroup = settingTab.addGroup(this.get("LBL_CUM_RELATIVE_VOLUME", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("LBL_PERIOD", new Object[0]), 10, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor(b, this.get("LBL_CUM_VOL_PATH", new Object[0]), defaults.getBlueLine(), 1.0f, null, true, false, true)});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor(c, this.get("LBL_INDICATOR", new Object[0]), defaults.getBlue(), X11Colors.WHITE, false, true, true)});
        settingsDescriptor.addDependency((InputDependency)new EnabledDependency(e, new String[]{g}));
        settingsDescriptor.addDependency((InputDependency)new EnabledDependency(d, new String[]{f}));
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 10, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"bar", d, f, e, g});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("LBL_PERIOD", new Object[0]), 10, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{b});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RelativeVolume$Values.REL_VOL, this.get("LBL_REL_VOLUME", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RelativeVolume$Values.CUM_VOL_PER, this.get("LBL_CUM_REL_VOLUME", new Object[0]), new String[]{"period2"}));
        runtimeDescriptor.declarePath((Object)RelativeVolume$Values.REL_VOL, "bar");
        runtimeDescriptor.declarePath((Object)RelativeVolume$Values.CUM_VOL_PER, b);
        runtimeDescriptor.setFixedBottomValue(Integer.valueOf(0));
        runtimeDescriptor.setBottomInsetPixels(0);
        runtimeDescriptor.setRangeKeys(new Object[]{RelativeVolume$Values.REL_VOL, RelativeVolume$Values.CUM_VOL_PER});
        runtimeDescriptor.setMinTopValue(Integer.valueOf(150));
        runtimeDescriptor.declareIndicator((Object)RelativeVolume$Values.REL_VOL, a);
        runtimeDescriptor.declareIndicator((Object)RelativeVolume$Values.CUM_VOL_PER, c);
        runtimeDescriptor.setMinTick(Double.valueOf(0.1));
        runtimeDescriptor.setTopInsetPixels(5);
        runtimeDescriptor.setBottomInsetPixels(0);
        runtimeDescriptor.addHorizontalLine(new LineInfo(100.0, null, 1.0f, new float[]{3.0f, 3.0f}));
    }

    public Long getMinStartTime(DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        BarSize barSize = dataSeries.getBarSize();
        if (!barSize.isFixedSize() || !barSize.isIntraday()) {
            return super.getMinStartTime(dataContext);
        }
        Instrument instrument = dataSeries.getInstrument();
        long l2 = instrument.getStartOfDay(dataContext.getCurrentTime(), dataContext.isRTH());
        int n2 = Math.max(this.getSettings().getInteger("period", 10), this.getSettings().getInteger("period2", 10));
        for (int i2 = 0; i2 <= n2; ++i2) {
            l2 = Util.getStartOfPrevDay((long)l2, (Instrument)instrument, (boolean)dataContext.isRTH());
        }
        return l2;
    }

    protected void calculateValues(DataContext dataContext) {
        int n2;
        DataSeries dataSeries = dataContext.getDataSeries();
        int n3 = 0;
        for (n3 = 0; n3 < dataSeries.size() && dataSeries.isComplete(n3); ++n3) {
        }
        Instrument instrument = dataSeries.getInstrument();
        PathInfo pathInfo = this.getSettings().getPath(b);
        if (pathInfo != null && pathInfo.isEnabled()) {
            for (n2 = n3; n2 < dataSeries.size(); ++n2) {
                long l2;
                long l3 = instrument.getStartOfDay(dataSeries.getStartTime(n2), dataContext.isRTH());
                if (l3 != (l2 = instrument.getStartOfDay(dataSeries.getStartTime(n2 - 1), dataContext.isRTH()))) {
                    dataSeries.setFloat(n2, (Object)RelativeVolume$Values.CUM_VOL, Float.valueOf(dataSeries.getVolumeAsFloat(n2)));
                    continue;
                }
                dataSeries.setFloat(n2, (Object)RelativeVolume$Values.CUM_VOL, Float.valueOf(dataSeries.getFloat(n2 - 1, (Object)RelativeVolume$Values.CUM_VOL, 0.0f) + dataSeries.getVolumeAsFloat(n2)));
            }
        }
        for (n2 = n3; n2 < dataSeries.size(); ++n2) {
            this.calculate(n2, dataContext);
            dataSeries.setComplete(n2);
        }
    }

    protected void calculate(int n2, DataContext dataContext) {
        long l2;
        DataSeries dataSeries = dataContext.getDataSeries();
        ColorInfo colorInfo = this.getSettings().getColorInfo(d);
        int n3 = this.getSettings().getInteger(f, 150);
        ColorInfo colorInfo2 = this.getSettings().getColorInfo(e);
        int n4 = this.getSettings().getInteger(g, 50);
        int n5 = this.getSettings().getInteger("period", 10);
        int n6 = this.getSettings().getInteger("period2", 10);
        Instrument instrument = dataSeries.getInstrument();
        PathInfo pathInfo = this.getSettings().getPath(b);
        long l3 = dataSeries.getStartTime(n2);
        long l4 = instrument.getStartOfDay(l3, dataContext.isRTH());
        long l5 = l3 - l4;
        float f2 = dataSeries.getVolumeAsFloat(n2);
        Float f3 = dataSeries.getFloat(n2, (Object)RelativeVolume$Values.AVG_REL_VOL);
        if (f3 == null) {
            int n7;
            float f4 = 0.0f;
            int n8 = 0;
            long l6 = l4;
            for (int i2 = 0; i2 < n5 && (n7 = dataSeries.findIndex((l6 = Util.getStartOfPrevDay((long)l6, (Instrument)instrument, (boolean)dataContext.isRTH())) + l5)) >= 0; ++i2) {
                f4 += dataSeries.getVolumeAsFloat(n7);
                ++n8;
            }
            f3 = Float.valueOf(n8 == 0 ? 0.0f : f4 / (float)n8);
            dataSeries.setFloat(n2, (Object)RelativeVolume$Values.AVG_REL_VOL, f3);
        }
        double d2 = f3.floatValue() == 0.0f ? 0.0 : Util.roundDouble((double)(f2 / f3.floatValue() * 100.0f), (int)2);
        dataSeries.setDouble(n2, (Object)RelativeVolume$Values.REL_VOL, Double.valueOf(d2));
        if (colorInfo.isEnabled() && d2 >= (double)n3) {
            dataSeries.setBarColor(n2, (Object)RelativeVolume$Values.REL_VOL, colorInfo.getColor());
        } else if (colorInfo2.isEnabled() && d2 <= (double)n4) {
            dataSeries.setBarColor(n2, (Object)RelativeVolume$Values.REL_VOL, colorInfo2.getColor());
        } else {
            dataSeries.setBarColor(n2, (Object)RelativeVolume$Values.REL_VOL, null);
        }
        if (pathInfo == null || !pathInfo.isEnabled()) {
            return;
        }
        f3 = dataSeries.getFloat(n2, (Object)RelativeVolume$Values.AVG_CUM_VOL);
        if (f3 == null) {
            int n9;
            float f5 = 0.0f;
            int n10 = 0;
            long l7 = l4;
            for (int i3 = 0; i3 < n6 && (n9 = dataSeries.findIndex((l7 = Util.getStartOfPrevDay((long)l7, (Instrument)instrument, (boolean)dataContext.isRTH())) + l5)) >= 0; ++i3) {
                f5 += dataSeries.getFloat(n9, (Object)RelativeVolume$Values.CUM_VOL, 0.0f);
                ++n10;
            }
            f3 = Float.valueOf(f5 / (float)n10);
            dataSeries.setFloat(n2, (Object)RelativeVolume$Values.AVG_CUM_VOL, f3);
        }
        float f6 = (l2 = dataSeries.getStartTime(n2 - 1)) < l4 ? f2 : dataSeries.getFloat(n2 - 1, (Object)RelativeVolume$Values.CUM_VOL, 0.0f) + f2;
        double d3 = f3.floatValue() == 0.0f ? 0.0 : Util.roundDouble((double)(f6 / f3.floatValue() * 100.0f), (int)2);
        dataSeries.setFloat(n2, (Object)RelativeVolume$Values.CUM_VOL, Float.valueOf(f6));
        dataSeries.setDouble(n2, (Object)RelativeVolume$Values.CUM_VOL_PER, Double.valueOf(d3));
    }
}

