/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.volume;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.volume.PositiveVolumeIndex$Values;

@StudyHeader(namespace="com.motivewave", id="POS_VOL", rb="com.motivewave.platform.study.nls.strings", name="TITLE_POS_VOL", tabName="TAB_POS_VOL", desc="DESC_POS_VOL", menu="MENU_VOLUME", overlay=false, requiresVolume=true)
public class PositiveVolumeIndex
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_COLORS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, false)});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"line", "ind"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)PositiveVolumeIndex$Values.VAL, this.get("VAL_POS_VOL", new Object[0]), new String[0]));
        runtimeDescriptor.declarePath((Object)PositiveVolumeIndex$Values.VAL, "line");
        runtimeDescriptor.declareIndicator((Object)PositiveVolumeIndex$Values.VAL, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{PositiveVolumeIndex$Values.VAL});
    }

    protected void calculate(int n2, DataContext dataContext) {
        if (n2 < 1) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.getDouble(n2 - 1, (Object)PositiveVolumeIndex$Values.VAL);
        if (d2 == null) {
            d2 = 1.0;
        }
        double d3 = d2;
        if (dataSeries.getVolume(n2) > dataSeries.getVolume(n2 - 1)) {
            d3 = d2 + (double)((dataSeries.getClose(n2) - dataSeries.getClose(n2 - 1)) / dataSeries.getClose(n2 - 1)) * d2;
        }
        dataSeries.setDouble(n2, (Object)PositiveVolumeIndex$Values.VAL, Double.valueOf(d3));
        dataSeries.setComplete(n2);
    }
}

