/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.volume;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.volume.OpenInterest$Values;

@StudyHeader(namespace="com.motivewave", id="OPEN_INTEREST", rb="com.motivewave.platform.study.nls.strings", name="TITLE_OPEN_INTEREST", menu="MENU_VOLUME", desc="DESC_OPEN_INTEREST", overlay=false, requiresVolume=true)
public class OpenInterest
extends Study {
    static final String a = "openInterestInd";
    static final String b = "omaInd";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_OPEN_INTEREST", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor("bar", this.get("LBL_OPEN_INTEREST_BARS", new Object[0]), defaults.getBarColor(), 1.0f, null, true, false, true);
        pathDescriptor.setShowAsBars(true);
        pathDescriptor.setSupportsShowAsBars(true);
        pathDescriptor.setSupportsDisable(false);
        pathDescriptor.setColorPolicies(new Enums.ColorPolicy[]{Enums.ColorPolicy.PRICE_BAR, Enums.ColorPolicy.SOLID, Enums.ColorPolicy.HIGHER_LOWER, Enums.ColorPolicy.GRADIENT});
        pathDescriptor.setColorPolicy(Enums.ColorPolicy.PRICE_BAR);
        settingGroup.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor(a, this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingGroup = settingTab.addGroup(this.get("LBL_MOVING_AVERAGE", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 20, 1, 9999, 1)});
        PathDescriptor pathDescriptor2 = new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), Util.awtColor((int)225, (int)102, (int)0), 1.0f, null, true, false, true);
        pathDescriptor2.setShadeType(Enums.ShadeType.BELOW);
        settingGroup.addRow(new SettingDescriptor[]{pathDescriptor2});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor(b, this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"bar", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 20, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)OpenInterest$Values.OPEN_INTEREST, this.get("LBL_OPEN_INTEREST", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)OpenInterest$Values.OMA, this.get("LBL_OMA", new Object[0]), new String[]{"method", "period"}));
        runtimeDescriptor.declarePath((Object)OpenInterest$Values.OPEN_INTEREST, "bar");
        runtimeDescriptor.declarePath((Object)OpenInterest$Values.OMA, "line");
        runtimeDescriptor.setFixedBottomValue(Integer.valueOf(0));
        runtimeDescriptor.setBottomInsetPixels(0);
        runtimeDescriptor.setRangeKeys(new Object[]{OpenInterest$Values.OPEN_INTEREST});
        runtimeDescriptor.setMinTopValue(Integer.valueOf(10));
        runtimeDescriptor.declareIndicator((Object)OpenInterest$Values.OPEN_INTEREST, a);
        runtimeDescriptor.declareIndicator((Object)OpenInterest$Values.OMA, b);
        runtimeDescriptor.setMinTick(Double.valueOf(1.0));
        runtimeDescriptor.setTopInsetPixels(5);
        runtimeDescriptor.setBottomInsetPixels(0);
    }

    protected void calculate(int n2, DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getOpenInterest(n2);
        d2 = Math.floor(d2);
        dataSeries.setDouble(n2, (Object)OpenInterest$Values.OPEN_INTEREST, Double.valueOf(d2));
        int n3 = this.getSettings().getInteger("period", 20);
        if (n2 < n3) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.SMA);
        dataSeries.setDouble(n2, (Object)OpenInterest$Values.OMA, dataSeries.ma(mAMethod, n2, n3, (Object)OpenInterest$Values.OPEN_INTEREST));
        dataSeries.setComplete(n2);
    }
}

