/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.volume;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.volume.NegativeVolumeIndex$Values;

@StudyHeader(namespace="com.motivewave", id="ID_NEG_VOL", rb="com.motivewave.platform.study.nls.strings2", label="LBL_NVI", name="NAME_NEGATIVE_VOLUME_INDEX", desc="DESC_NEG_VOL", menu="MENU_VOLUME_BASED", helpLink="http://www.motivewave.com/studies/negative_volume_index.htm", overlay=false, requiresVolume=true, studyOverlay=true)
public class NegativeVolumeIndex
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PATH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, false)});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -999.001, 999.001, 0.001, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup2.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"line", "topFill", "bottomFill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)NegativeVolumeIndex$Values.VAL, this.get("LBL_NVI", new Object[0]), new String[0]));
        runtimeDescriptor.declarePath((Object)NegativeVolumeIndex$Values.VAL, "line");
        runtimeDescriptor.declareIndicator((Object)NegativeVolumeIndex$Values.VAL, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{NegativeVolumeIndex$Values.VAL});
    }

    public void onLoad(Defaults defaults) {
        this.setMinBars(20);
    }

    protected void calculate(int n2, DataContext dataContext) {
        if (n2 < 1) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getClose(n2);
        double d3 = dataSeries.getClose(n2 - 1);
        double d4 = dataSeries.getVolume(n2);
        double d5 = dataSeries.getVolume(n2 - 1);
        double d6 = dataSeries.getDouble(n2 - 1, (Object)NegativeVolumeIndex$Values.VAL, 1.0);
        double d7 = (d2 - d3) / d3;
        if (d5 < d4) {
            d7 = 0.0;
        }
        double d8 = d6 + d7;
        dataSeries.setDouble(n2, (Object)NegativeVolumeIndex$Values.VAL, Double.valueOf(d8));
        dataSeries.setComplete(n2);
    }
}

