/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.volume;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.volume.HerrickPayoffIndex$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="ID_HPI", rb="com.motivewave.platform.study.nls.strings2", label="LBL_HPI", name="NAME_HERRICK_PAYOFF_INDEX", desc="DESC_HPI", menu="MENU_VOLUME_BASED", helpLink="http://www.motivewave.com/studies/herrick_payoff_index.htm", requiresVolume=true, signals=false, overlay=false, studyOverlay=true)
public class HerrickPayoffIndex
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("POINT_VALUE", new Object[0]), 100, 1, 9999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("LBL_UP_COLOR", new Object[0]), defaults.getGreen())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("LBL_DOWN_COLOR", new Object[0]), defaults.getRed())});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -999.1, 999.1, 0.1, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("POINT_VALUE", new Object[0]), 100, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"upColor", "downColor"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)HerrickPayoffIndex$Values.HPIC, this.get("HPIC", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.declareBars((Object)HerrickPayoffIndex$Values.HPIC);
        runtimeDescriptor.declareIndicator((Object)HerrickPayoffIndex$Values.HPIC, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{HerrickPayoffIndex$Values.HPIC});
        this.setMinBars(20);
    }

    protected void calculate(int n2, DataContext dataContext) {
        if (n2 < 1) {
            return;
        }
        int n3 = this.getSettings().getInteger("period");
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getOpen(n2);
        double d3 = dataSeries.getOpen(n2 - 1);
        double d4 = dataSeries.getHigh(n2);
        double d5 = dataSeries.getLow(n2);
        double d6 = dataSeries.getClose(n2);
        long l2 = dataSeries.getVolume(n2);
        double d7 = dataSeries.getHigh(n2 - 1);
        double d8 = dataSeries.getLow(n2 - 1);
        double d9 = dataSeries.getClose(n2 - 1);
        double d10 = (d4 + d5) / 2.0;
        double d11 = (d7 + d8) / 2.0;
        double d12 = Math.abs(d6 - d9);
        double d13 = Math.min(d2, d3);
        double d14 = (d10 - d11) * (double)n3 * (double)l2;
        double d15 = 1.0 + d12 / 2.0 / d13;
        if (d10 < d11) {
            d15 = 1.0 - d12 / 2.0 / d13;
        }
        dataSeries.setDouble(n2, (Object)HerrickPayoffIndex$Values.K, Double.valueOf(d14 *= d15));
        if (n2 < 2) {
            return;
        }
        double d16 = dataSeries.getDouble(n2 - 1, (Object)HerrickPayoffIndex$Values.K, 0.0);
        double d17 = d16 + (d14 - d16);
        dataSeries.setDouble(n2, (Object)HerrickPayoffIndex$Values.HPIC, Double.valueOf(d17));
        GuideInfo guideInfo = this.getSettings().getGuide("middleGuide");
        double d18 = guideInfo.getValue();
        Color color = this.getSettings().getColor("upColor");
        Color color2 = this.getSettings().getColor("downColor");
        if (d17 > d18) {
            dataSeries.setBarColor(n2, (Object)HerrickPayoffIndex$Values.HPIC, color);
        } else {
            dataSeries.setBarColor(n2, (Object)HerrickPayoffIndex$Values.HPIC, color2);
        }
        dataSeries.setComplete(n2);
    }
}

