/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.volume;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.volume.ElasticVolumeWeightedMovingAverage$Values;

@StudyHeader(namespace="com.motivewave", id="ID_EVWMA", rb="com.motivewave.platform.study.nls.strings2", name="NAME_ELASTIC_VOLUME_WEIGHTED_MA", label="LBL_EVWMA", desc="DESC_EVWMA", menu="MENU_VOLUME_BASED", helpLink="http://www.motivewave.com/studies/elastic_volume_weighted_moving_average.htm", requiresVolume=true, signals=false, overlay=true, studyOverlay=true)
public class ElasticVolumeWeightedMovingAverage
extends Study {
    static final String a = "Mult";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 40, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("MULTIPLER", new Object[0]), 20.0, 1.0, 999.9, 0.1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_EVWMA", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 40, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{a, "line"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ElasticVolumeWeightedMovingAverage$Values.EVWMA, this.get("LBL_EVWMA", new Object[0]), new String[]{"input", "method", "period", a}));
        runtimeDescriptor.declarePath((Object)ElasticVolumeWeightedMovingAverage$Values.EVWMA, "line");
        runtimeDescriptor.declareIndicator((Object)ElasticVolumeWeightedMovingAverage$Values.EVWMA, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{ElasticVolumeWeightedMovingAverage$Values.EVWMA});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        int n3 = this.getSettings().getInteger("period");
        double d2 = dataSeries.getVolume(n2);
        dataSeries.setDouble(n2, (Object)ElasticVolumeWeightedMovingAverage$Values.VOLUME, Double.valueOf(d2));
        if (n2 <= n3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        double d3 = this.getSettings().getDouble(a);
        double d4 = dataSeries.getDouble(n2, object, 0.0);
        Double d5 = dataSeries.ma(mAMethod, n2, n3, (Object)ElasticVolumeWeightedMovingAverage$Values.VOLUME);
        if (d5 == null) {
            return;
        }
        double d6 = d5 * d3;
        if (d6 == 0.0) {
            return;
        }
        double d7 = dataSeries.getDouble(n2 - 1, (Object)ElasticVolumeWeightedMovingAverage$Values.EVWMA, d4);
        double d8 = ((d6 - d2) * d7 + d2 * d4) / d6;
        dataSeries.setDouble(n2, (Object)ElasticVolumeWeightedMovingAverage$Values.EVWMA, Double.valueOf(d8));
        dataSeries.setComplete(n2);
    }
}

