/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.volume;

import com.motivewave.platform.sdk.common.BarInfo;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BarDescriptor;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.volume.BetterVolumeIndicator$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="BETTER_VOLUME", rb="com.motivewave.platform.study.nls.strings", name="TITLE_BETTER_VOLUME", tabName="BV_TAB", menu="MENU_VOLUME", desc="DESC_BETTER_VOLUME", overlay=false, requiresVolume=true, helpLink="http://www.motivewave.com/studies/better_volume.htm")
public class BetterVolumeIndicator
extends Study {
    static final String a = "lookback";
    static final String b = "use2Bars";
    static final String c = "paintBars";
    static final String d = "avgPeriod";
    static final String e = "volumeBars";
    static final String f = "lowVolColor";
    static final String g = "climaxUpColor";
    static final String h = "climaxDownColor";
    static final String i = "churnColor";
    static final String j = "climaxChurnColor";
    static final String k = "volumeInd";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("LBL_LOOKBACK", new Object[0]), 20, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(d, this.get("LBL_AVG_PERIOD", new Object[0]), 100, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(b, this.get("LBL_USE_2_BARS", new Object[0]), Boolean.valueOf(true))});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(c, this.get("LBL_PAINT_BARS", new Object[0]), Boolean.valueOf(true))});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_AVG_LINE", new Object[0]), null, 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new BarDescriptor(e, this.get("LBL_VOLUME_BARS", new Object[0]), defaults.getBlue(), true, false), new ColorDescriptor(f, this.get("LBL_LOW_VOL_COLOR", new Object[0]), defaults.getYellow())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(g, this.get("LBL_CLIMAX_UP_COLOR", new Object[0]), defaults.getRed()), new ColorDescriptor(h, this.get("LBL_CLIMAX_DOWN_COLOR", new Object[0]), defaults.getGrey())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(i, this.get("LBL_CHURN_COLOR", new Object[0]), defaults.getGreen()), new ColorDescriptor(j, this.get("LBL_CLIMAX_CHURN_COLOR", new Object[0]), defaults.getPurple())});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(k, this.get("LBL_VOLUME_IND", new Object[0]), null, null, false, true, true)});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(a, this.get("LBL_LOOKBACK", new Object[0]), 20, 1, 9999, true, () -> Enums.Icon.ARROW_LEFT.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(d, this.get("LBL_AVG_PERIOD", new Object[0]), 100, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{b, c, "line", e, f, g, h, i, j});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{a, d});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)BetterVolumeIndicator$Values.AVG, this.get("LBL_BV_AVG", new Object[0]), new String[]{d}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)BetterVolumeIndicator$Values.VOLUME, this.get("LBL_VOLUME", new Object[0]), new String[0]));
        runtimeDescriptor.declarePath((Object)BetterVolumeIndicator$Values.AVG, "line");
        runtimeDescriptor.declareBars((Object)BetterVolumeIndicator$Values.VOLUME, e);
        runtimeDescriptor.setFixedBottomValue(Integer.valueOf(0));
        runtimeDescriptor.setBottomInsetPixels(0);
        runtimeDescriptor.setRangeKeys(new Object[]{BetterVolumeIndicator$Values.VOLUME});
        runtimeDescriptor.declareIndicator((Object)BetterVolumeIndicator$Values.VOLUME, k);
    }

    public void onBarUpdate(DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        int n2 = dataSeries.size() - 1;
        dataSeries.setDouble(n2, (Object)BetterVolumeIndicator$Values.VOLUME, Double.valueOf(dataSeries.getVolumeAsFloat(n2)));
    }

    protected void calculateValues(DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        int n2 = dataSeries.size() - 1;
        boolean bl2 = this.getSettings().getBoolean(b);
        boolean bl3 = this.getSettings().getBoolean(c);
        int n3 = this.getSettings().getInteger(d);
        int n4 = this.getSettings().getInteger(a);
        Color color = this.getSettings().getColor(f);
        Color color2 = this.getSettings().getColor(g);
        Color color3 = this.getSettings().getColor(h);
        Color color4 = this.getSettings().getColor(i);
        Color color5 = this.getSettings().getColor(j);
        BarInfo barInfo = this.getSettings().getBars(e);
        int n5 = 6;
        for (int i2 = 0; i2 < dataSeries.size(); ++i2) {
            Double d2;
            if (dataSeries.isComplete(i2)) continue;
            long l2 = dataSeries.getVolume(i2);
            if (l2 == 0L) {
                if (i2 != n2) continue;
                dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.AVG, dataSeries.sma(i2, n3, (Object)BetterVolumeIndicator$Values.VAL3));
                if (!bl3) continue;
                dataSeries.setPriceBarColor(i2, barInfo.getColor());
                continue;
            }
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VOLUME, Double.valueOf(dataSeries.getVolumeAsFloat(i2)));
            double d3 = dataSeries.getRange(i2).floatValue();
            double d4 = dataSeries.getOpen(i2);
            double d5 = dataSeries.getClose(i2);
            double d6 = 0.0;
            double d7 = 0.0;
            d6 = d5 > d4 && d3 != 0.0 ? (double)l2 * (d3 / (2.0 * d3 + d4 - d5)) : (d5 < d4 && d3 != 0.0 ? (double)l2 * ((d3 + d5 - d4) / (2.0 * d3 + d5 - d4)) : 0.5 * (double)l2);
            d7 = (double)l2 - d6;
            d6 = Util.round((double)d6, (int)1);
            d7 = Util.round((double)d7, (int)1);
            double d8 = Util.round((double)Math.abs(d6 + d7), (int)n5);
            double d9 = Util.round((double)(d6 * d3), (int)n5);
            double d10 = Util.round((double)((d6 - d7) * d3), (int)n5);
            double d11 = Util.round((double)(d7 * d3), (int)n5);
            double d12 = Util.round((double)((d7 - d6) * d3), (int)n5);
            double d13 = 0.0;
            double d14 = 0.0;
            double d15 = 0.0;
            double d16 = 0.0;
            double d17 = 0.0;
            if (d3 != 0.0) {
                d13 = Util.round((double)(d6 / d3), (int)n5);
                d14 = Util.round((double)((d6 - d7) / d3), (int)n5);
                d15 = Util.round((double)(d7 / d3), (int)n5);
                d16 = Util.round((double)((d7 - d6) / d3), (int)n5);
                d17 = Util.round((double)(d8 / d3), (int)n5);
            }
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VAL1, Double.valueOf(d6));
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VAL2, Double.valueOf(d7));
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VAL3, Double.valueOf(d8));
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VAL4, Double.valueOf(d9));
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VAL5, Double.valueOf(d10));
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VAL6, Double.valueOf(d11));
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VAL7, Double.valueOf(d12));
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VAL8, Double.valueOf(d13));
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VAL9, Double.valueOf(d14));
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VAL10, Double.valueOf(d15));
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VAL11, Double.valueOf(d16));
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VAL12, Double.valueOf(d17));
            if (i2 < 1) continue;
            double d18 = dataSeries.highest(i2, 2, (Object)Enums.BarInput.HIGH);
            double d19 = dataSeries.lowest(i2, 2, Enums.BarInput.LOW);
            double d20 = d18 - d19;
            if (dataSeries.getDouble(i2 - 1, (Object)BetterVolumeIndicator$Values.VAL1) == null) continue;
            double d21 = dataSeries.getDouble(i2 - 1, (Object)BetterVolumeIndicator$Values.VAL1);
            double d22 = dataSeries.getDouble(i2 - 1, (Object)BetterVolumeIndicator$Values.VAL2);
            double d23 = dataSeries.getDouble(i2 - 1, (Object)BetterVolumeIndicator$Values.VAL3);
            double d24 = Util.round((double)(d8 + d23), (int)n5);
            double d25 = Util.round((double)((d6 + d21) * d20), (int)n5);
            double d26 = Util.round((double)((d6 + d21 - d7 - d22) * d20), (int)n5);
            double d27 = Util.round((double)((d7 + d22) * d20), (int)n5);
            double d28 = Util.round((double)((d7 + d22 - d6 - d21) * d20), (int)n5);
            double d29 = 0.0;
            double d30 = 0.0;
            double d31 = 0.0;
            double d32 = 0.0;
            double d33 = 0.0;
            if (d20 != 0.0) {
                d29 = Util.round((double)((d6 + d21) / d20), (int)n5);
                d30 = Util.round((double)((d6 + d21 - d7 - d22) / d20), (int)n5);
                d31 = Util.round((double)((d7 + d22) / d20), (int)n5);
                d32 = Util.round((double)((d7 + d22 - d6 - d21) / d20), (int)n5);
                d33 = Util.round((double)(d24 / d20), (int)n5);
            }
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VAL13, Double.valueOf(d24));
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VAL14, Double.valueOf(d25));
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VAL15, Double.valueOf(d26));
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VAL16, Double.valueOf(d27));
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VAL17, Double.valueOf(d28));
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VAL18, Double.valueOf(d29));
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VAL19, Double.valueOf(d30));
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VAL20, Double.valueOf(d31));
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VAL21, Double.valueOf(d32));
            dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.VAL22, Double.valueOf(d33));
            if (i2 < n4) continue;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            boolean bl10 = false;
            boolean bl11 = false;
            boolean bl12 = false;
            boolean bl13 = false;
            boolean bl14 = false;
            boolean bl15 = false;
            boolean bl16 = false;
            boolean bl17 = false;
            boolean bl18 = false;
            boolean bl19 = false;
            boolean bl20 = false;
            boolean bl21 = false;
            boolean bl22 = false;
            boolean bl23 = false;
            double d34 = dataSeries.getClose(i2 - 1);
            double d35 = dataSeries.getOpen(i2 - 1);
            if (!bl2) {
                bl23 = d8 == dataSeries.lowest(i2, n4, (Object)BetterVolumeIndicator$Values.VAL3);
                bl22 = d9 == dataSeries.highest(i2, n4, (Object)BetterVolumeIndicator$Values.VAL4) && d5 > d4;
                bl21 = d10 == dataSeries.highest(i2, n4, (Object)BetterVolumeIndicator$Values.VAL5) && d5 > d4;
                bl20 = d11 == dataSeries.highest(i2, n4, (Object)BetterVolumeIndicator$Values.VAL6) && d5 < d4;
                bl19 = d12 == dataSeries.highest(i2, n4, (Object)BetterVolumeIndicator$Values.VAL7) && d5 < d4;
                bl18 = d13 == dataSeries.lowest(i2, n4, (Object)BetterVolumeIndicator$Values.VAL8) && d5 < d4;
                bl17 = d14 == dataSeries.lowest(i2, n4, (Object)BetterVolumeIndicator$Values.VAL9) && d5 < d4;
                bl16 = d15 == dataSeries.lowest(i2, n4, (Object)BetterVolumeIndicator$Values.VAL10) && d5 > d4;
                bl15 = d16 == dataSeries.lowest(i2, n4, (Object)BetterVolumeIndicator$Values.VAL11) && d5 > d4;
                bl14 = d17 == dataSeries.highest(i2, n4, (Object)BetterVolumeIndicator$Values.VAL12);
            } else {
                bl13 = d24 == dataSeries.lowest(i2, n4, (Object)BetterVolumeIndicator$Values.VAL13);
                bl12 = d25 == dataSeries.highest(i2, n4, (Object)BetterVolumeIndicator$Values.VAL14) && d5 > d4 && d34 > d35;
                bl11 = d26 == dataSeries.highest(i2, n4, (Object)BetterVolumeIndicator$Values.VAL15) && d5 > d4 && d34 > d35;
                bl10 = d27 == dataSeries.highest(i2, n4, (Object)BetterVolumeIndicator$Values.VAL16) && d5 < d4 && d34 < d35;
                bl9 = d28 == dataSeries.highest(i2, n4, (Object)BetterVolumeIndicator$Values.VAL17) && d5 < d4 && d34 < d35;
                bl8 = d29 == dataSeries.lowest(i2, n4, (Object)BetterVolumeIndicator$Values.VAL18) && d5 < d4 && d34 < d35;
                bl7 = d30 == dataSeries.lowest(i2, n4, (Object)BetterVolumeIndicator$Values.VAL19) && d5 < d4 && d34 < d35;
                bl6 = d31 == dataSeries.lowest(i2, n4, (Object)BetterVolumeIndicator$Values.VAL20) && d5 > d4 && d34 > d35;
                bl5 = d32 == dataSeries.lowest(i2, n4, (Object)BetterVolumeIndicator$Values.VAL21) && d5 > d4 && d34 > d35;
                bl4 = d33 == dataSeries.highest(i2, n4, (Object)BetterVolumeIndicator$Values.VAL22);
            }
            Color color6 = barInfo.getColor();
            if (bl23 || bl13) {
                color6 = color;
            }
            if (bl22 || bl21 || bl16 || bl15 || bl12 || bl11 || bl6 || bl5) {
                color6 = color2;
            }
            if (bl20 || bl19 || bl18 || bl17 || bl10 || bl9 || bl8 || bl7) {
                color6 = color3;
            }
            if (bl14 || bl4) {
                color6 = color4;
            }
            if ((bl14 || bl4) && (bl22 || bl21 || bl20 || bl19 || bl18 || bl17 || bl16 || bl15 || bl12 || bl11 || bl10 || bl9 || bl8 || bl7 || bl6 || bl5)) {
                color6 = color5;
            }
            if ((d2 = dataSeries.sma(i2, n3, (Object)BetterVolumeIndicator$Values.VAL3)) != null) {
                dataSeries.setDouble(i2, (Object)BetterVolumeIndicator$Values.AVG, d2);
            }
            dataSeries.setBarColor(i2, (Object)BetterVolumeIndicator$Values.VOLUME, color6);
            if (bl3) {
                dataSeries.setPriceBarColor(i2, color6);
            }
            dataSeries.setComplete(i2);
        }
    }
}

