/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.strategies;

import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.order_mgmt.OrderContext;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.BuffAverage;
import com.motivewave.platform.study.overlay.BuffAverage$Signals;

@StudyHeader(namespace="com.motivewave", id="ID_BUFFST", rb="com.motivewave.platform.study.nls.strings2", name="NAME_BUFF_AVERAGE_STRATEGY", label="LBL_BUFFST", desc="DESC_BUFF", menu="MENU_GENERAL", helpLink="http://www.motivewave.com/strategies/buff_average_strategy.htm", overlay=true, signals=true, strategy=true, autoEntry=true, manualEntry=false, supportsUnrealizedPL=true, supportsRealizedPL=true, supportsTotalPL=true, supportsPositionType=true)
public class c
extends BuffAverage {
    public void onActivate(OrderContext orderContext) {
        if (this.getSettings().isEnterOnActivate()) {
            DataSeries dataSeries = orderContext.getDataContext().getDataSeries();
            int n2 = dataSeries.isLastBarComplete() ? dataSeries.size() - 1 : dataSeries.size() - 2;
            Boolean bl2 = dataSeries.getBoolean(n2, (Object)BuffAverage$Signals.BUY);
            Boolean bl3 = dataSeries.getBoolean(n2, (Object)BuffAverage$Signals.SELL);
            if (bl2 == null || bl3 == null) {
                return;
            }
            int n3 = this.getSettings().getTradeLots();
            n3 = (int)((float)n3 * orderContext.getInstrument().getDefaultQuantityAsFloat());
            float f2 = n3;
            switch (this.getSettings().getPositionType()) {
                case LONG: {
                    if (!bl2.booleanValue()) break;
                    orderContext.buy(f2);
                    break;
                }
                case SHORT: {
                    if (!bl3.booleanValue()) break;
                    orderContext.sell(f2);
                    break;
                }
                default: {
                    if (bl2.booleanValue()) {
                        orderContext.buy(f2);
                        break;
                    }
                    orderContext.sell(f2);
                }
            }
        }
    }

    public void onSignal(OrderContext orderContext, Object object) {
        Instrument instrument = orderContext.getInstrument();
        float f2 = orderContext.getPositionAsFloat();
        float f3 = (float)this.getSettings().getTradeLots() * instrument.getDefaultQuantityAsFloat();
        switch (this.getSettings().getPositionType()) {
            case LONG: {
                if (f2 == 0.0f && object == BuffAverage$Signals.BUY) {
                    orderContext.buy(f3);
                }
                if (!(f2 > 0.0f) || object != BuffAverage$Signals.SELL) break;
                orderContext.sell(f3);
                break;
            }
            case SHORT: {
                if (f2 == 0.0f && object == BuffAverage$Signals.SELL) {
                    orderContext.sell(f3);
                }
                if (!(f2 < 0.0f) || object != BuffAverage$Signals.BUY) break;
                orderContext.buy(f3);
                break;
            }
            default: {
                f3 += Math.abs(f2);
                if (f2 <= 0.0f && object == BuffAverage$Signals.BUY) {
                    orderContext.buy(f3);
                }
                if (!(f2 >= 0.0f) || object != BuffAverage$Signals.SELL) break;
                orderContext.sell(f3);
            }
        }
    }
}

