/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.strategies;

import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.order_mgmt.OrderContext;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.SuperTrend;
import com.motivewave.platform.study.overlay.SuperTrend$Signals;
import com.motivewave.platform.study.overlay.SuperTrend$Values;

@StudyHeader(namespace="com.motivewave", id="SUPERTREND_STRATEGY", name="NAME_SUPER_TREND_STRATEGY", desc="DESC_SUPER_TREND_STRATEGY", rb="com.motivewave.platform.study.nls.strings", menu="MENU_GENERAL", overlay=true, signals=true, strategy=true, autoEntry=true, manualEntry=false, supportsUnrealizedPL=true, supportsRealizedPL=true, supportsTotalPL=true)
public class aq
extends SuperTrend {
    public void onActivate(OrderContext orderContext) {
        if (this.getSettings().isEnterOnActivate()) {
            DataSeries dataSeries;
            int n2 = (dataSeries = orderContext.getDataContext().getDataSeries()).isLastBarComplete() ? dataSeries.size() - 1 : dataSeries.size() - 2;
            Double d2 = dataSeries.getDouble(n2, (Object)SuperTrend$Values.TREND);
            if (d2 == null) {
                return;
            }
            int n3 = this.getSettings().getTradeLots();
            n3 = (int)((float)n3 * orderContext.getInstrument().getDefaultQuantityAsFloat());
            float f2 = n3;
            if (d2 > 0.0) {
                orderContext.buy(f2);
            } else {
                orderContext.sell(f2);
            }
        }
    }

    public void onSignal(OrderContext orderContext, Object object) {
        Instrument instrument = orderContext.getInstrument();
        float f2 = orderContext.getPositionAsFloat();
        float f3 = (float)this.getSettings().getTradeLots() * instrument.getDefaultQuantityAsFloat();
        f3 += Math.abs(f2);
        if (f2 <= 0.0f && object == SuperTrend$Signals.BUY) {
            orderContext.buy(f3);
        }
        if (f2 >= 0.0f && object == SuperTrend$Signals.SELL) {
            orderContext.sell(f3);
        }
    }
}

