/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Settings;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.VIDYA2$Signals;
import com.motivewave.platform.study.overlay.VIDYA2$Values;

@StudyHeader(namespace="com.motivewave", id="ID_VIDYA2", rb="com.motivewave.platform.study.nls.strings2", name="NAME_VIDYA2_INDICATOR", label="LBL_VIDYA2", desc="DESC_VIDYA2", menu="MENU_TUSHAR_CHANDE", helpLink="http://www.motivewave.com/studies/vidya2_indicator.htm", requiresVolume=false, signals=true, overlay=true, studyOverlay=true)
public class VIDYA2
extends Study {
    static final String a = "Alpha1";
    static final String b = "Alpha2";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 20, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("ALPHA1", new Object[0]), 0.2, 0.01, 10.01, 0.01)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(b, this.get("ALPHA2", new Object[0]), 0.04, 0.01, 10.01, 0.01)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_VIDYA1", new Object[0]), defaults.getGreen(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("LBL_VIDYA2", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true)});
        settingGroup2 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_VIDYA1", new Object[0]), defaults.getGreen(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("LBL_VIDYA2", new Object[0]), defaults.getRed(), null, false, true, true)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 5, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{a, b, "line", "line2"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", a, b});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VIDYA2$Values.VIDYA1, this.get("LBL_VIDYA1", new Object[0]), new String[]{"input", "method", "period", a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VIDYA2$Values.VIDYA2, this.get("LBL_VIDYA2", new Object[0]), new String[]{"input", "method", "period", b}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VIDYA2$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VIDYA2$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declarePath((Object)VIDYA2$Values.VIDYA1, "line");
        runtimeDescriptor.declarePath((Object)VIDYA2$Values.VIDYA2, "line2");
        runtimeDescriptor.declareIndicator((Object)VIDYA2$Values.VIDYA1, "ind");
        runtimeDescriptor.declareIndicator((Object)VIDYA2$Values.VIDYA2, "ind2");
        runtimeDescriptor.declareSignal((Object)VIDYA2$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)VIDYA2$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{VIDYA2$Values.VIDYA1, VIDYA2$Values.VIDYA2});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 * 2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        Settings settings = this.getSettings();
        int n3 = settings.getInteger("period");
        if (n2 < n3) {
            return;
        }
        Object object = settings.getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = settings.getMAMethod("method");
        double d2 = settings.getDouble(a);
        double d3 = settings.getDouble(b);
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d4 = dataSeries.std(n2, n3, object);
        if (d4 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)VIDYA2$Values.STD_DEV, d4);
        if (n2 < n3 * 2) {
            return;
        }
        double d5 = dataSeries.getDouble(n2, object, 0.0);
        Double d6 = dataSeries.ma(mAMethod, n2, n3, (Object)VIDYA2$Values.STD_DEV);
        if (d6 == null) {
            return;
        }
        double d7 = dataSeries.getDouble(n2 - 1, (Object)VIDYA2$Values.VIDYA1, d5);
        double d8 = dataSeries.getDouble(n2 - 1, (Object)VIDYA2$Values.VIDYA2, d5);
        double d9 = 0.0;
        if (d6 > 0.0) {
            d9 = d4 / d6;
        }
        double d10 = d2 * d9 * d5 + (1.0 - d2 * d9) * d7;
        double d11 = d3 * d9 * d5 + (1.0 - d3 * d9) * d8;
        dataSeries.setDouble(n2, (Object)VIDYA2$Values.VIDYA1, Double.valueOf(d10));
        dataSeries.setDouble(n2, (Object)VIDYA2$Values.VIDYA2, Double.valueOf(d11));
        boolean bl2 = this.crossedAbove(dataSeries, n2, (Object)VIDYA2$Values.VIDYA1, (Object)VIDYA2$Values.VIDYA2);
        boolean bl3 = this.crossedBelow(dataSeries, n2, (Object)VIDYA2$Values.VIDYA1, (Object)VIDYA2$Values.VIDYA2);
        if (bl3 && !dataSeries.getBoolean(n2, (Object)VIDYA2$Signals.SELL, false)) {
            dataSeries.setBoolean(n2, (Object)VIDYA2$Signals.SELL, Boolean.valueOf(true));
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d11);
            markerInfo = settings.getMarker("downMarker");
            string = this.get("SELL_PRICE_VIDYA", new Object[]{Util.round((double)d5, (int)2), Util.round((double)d10, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)VIDYA2$Signals.SELL, string, (Object)d5);
        }
        if (bl2 && !dataSeries.getBoolean(n2, (Object)VIDYA2$Signals.BUY, false)) {
            dataSeries.setBoolean(n2, (Object)VIDYA2$Signals.BUY, Boolean.valueOf(true));
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d11);
            markerInfo = settings.getMarker("upMarker");
            string = this.get("BUY_PRICE_VIDYA", new Object[]{Util.round((double)d5, (int)2), Util.round((double)d10, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)VIDYA2$Signals.BUY, string, (Object)d5);
        }
        dataSeries.setComplete(n2);
    }
}

