/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.VIDYA1$Values;

@StudyHeader(namespace="com.motivewave", id="ID_VIDYA1", rb="com.motivewave.platform.study.nls.strings2", name="NAME_VIDYA1_INDICATOR", label="LBL_VIDYA1", desc="DESC_VIDYA1", menu="MENU_TUSHAR_CHANDE", helpLink="http://www.motivewave.com/studies/vidya1_indicator.htm", requiresVolume=false, signals=false, overlay=true, studyOverlay=true)
public class VIDYA1
extends Study {
    static final String a = "Alpha";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 5, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("ALPHA", new Object[0]), 0.2, 0.01, 1.0, 0.01)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_VIDYA1", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 5, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{a, "line"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VIDYA1$Values.VIDYA1, this.get("LBL_VIDYA1", new Object[0]), new String[]{"input", "method", "period", a}));
        runtimeDescriptor.declarePath((Object)VIDYA1$Values.VIDYA1, "line");
        runtimeDescriptor.declareIndicator((Object)VIDYA1$Values.VIDYA1, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{VIDYA1$Values.VIDYA1});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 * 2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        double d2 = this.getSettings().getDouble(a);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d3 = dataSeries.std(n2, n3, object);
        dataSeries.setDouble(n2, (Object)VIDYA1$Values.STD_DEV, Double.valueOf(d3));
        if (n2 < n3 * 2) {
            return;
        }
        double d4 = dataSeries.getDouble(n2, object, 0.0);
        Double d5 = dataSeries.ma(mAMethod, n2, n3, (Object)VIDYA1$Values.STD_DEV);
        if (d5 == null) {
            return;
        }
        double d6 = dataSeries.getDouble(n2 - 1, (Object)VIDYA1$Values.VIDYA1, d4);
        double d7 = 0.0;
        if (d5 > 0.0) {
            d7 = d3 / d5;
        }
        double d8 = d2 * d7 * d4 + (1.0 - d2 * d7) * d6;
        dataSeries.setDouble(n2, (Object)VIDYA1$Values.VIDYA1, Double.valueOf(d8));
        dataSeries.setComplete(n2);
    }
}

