/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.j;
import com.motivewave.platform.study.overlay.TilsonIE2$Signals;
import com.motivewave.platform.study.overlay.TilsonIE2$Values;

@StudyHeader(namespace="com.motivewave", id="ID_EI/2", rb="com.motivewave.platform.study.nls.strings2", name="NAME_TILSON_IE2", label="LBL_TIE2", desc="DESC_TIE2", helpLink="http://www.motivewave.com/studies/tilson_ie2.htm", overlay=true, studyOverlay=true)
public class TilsonIE2
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 15, 1, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_TIE2", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("PRICE", new Object[0]), defaults.getGreen(), 1.0f, null, true, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        settingGroup2 = settingTab.addGroup(this.get("INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_TIE2", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("PRICE", new Object[0]), defaults.getGreen(), null, false, true, true)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD", new Object[0]), 15, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "line2"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TilsonIE2$Values.IE2, this.get("LBL_TIE2", new Object[0]), new String[]{"input", "method", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TilsonIE2$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TilsonIE2$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declareSignal((Object)TilsonIE2$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)TilsonIE2$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)TilsonIE2$Values.IE2, "line");
        runtimeDescriptor.declarePath((Object)TilsonIE2$Values.PRICE, "line2");
        runtimeDescriptor.declareIndicator((Object)TilsonIE2$Values.IE2, "ind");
        runtimeDescriptor.declareIndicator((Object)TilsonIE2$Values.PRICE, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{TilsonIE2$Values.IE2, TilsonIE2$Values.PRICE});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        Object object = this.getSettings().getInput("input");
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        Double d3 = dataSeries.ma(mAMethod, n2, n3, object);
        if (d3 == null) {
            return;
        }
        double[] dArray = j.a(dataSeries, n2, n3, object, 0);
        double d4 = dArray[0];
        double d5 = dArray[1] + d3;
        double d6 = (d5 + d4) / 2.0;
        dataSeries.setDouble(n2, (Object)TilsonIE2$Values.IE2, Double.valueOf(d6));
        dataSeries.setDouble(n2, (Object)TilsonIE2$Values.PRICE, Double.valueOf(d2));
        boolean bl2 = this.crossedAbove(dataSeries, n2, (Object)TilsonIE2$Values.IE2, (Object)TilsonIE2$Values.PRICE);
        boolean bl3 = this.crossedBelow(dataSeries, n2, (Object)TilsonIE2$Values.IE2, (Object)TilsonIE2$Values.PRICE);
        dataSeries.setBoolean(n2, (Object)TilsonIE2$Signals.SELL, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)TilsonIE2$Signals.BUY, Boolean.valueOf(bl2));
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d6);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_TILSON_IE2", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d6, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)TilsonIE2$Signals.SELL, string, (Object)d2);
        }
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d6);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_TILSON_IE2", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d6, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)TilsonIE2$Signals.BUY, string, (Object)d2);
        }
        dataSeries.setComplete(n2);
    }
}

