/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.NVP;
import com.motivewave.platform.sdk.common.PathInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.DiscreteDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Line;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.RegressionChannel$Signals;
import com.motivewave.platform.study.overlay.RegressionChannel$Values;
import java.util.ArrayList;

@StudyHeader(namespace="com.motivewave", id="ID_STAND_DEV_CHNL", rb="com.motivewave.platform.study.nls.strings", name="NAME_REGRESSION_CHANNEL", label="LBL_REGRESSION_CHANNEL", desc="DESC_REGRESSION_CHANNEL", menu="MENU_GENERAL", helpLink="http://www.motivewave.com/studies/standard_deviation_channel.htm", overlay=true, signals=true, studyOverlay=true)
public class RegressionChannel
extends Study {
    static final String a = "standDev";
    static final String b = "crossAboveTopMarker";
    static final String c = "crossBelowTopMarker";
    static final String d = "crossAboveMiddleMarker";
    static final String e = "crossBelowMiddleMarker";
    static final String f = "crossAboveBottomMarker";
    static final String g = "crossBelowBottomMarker";
    static final String h = "extendRight";
    static final String i = "extendLeft";
    static final String j = "1";
    static final String k = "1.5";
    static final String l = "2";
    static final String m = "0.674";
    static final String n = "1.282";
    static final String o = "1.645";
    static final String p = "1.96";
    static final String q = "2.58";
    static final String r = "2.81";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("bars", this.get("LBL_BARS", new Object[0]), 40, 1, 999, 1)});
        ArrayList<NVP> arrayList = new ArrayList<NVP>();
        arrayList.add(new NVP(this.get("LBL_CONFIDENCE_50", new Object[0]), m));
        arrayList.add(new NVP(this.get("LBL_CONFIDENCE_80", new Object[0]), n));
        arrayList.add(new NVP(this.get("LBL_CONFIDENCE_90", new Object[0]), o));
        arrayList.add(new NVP(this.get("LBL_CONFIDENCE_95", new Object[0]), p));
        arrayList.add(new NVP(this.get("LBL_CONFIDENCE_99", new Object[0]), q));
        arrayList.add(new NVP(this.get("LBL_CONFIDENCE_995", new Object[0]), r));
        arrayList.add(new NVP(this.get("LBL_DEV_1", new Object[0]), j));
        arrayList.add(new NVP(this.get("LBL_DEV_15", new Object[0]), k));
        arrayList.add(new NVP(this.get("LBL_DEV_2", new Object[0]), l));
        settingGroup.addRow(new SettingDescriptor[]{new DiscreteDescriptor(a, this.get("LBL_STANDARD_DEVIATION", new Object[0]), j, arrayList)});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(h, this.get("LBL_EXTEND_LINES_RIGHT", new Object[0]), Boolean.valueOf(true))});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(i, this.get("LBL_EXTEND_LINES_LEFT", new Object[0]), Boolean.valueOf(false))});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_LINES", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_TOP_LINE", new Object[0]), defaults.getLineColor(), 1.5f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("LBL_MIDDLE_LINE", new Object[0]), defaults.getLineColor(), 0.75f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line3", this.get("LBL_BOTTOM_LINE", new Object[0]), defaults.getLineColor(), 1.5f, null, true, false, true)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("LBL_MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor(b, this.get("LBL_CROSS_ABOVE_TOP", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor(c, this.get("LBL_CROSS_BELOW_TOP", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor(d, this.get("LBL_CROSS_ABOVE_MIDDLE", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getGreen(), defaults.getLineColor(), false, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor(e, this.get("LBL_CROSS_BELOW_MIDDLE", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getRed(), defaults.getLineColor(), false, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor(f, this.get("LBL_CROSS_ABOVE_BOTTOM", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor(g, this.get("LBL_CROSS_BELOW_BOTTOM", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{a, h, i});
        settingsDescriptor.addQuickSettings(new String[]{"line", "line2", "line3"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RegressionChannel$Values.TOP, this.get("LBL_TOP", new Object[0]), new String[]{"input", "bar", a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RegressionChannel$Values.MIDDLE, this.get("LBL_MIDDLE", new Object[0]), new String[]{"input", "bar", a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RegressionChannel$Values.BOTTOM, this.get("LBL_BOTTOM", new Object[0]), new String[]{"input", "bar", a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RegressionChannel$Signals.CROSS_ABOVE_TOP, Enums.ValueType.BOOLEAN, this.get("LBL_CROSS_ABOVE_TOP", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RegressionChannel$Signals.CROSS_BELOW_TOP, Enums.ValueType.BOOLEAN, this.get("LBL_CROSS_BELOW_TOP", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RegressionChannel$Signals.CROSS_ABOVE_MIDDLE, Enums.ValueType.BOOLEAN, this.get("LBL_CROSS_ABOVE_MIDDLE", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RegressionChannel$Signals.CROSS_BELOW_MIDDLE, Enums.ValueType.BOOLEAN, this.get("LBL_CROSS_BELOW_MIDDLE", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RegressionChannel$Signals.CROSS_ABOVE_BOTTOM, Enums.ValueType.BOOLEAN, this.get("LBL_CROSS_ABOVE_BOTTOM", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RegressionChannel$Signals.CROSS_BELOW_BOTTOM, Enums.ValueType.BOOLEAN, this.get("LBL_CROSS_BELOW_BOTTOM", new Object[0]), new String[0]));
        runtimeDescriptor.declareSignal((Object)RegressionChannel$Signals.CROSS_ABOVE_TOP, this.get("LBL_CROSS_ABOVE_TOP", new Object[0]));
        runtimeDescriptor.declareSignal((Object)RegressionChannel$Signals.CROSS_BELOW_TOP, this.get("LBL_CROSS_BELOW_TOP", new Object[0]));
        runtimeDescriptor.declareSignal((Object)RegressionChannel$Signals.CROSS_ABOVE_MIDDLE, this.get("LBL_CROSS_ABOVE_MIDDLE", new Object[0]));
        runtimeDescriptor.declareSignal((Object)RegressionChannel$Signals.CROSS_BELOW_MIDDLE, this.get("LBL_CROSS_BELOW_MIDDLE", new Object[0]));
        runtimeDescriptor.declareSignal((Object)RegressionChannel$Signals.CROSS_ABOVE_BOTTOM, this.get("LBL_CROSS_ABOVE_BOTTOM", new Object[0]));
        runtimeDescriptor.declareSignal((Object)RegressionChannel$Signals.CROSS_BELOW_BOTTOM, this.get("LBL_CROSS_BELOW_BOTTOM", new Object[0]));
        runtimeDescriptor.setMinTick(Double.valueOf(0.1));
        runtimeDescriptor.setLabelSettings(new String[]{"input", "bars", a});
        runtimeDescriptor.setRangeKeys(new Object[]{RegressionChannel$Values.TOP, RegressionChannel$Values.BOTTOM});
    }

    public int getMinBars() {
        return this.getSettings().getInteger("bars", 40);
    }

    public void onBarUpdate(DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        this.a(dataContext, dataSeries.size() - 1);
    }

    protected void calculateValues(DataContext dataContext) {
        int n2;
        PathInfo pathInfo;
        PathInfo pathInfo2;
        DataSeries dataSeries = dataContext.getDataSeries();
        this.clearFigures();
        int n3 = dataSeries.size() - 1;
        int n4 = this.getSettings().getInteger("bars");
        int n5 = n3 - n4;
        if (n5 < 0) {
            n5 = 0;
        }
        boolean bl2 = this.getSettings().getBoolean(h);
        boolean bl3 = this.getSettings().getBoolean(i);
        Object object = this.getSettings().getInput("input");
        String string = this.getSettings().getString(a);
        double d2 = Util.toDouble((String)string);
        int n6 = n3;
        if (!dataSeries.isBarComplete(n3)) {
            --n6;
        }
        double[] dArray = this.a(dataSeries, n6, n4, object, 0);
        double d3 = dArray[0];
        double d4 = dArray[1];
        Double d5 = dataSeries.std(n6, n4, object);
        if (d5 == null) {
            return;
        }
        d5 = d5 * d2;
        double d6 = d3;
        double d7 = d3 + d4 * (double)n4;
        PathInfo pathInfo3 = this.getSettings().getPath("line2");
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n5), d6);
        Coordinate coordinate2 = new Coordinate(dataSeries.getStartTime(n3), d7);
        if (pathInfo3.isEnabled()) {
            pathInfo2 = new Line(coordinate, coordinate2, pathInfo3);
            pathInfo2.setExtendLeftBounds(bl3);
            pathInfo2.setExtendRightBounds(bl2);
            this.addFigure((Figure)pathInfo2);
        }
        if ((pathInfo2 = this.getSettings().getPath("line")).isEnabled()) {
            d6 = d3 + d5;
            d7 = d3 + d5 + d4 * (double)n4;
            coordinate = new Coordinate(dataSeries.getStartTime(n5), d6);
            coordinate2 = new Coordinate(dataSeries.getStartTime(n3), d7);
            pathInfo = new Line(coordinate, coordinate2, pathInfo2);
            pathInfo.setExtendLeftBounds(bl3);
            pathInfo.setExtendRightBounds(bl2);
            this.addFigure((Figure)pathInfo);
        }
        if ((pathInfo = this.getSettings().getPath("line3")).isEnabled()) {
            d6 = d3 - d5;
            d7 = d3 - d5 + d4 * (double)n4;
            coordinate = new Coordinate(dataSeries.getStartTime(n5), d6);
            coordinate2 = new Coordinate(dataSeries.getStartTime(n3), d7);
            Line line = new Line(coordinate, coordinate2, pathInfo);
            line.setExtendLeftBounds(bl3);
            line.setExtendRightBounds(bl2);
            this.addFigure((Figure)line);
        }
        for (n2 = 0; n2 <= n3; ++n2) {
            dataSeries.setBoolean(n2, (Object)RegressionChannel$Signals.CROSS_ABOVE_TOP, Boolean.valueOf(false));
            dataSeries.setBoolean(n2, (Object)RegressionChannel$Signals.CROSS_BELOW_TOP, Boolean.valueOf(false));
            dataSeries.setBoolean(n2, (Object)RegressionChannel$Signals.CROSS_ABOVE_MIDDLE, Boolean.valueOf(false));
            dataSeries.setBoolean(n2, (Object)RegressionChannel$Signals.CROSS_BELOW_MIDDLE, Boolean.valueOf(false));
            dataSeries.setBoolean(n2, (Object)RegressionChannel$Signals.CROSS_ABOVE_BOTTOM, Boolean.valueOf(false));
            dataSeries.setBoolean(n2, (Object)RegressionChannel$Signals.CROSS_BELOW_BOTTOM, Boolean.valueOf(false));
        }
        n2 = 0;
        for (int i2 = n5; i2 <= n3; ++i2) {
            double d8 = d3 + d4 * (double)n2;
            double d9 = d8 + d5;
            double d10 = d8 - d5;
            dataSeries.setDouble(i2, (Object)RegressionChannel$Values.MIDDLE, Double.valueOf(d8));
            dataSeries.setDouble(i2, (Object)RegressionChannel$Values.TOP, Double.valueOf(d9));
            dataSeries.setDouble(i2, (Object)RegressionChannel$Values.BOTTOM, Double.valueOf(d10));
            this.a(dataContext, i2);
            ++n2;
        }
    }

    void a(DataContext dataContext, int n2) {
        String string;
        MarkerInfo markerInfo;
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, (Object)RegressionChannel$Values.TOP, 0.0);
        double d3 = dataSeries.getDouble(n2, (Object)RegressionChannel$Values.MIDDLE, 0.0);
        double d4 = dataSeries.getDouble(n2, (Object)RegressionChannel$Values.BOTTOM, 0.0);
        float f2 = dataSeries.getClose(n2);
        if (!dataSeries.getBoolean(n2, (Object)RegressionChannel$Signals.CROSS_ABOVE_TOP, false) && this.b(dataSeries, n2, d2)) {
            dataSeries.setBoolean(n2, (Object)RegressionChannel$Signals.CROSS_ABOVE_TOP, Boolean.valueOf(true));
            markerInfo = this.getSettings().getMarker(b);
            string = this.get("SIGNAL_CROSS_ABOVE_TOP", new Object[]{this.format(f2), this.format(d2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(new Coordinate(dataSeries.getStartTime(n2), d2), Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)RegressionChannel$Signals.CROSS_ABOVE_TOP, string, (Object)this.round(d2));
        } else if (!dataSeries.getBoolean(n2, (Object)RegressionChannel$Signals.CROSS_BELOW_TOP, false) && this.a(dataSeries, n2, d2)) {
            dataSeries.setBoolean(n2, (Object)RegressionChannel$Signals.CROSS_BELOW_TOP, Boolean.valueOf(true));
            markerInfo = this.getSettings().getMarker(c);
            string = this.get("SIGNAL_CROSS_BELOW_TOP", new Object[]{this.format(f2), this.format(d2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(new Coordinate(dataSeries.getStartTime(n2), d2), Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)RegressionChannel$Signals.CROSS_BELOW_TOP, string, (Object)this.round(d2));
        }
        if (!dataSeries.getBoolean(n2, (Object)RegressionChannel$Signals.CROSS_ABOVE_MIDDLE, false) && this.b(dataSeries, n2, d3)) {
            dataSeries.setBoolean(n2, (Object)RegressionChannel$Signals.CROSS_ABOVE_MIDDLE, Boolean.valueOf(true));
            markerInfo = this.getSettings().getMarker(d);
            string = this.get("SIGNAL_CROSS_ABOVE_MIDDLE", new Object[]{this.format(f2), this.format(d3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(new Coordinate(dataSeries.getStartTime(n2), d3), Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)RegressionChannel$Signals.CROSS_ABOVE_MIDDLE, string, (Object)this.round(d3));
        } else if (!dataSeries.getBoolean(n2, (Object)RegressionChannel$Signals.CROSS_BELOW_MIDDLE, false) && this.a(dataSeries, n2, d3)) {
            dataSeries.setBoolean(n2, (Object)RegressionChannel$Signals.CROSS_BELOW_MIDDLE, Boolean.valueOf(true));
            markerInfo = this.getSettings().getMarker(e);
            string = this.get("SIGNAL_CROSS_BELOW_MIDDLE", new Object[]{this.format(f2), this.format(d3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(new Coordinate(dataSeries.getStartTime(n2), d3), Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)RegressionChannel$Signals.CROSS_BELOW_MIDDLE, string, (Object)this.round(d3));
        }
        if (!dataSeries.getBoolean(n2, (Object)RegressionChannel$Signals.CROSS_ABOVE_BOTTOM, false) && this.b(dataSeries, n2, d4)) {
            dataSeries.setBoolean(n2, (Object)RegressionChannel$Signals.CROSS_ABOVE_BOTTOM, Boolean.valueOf(true));
            markerInfo = this.getSettings().getMarker(f);
            string = this.get("SIGNAL_CROSS_ABOVE_BOTTOM", new Object[]{this.format(f2), this.format(d4)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(new Coordinate(dataSeries.getStartTime(n2), d4), Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)RegressionChannel$Signals.CROSS_ABOVE_BOTTOM, string, (Object)this.round(d4));
        } else if (!dataSeries.getBoolean(n2, (Object)RegressionChannel$Signals.CROSS_BELOW_BOTTOM, false) && this.a(dataSeries, n2, d4)) {
            dataSeries.setBoolean(n2, (Object)RegressionChannel$Signals.CROSS_BELOW_BOTTOM, Boolean.valueOf(true));
            markerInfo = this.getSettings().getMarker(g);
            string = this.get("SIGNAL_CROSS_BELOW_BOTTOM", new Object[]{this.format(f2), this.format(d4)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(new Coordinate(dataSeries.getStartTime(n2), d4), Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)RegressionChannel$Signals.CROSS_BELOW_BOTTOM, string, (Object)this.round(d4));
        }
    }

    boolean a(DataSeries dataSeries, int n2, double d2) {
        double d3 = this.round(dataSeries.getClose(n2 - 1));
        double d4 = this.round(dataSeries.getLow(n2));
        return d3 >= d2 && d4 < d2;
    }

    boolean b(DataSeries dataSeries, int n2, double d2) {
        double d3 = this.round(dataSeries.getClose(n2 - 1));
        double d4 = this.round(dataSeries.getHigh(n2));
        return d3 <= d2 && d4 > d2;
    }

    double[] a(DataSeries dataSeries, int n2, int n3, Object object, int n4) {
        long l2 = 0L;
        long l3 = 0L;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n5 = 0;
        for (int i2 = n2 - n3 + 1; i2 <= n2; ++i2) {
            d2 = dataSeries.getDouble(i2, object, 0.0);
            if (d2 == 0.0) continue;
            l2 += (long)n5;
            d3 += d2;
            d4 += (double)n5 * d2;
            l3 += (long)(n5 * n5);
            ++n5;
        }
        double d5 = ((double)n3 * d4 - (double)l2 * d3) / (double)((long)n3 * l3 - l2 * l2);
        double d6 = (d3 - d5 * (double)l2) / (double)n3;
        double d7 = d6 + d5 * (double)n4;
        double[] dArray = new double[]{d7, d5};
        return dArray;
    }
}

