/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.NVP;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BarSizeDescriptor;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.DiscreteDescriptor;
import com.motivewave.platform.sdk.common.desc.EnabledDependency;
import com.motivewave.platform.sdk.common.desc.FontDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDependency;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.PivotPoints$Values;
import com.motivewave.platform.study.overlay.m;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="PIVOT_POINTS", rb="com.motivewave.platform.study.nls.strings", name="TITLE_PIVOT_POINTS", desc="DESC_PIVOT_POINTS", menu="MENU_OVERLAY", overlay=true, helpLink="http://www.motivewave.com/studies/pivot_points.htm")
public class PivotPoints
extends Study {
    static final String a = "resistInd";
    static final String b = "pivotInd";
    static final String c = "supportInd";
    private m a;
    protected Map a;
    private int a = -1;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        List<NVP> list = List.of(new NVP(this.get("LBL_CLASSIC", new Object[0]), "Classic"), new NVP(this.get("LBL_STANDARD", new Object[0]), "Standard"), new NVP(this.get("LBL_WOODIE", new Object[0]), "Woodie"), new NVP(this.get("LBL_CAMARILLA", new Object[0]), "Camarilla"), new NVP(this.get("LBL_FIBONACCI", new Object[0]), "Fibonacci"), new NVP(this.get("LBL_FIB_ZONE", new Object[0]), "Fib Zone"), new NVP(this.get("LBL_FIB_ZONE2", new Object[0]), "FibZone2"));
        settingTab.add("", new SettingDescriptor[]{new BarSizeDescriptor("barSize", this.get("LBL_TIMEFRAME", new Object[0]), BarSize.getBarSize((Enums.BarSizeType)Enums.BarSizeType.LINEAR, (int)1440)), new DiscreteDescriptor("pivotType", this.get("LBL_PIVOT_TYPE", new Object[0]), "Classic", list), new BooleanDescriptor("showAllPivots", this.get("LBL_SHOW_ALL_PIVOTS", new Object[0]), Boolean.valueOf(false), false), new BooleanDescriptor("extendRight", this.get("LBL_EXTEND_RIGHT", new Object[0]), Boolean.valueOf(false), false), new BooleanDescriptor("showLabels", this.get("LBL_SHOW_PIVOT_LABELS", new Object[0]), Boolean.valueOf(true), false), new BooleanDescriptor("showPrices", this.get("LBL_SHOW_PIVOT_PRICES", new Object[0]), Boolean.valueOf(false), false)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup("");
        PathDescriptor pathDescriptor = new PathDescriptor("line", this.get("LBL_RESISTANCE_LINE", new Object[0]), defaults.getGreenLine(), 2.0f, null, true, false, false, true);
        pathDescriptor.setSupportsShadeType(false);
        pathDescriptor.setSupportsColorPolicy(false);
        pathDescriptor.setSupportsShowPoints(false);
        pathDescriptor.setSupportsShowAsBars(false);
        pathDescriptor.setSupportsTag(false);
        settingGroup.addRow(new SettingDescriptor[]{pathDescriptor});
        pathDescriptor = new PathDescriptor("line2", this.get("LBL_PIVOT_LINE", new Object[0]), defaults.getLineColor(), 2.0f, null, true, false, false, true);
        pathDescriptor.setSupportsShadeType(false);
        pathDescriptor.setSupportsColorPolicy(false);
        pathDescriptor.setSupportsShowPoints(false);
        pathDescriptor.setSupportsShowAsBars(false);
        pathDescriptor.setSupportsTag(false);
        settingGroup.addRow(new SettingDescriptor[]{pathDescriptor});
        pathDescriptor = new PathDescriptor("line3", this.get("LBL_SUPPORT_LINE", new Object[0]), defaults.getRedLine(), 2.0f, null, true, false, false, true);
        pathDescriptor.setSupportsShadeType(false);
        pathDescriptor.setSupportsColorPolicy(false);
        pathDescriptor.setSupportsShowPoints(false);
        pathDescriptor.setSupportsShowAsBars(false);
        pathDescriptor.setSupportsTag(false);
        settingGroup.addRow(new SettingDescriptor[]{pathDescriptor});
        pathDescriptor = new PathDescriptor("line4", this.get("LBL_MIDDLE_LINES", new Object[0]), defaults.getGrey(), 1.0f, null, false, false, false, true);
        pathDescriptor.setSupportsColorPolicy(false);
        pathDescriptor.setSupportsShadeType(false);
        pathDescriptor.setSupportsShowPoints(false);
        pathDescriptor.setSupportsShowAsBars(false);
        pathDescriptor.setSupportsTag(false);
        settingGroup.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup.addRow(new SettingDescriptor[]{new FontDescriptor("font", this.get("LBL_FONT", new Object[0]), new Font("Arial", 1, 12))});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor(a, this.get("LBL_RESIST_IND", new Object[0]), defaults.getGreen(), null, false, false, true)});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor(b, this.get("LBL_PIVOT_IND", new Object[0]), null, null, false, false, true)});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor(c, this.get("LBL_SUPPORT_IND", new Object[0]), defaults.getRed(), null, false, false, true)});
        settingsDescriptor.addDependency((InputDependency)new EnabledDependency("showLabels", new String[]{"showPrices"}));
        settingsDescriptor.addQuickSettings(new String[]{"barSize", "pivotType", "showAllPivots", "extendRight", "showLabels", "showPrices"});
        settingsDescriptor.addQuickSettings(new String[]{"line", "line2", "line3", "line4"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"barSize", "pivotType"});
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.P, b);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.R1, a);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.R2, a);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.R3, a);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.R4, a);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.R5, a);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.R6, a);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.R7, a);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.R8, a);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.S1, c);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.S2, c);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.S3, c);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.S4, c);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.S5, c);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.S6, c);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.S7, c);
        runtimeDescriptor.declareIndicator((Object)PivotPoints$Values.S8, c);
        this.setMinBars(2);
    }

    public void clearState() {
        super.clearState();
        this.a.clear();
        this.a = null;
        this.a = -1;
    }

    public void onBarClose(DataContext dataContext) {
        this.calculateValues(dataContext);
    }

    protected void calculateValues(DataContext dataContext) {
        BarSize barSize = this.getSettings().getBarSize("barSize");
        DataSeries dataSeries = dataContext.getDataSeries(barSize);
        if (dataSeries == null || dataSeries.size() < 2) {
            return;
        }
        if (this.a != null && this.a.b > dataContext.getCurrentTime() && this.a == dataSeries.size()) {
            return;
        }
        boolean bl2 = this.getSettings().getBoolean("showAllPivots");
        boolean bl3 = this.getSettings().getBoolean("extendRight");
        String string = this.getSettings().getString("pivotType");
        int n2 = 0;
        if (!bl2) {
            n2 = dataSeries.size() - 1;
        }
        this.a.clear();
        ArrayList<m> arrayList = new ArrayList<m>();
        this.a = dataSeries.size();
        Instrument instrument = dataSeries.getInstrument();
        for (int i2 = n2; i2 < dataSeries.size(); ++i2) {
            long l2 = dataSeries.getStartTime(i2);
            long l3 = dataSeries.getEndTime(i2);
            if (barSize.isLinear() && barSize.getIntervalMinutes() >= 1440) {
                l2 = instrument.getStartOfDay(l2 + 21600000L, dataContext.isRTH());
                if (dataContext.isRTH() && l2 < dataSeries.getStartTime(i2) - 21600000L) {
                    l2 += 86400000L;
                }
                l3 = Util.getEndOfBar((long)l2, (long)(l2 + barSize.getSizeMillis()), (Instrument)instrument, (BarSize)barSize, (boolean)dataContext.isRTH());
            }
            if (this.a.containsKey(l2)) continue;
            double d2 = dataSeries.getHigh(i2 - 1);
            double d3 = dataSeries.getLow(i2 - 1);
            double d4 = dataSeries.getClose(i2 - 1);
            double d5 = dataSeries.getOpen(i2 - 1);
            double d6 = (d2 + d3 + d4) / 3.0;
            double d7 = d2 - d3;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            double d12 = 0.0;
            double d13 = 0.0;
            double d14 = 0.0;
            double d15 = 0.0;
            double d16 = 0.0;
            double d17 = 0.0;
            double d18 = 0.0;
            double d19 = 0.0;
            double d20 = 0.0;
            double d21 = 0.0;
            double d22 = 0.0;
            double d23 = 0.0;
            m m2 = null;
            if (Util.compare((Object)string, (Object)"Woodie")) {
                d6 = (d2 + d3 + d4 + d5) / 4.0;
                d8 = 2.0 * d6 - d3;
                d9 = d6 + d7;
                d10 = d2 + 2.0 * (d6 - d3);
                d11 = d10 + d7;
                d16 = 2.0 * d6 - d2;
                d17 = d6 - d7;
                d18 = d3 - 2.0 * (d2 - d6);
                d19 = d18 - d7;
                m2 = new m(l2, l3, d6, d8, d9, d10, d11, d16, d17, d18, d19);
            } else if (Util.compare((Object)string, (Object)"Camarilla")) {
                d11 = d4 + d7 * 1.1 / 2.0;
                d10 = d4 + d7 * 1.1 / 4.0;
                d9 = d4 + d7 * 1.1 / 6.0;
                d8 = d4 + d7 * 1.1 / 12.0;
                d16 = d4 - d7 * 1.1 / 12.0;
                d17 = d4 - d7 * 1.1 / 6.0;
                d18 = d4 - d7 * 1.1 / 4.0;
                d19 = d4 - d7 * 1.1 / 2.0;
                m2 = new m(l2, l3, d4, d8, d9, d10, d11, d16, d17, d18, d19);
            } else if (Util.compare((Object)string, (Object)"Fibonacci")) {
                d11 = d6 + 1.618 * d7;
                d10 = d6 + 1.0 * d7;
                d9 = d6 + 0.618 * d7;
                d8 = d6 + 0.382 * d7;
                d16 = d6 - 0.382 * d7;
                d17 = d6 - 0.618 * d7;
                d18 = d6 - 1.0 * d7;
                d19 = d6 - 1.618 * d7;
                m2 = new m(l2, l3, d6, d8, d9, d10, d11, d16, d17, d18, d19);
                m2.n = "+0.382";
                m2.o = "+0.618";
                m2.p = "+1.00";
                m2.q = "+1.618";
                m2.m = "BP";
                m2.v = "-0.382";
                m2.w = "-0.618";
                m2.x = "-1.00";
                m2.y = "-1.618";
            } else if (Util.compare((Object)string, (Object)"Fib Zone")) {
                d11 = d6 + 1.382 * d7;
                d10 = d6 + d7;
                d9 = d6 + 0.618 * d7;
                d8 = d6 + 0.5 * d7;
                d16 = d6 - 0.5 * d7;
                d17 = d6 - 0.618 * d7;
                d18 = d6 - d7;
                d19 = d6 - 1.382 * d7;
                m2 = new m(l2, l3, d6, d8, d9, d10, d11, d16, d17, d18, d19);
                m2.a(d11, d10);
                m2.a(d9, d8);
                m2.a(d16, d17);
                m2.a(d18, d19);
                m2.n = "+0.5";
                m2.o = "+0.618";
                m2.p = "+1.00";
                m2.q = "+1.382";
                m2.m = "BP";
                m2.v = "-0.5";
                m2.w = "-0.618";
                m2.x = "-1.00";
                m2.y = "-1.382";
            } else if (Util.compare((Object)string, (Object)"FibZone2")) {
                d15 = d6 + 2.618 * d7;
                d14 = d6 + 1.618 * d7;
                d13 = d6 + 1.27 * d7;
                d12 = d6 + 1.13 * d7;
                d11 = d6 + 0.886 * d7;
                d10 = d6 + 0.786 * d7;
                d9 = d6 + 0.618 * d7;
                d8 = d6 + 0.382 * d7;
                d16 = d6 - 0.382 * d7;
                d17 = d6 - 0.618 * d7;
                d18 = d6 - 0.786 * d7;
                d19 = d6 - 0.886 * d7;
                d20 = d6 - 1.13 * d7;
                d21 = d6 - 1.27 * d7;
                d22 = d6 - 1.618 * d7;
                d23 = d6 - 2.618 * d7;
                m2 = new m(l2, l3, d6, d8, d9, d10, d11, d12, d13, d14, d15, d16, d17, d18, d19, d20, d21, d22, d23);
                m2.a(d14, d15);
                m2.a(d12, d13);
                m2.a(d11, d10);
                m2.a(d9, d8);
                m2.a(d16, d17);
                m2.a(d18, d19);
                m2.a(d20, d21);
                m2.a(d22, d23);
                m2.n = "+0.382";
                m2.o = "+0.618";
                m2.p = "+0.786";
                m2.q = "+0.886";
                m2.r = "+1.13";
                m2.s = "+1.27";
                m2.t = "+1.618";
                m2.u = "+2.618";
                m2.m = "BP";
                m2.v = "-0.382";
                m2.w = "-0.618";
                m2.x = "-0.786";
                m2.y = "-0.886";
                m2.z = "-1.13";
                m2.A = "-1.27";
                m2.B = "-1.618";
                m2.C = "-2.618";
            } else if (Util.compare((Object)string, (Object)"Standard")) {
                d8 = d6 * 2.0 - d3;
                d16 = d6 * 2.0 - d2;
                d9 = d6 + (d2 - d3);
                d17 = d6 - (d2 - d3);
                m2 = new m(l2, l3, d6, d8, d9, d16, d17);
            } else {
                d8 = d6 * 2.0 - d3;
                d16 = d6 * 2.0 - d2;
                d9 = d6 - d16 + d8;
                d17 = d6 - (d8 - d16);
                d10 = 2.0 * (d6 - d3) + d2;
                d18 = d3 - 2.0 * (d2 - d6);
                m2 = new m(l2, l3, d6, d8, d9, d10, d16, d17, d18);
            }
            m2.a(bl3 && i2 == dataSeries.size() - 1);
            this.a.put(l2, m2);
            arrayList.add(m2);
        }
        m m3 = null;
        for (m m4 : this.a.values()) {
            if (m3 == null) {
                m3 = m4;
                continue;
            }
            if (m4.a <= m3.a) continue;
            m3 = m4;
        }
        if (m3 != null) {
            DataSeries dataSeries2 = dataContext.getDataSeries();
            dataSeries2.setDouble((Object)PivotPoints$Values.P, m3.c() == 0.0 ? null : Double.valueOf(m3.c()));
            dataSeries2.setDouble((Object)PivotPoints$Values.R1, m3.d() == 0.0 ? null : Double.valueOf(m3.d()));
            dataSeries2.setDouble((Object)PivotPoints$Values.R2, m3.e() == 0.0 ? null : Double.valueOf(m3.e()));
            dataSeries2.setDouble((Object)PivotPoints$Values.R3, m3.f() == 0.0 ? null : Double.valueOf(m3.f()));
            dataSeries2.setDouble((Object)PivotPoints$Values.R4, m3.g() == 0.0 ? null : Double.valueOf(m3.g()));
            dataSeries2.setDouble((Object)PivotPoints$Values.R5, m3.h() == 0.0 ? null : Double.valueOf(m3.h()));
            dataSeries2.setDouble((Object)PivotPoints$Values.R6, m3.i() == 0.0 ? null : Double.valueOf(m3.i()));
            dataSeries2.setDouble((Object)PivotPoints$Values.R7, m3.j() == 0.0 ? null : Double.valueOf(m3.j()));
            dataSeries2.setDouble((Object)PivotPoints$Values.R8, m3.k() == 0.0 ? null : Double.valueOf(m3.k()));
            dataSeries2.setDouble((Object)PivotPoints$Values.S1, m3.l() == 0.0 ? null : Double.valueOf(m3.l()));
            dataSeries2.setDouble((Object)PivotPoints$Values.S2, m3.m() == 0.0 ? null : Double.valueOf(m3.m()));
            dataSeries2.setDouble((Object)PivotPoints$Values.S3, m3.n() == 0.0 ? null : Double.valueOf(m3.n()));
            dataSeries2.setDouble((Object)PivotPoints$Values.S4, m3.o() == 0.0 ? null : Double.valueOf(m3.o()));
            dataSeries2.setDouble((Object)PivotPoints$Values.S5, m3.p() == 0.0 ? null : Double.valueOf(m3.p()));
            dataSeries2.setDouble((Object)PivotPoints$Values.S6, m3.q() == 0.0 ? null : Double.valueOf(m3.q()));
            dataSeries2.setDouble((Object)PivotPoints$Values.S7, m3.r() == 0.0 ? null : Double.valueOf(m3.r()));
            dataSeries2.setDouble((Object)PivotPoints$Values.S8, m3.s() == 0.0 ? null : Double.valueOf(m3.s()));
        }
        this.a = m3;
        this.beginFigureUpdate();
        this.setFigures(arrayList);
        this.endFigureUpdate();
    }
}

