/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.MovAvgSuppRes$Signals;
import com.motivewave.platform.study.overlay.MovAvgSuppRes$Values;

@StudyHeader(namespace="com.motivewave", id="ID_MASR", rb="com.motivewave.platform.study.nls.strings2", name="NAME_MOVING_AVERAGE_SUPPORT_RESISTANCE", label="LBL_MASR", desc="DESC_MASR", helpLink="http://www.motivewave.com/studies/moving_average_support_resistance.htm", requiresVolume=false, signals=true, overlay=true, studyOverlay=true)
public class MovAvgSuppRes
extends Study {
    static final String a = "perCentFac";
    static final String b = "Ind3";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 10, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("PERCENT_FAC", new Object[0]), 2.0, 0.0, 100.01, 0.01)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("TOP", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_MASR", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line3", this.get("BOTTOM", new Object[0]), defaults.getGreen(), 1.0f, null, true, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        settingGroup2 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("TOP", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_MASR", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(b, this.get("BOTTOM", new Object[0]), defaults.getGreen(), null, false, true, true)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD", new Object[0]), 9, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{a, "line2", "line", "line2"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MovAvgSuppRes$Values.MASR, this.get("LBL_MASR", new Object[0]), new String[]{"input", "method", "period", a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MovAvgSuppRes$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MovAvgSuppRes$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.declareSignal((Object)MovAvgSuppRes$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declareSignal((Object)MovAvgSuppRes$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declarePath((Object)MovAvgSuppRes$Values.TOP, "line2");
        runtimeDescriptor.declarePath((Object)MovAvgSuppRes$Values.MASR, "line");
        runtimeDescriptor.declarePath((Object)MovAvgSuppRes$Values.BOTT, "line3");
        runtimeDescriptor.declareIndicator((Object)MovAvgSuppRes$Values.TOP, "ind2");
        runtimeDescriptor.declareIndicator((Object)MovAvgSuppRes$Values.MASR, "ind");
        runtimeDescriptor.declareIndicator((Object)MovAvgSuppRes$Values.BOTT, b);
        runtimeDescriptor.setRangeKeys(new Object[]{MovAvgSuppRes$Values.MASR, MovAvgSuppRes$Values.TOP, MovAvgSuppRes$Values.BOTT});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        int n3 = this.getSettings().getInteger("period");
        double d2 = this.getSettings().getDouble(a);
        if (n2 < n3) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d3 = dataSeries.ma(mAMethod, n2, n3, object);
        if (d3 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)MovAvgSuppRes$Values.MASR, d3);
        double d4 = dataSeries.getDouble(n2, object, 0.0);
        double d5 = dataSeries.getHigh(n2);
        double d6 = dataSeries.getLow(n2);
        double d7 = 1.0 + d2 / 100.0;
        double d8 = d3 * d7;
        double d9 = d3 / d7;
        dataSeries.setDouble(n2, (Object)MovAvgSuppRes$Values.TOP, Double.valueOf(d8));
        dataSeries.setDouble(n2, (Object)MovAvgSuppRes$Values.BOTT, Double.valueOf(d9));
        boolean bl2 = d4 > d8;
        boolean bl3 = d4 < d9;
        dataSeries.setBoolean(n2, (Object)MovAvgSuppRes$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)MovAvgSuppRes$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d5);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_MASR_PRICE_TOP", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d8, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)MovAvgSuppRes$Signals.SELL, string, (Object)d4);
        }
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d6);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_MASR_PRICE_BOTTOM", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d9, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)MovAvgSuppRes$Signals.BUY, string, (Object)d4);
        }
        dataSeries.setComplete(n2);
    }
}

