/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.MovAvgDispEnv$Signals;
import com.motivewave.platform.study.overlay.MovAvgDispEnv$Values;

@StudyHeader(namespace="com.motivewave", id="ID_MADE", rb="com.motivewave.platform.study.nls.strings2", name="NAME_MOVING_AVERAGE_DISPLACED_ENVELOPE", label="LBL_MADE", desc="DESC_MADE", helpLink="http://www.motivewave.com/studies/moving_average_displaced_envelope.htm", requiresVolume=false, signals=true, overlay=true, studyOverlay=true)
public class MovAvgDispEnv
extends Study {
    static final String a = "PercentAbov";
    static final String b = "PercentBlw";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 9, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("PERCENT_ABOVE", new Object[0]), 2.0, 0.0, 100.01, 0.01)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(b, this.get("PERCENT_BELOW", new Object[0]), 2.0, 0.0, 100.01, 0.01)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("DISPLACE", new Object[0]), 13, -999, 999, 1)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("TOP", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("BOTTOM", new Object[0]), defaults.getGreen(), 1.0f, null, true, true, true)});
        settingGroup2 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("TOP", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("BOTTOM", new Object[0]), defaults.getGreen(), null, false, true, true)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD", new Object[0]), 9, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{a, b});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("DISPLACE", new Object[0]), 13, -999, 999, true, () -> Enums.Icon.SHIFT.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "line2"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MovAvgDispEnv$Values.TOP, this.get("TOP", new Object[0]), new String[]{"input", "method", "period", a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MovAvgDispEnv$Values.BOTTOM, this.get("BOTTOM", new Object[0]), new String[]{"input", "method", "period", b}));
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", a, b, "period2"});
        runtimeDescriptor.declarePath((Object)MovAvgDispEnv$Values.TOP, "line");
        runtimeDescriptor.declarePath((Object)MovAvgDispEnv$Values.BOTTOM, "line2");
        runtimeDescriptor.declareIndicator((Object)MovAvgDispEnv$Values.TOP, "ind");
        runtimeDescriptor.declareIndicator((Object)MovAvgDispEnv$Values.BOTTOM, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{MovAvgDispEnv$Values.TOP, MovAvgDispEnv$Values.BOTTOM});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 + n3);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3;
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.EMA);
        int n4 = this.getSettings().getInteger("period");
        if (n2 < n4 + (n3 = this.getSettings().getInteger("period2").intValue())) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.getDouble(n2, object);
        if (d2 == null) {
            return;
        }
        double d3 = this.getSettings().getDouble(a);
        double d4 = this.getSettings().getDouble(b);
        Double d5 = dataSeries.ma(mAMethod, n2 - n3, n4, object);
        if (d5 == null) {
            return;
        }
        d5 = d5 * ((100.0 + d3) / 100.0);
        Double d6 = dataSeries.ma(mAMethod, n2 - n3, n4, object);
        if (d6 == null) {
            return;
        }
        d6 = d6 * ((100.0 - d4) / 100.0);
        dataSeries.setDouble(n2, (Object)MovAvgDispEnv$Values.TOP, d5);
        dataSeries.setDouble(n2, (Object)MovAvgDispEnv$Values.BOTTOM, d6);
        double d7 = dataSeries.getHigh(n2 - 1);
        double d8 = dataSeries.getLow(n2 - 1);
        boolean bl2 = d7 > d5;
        boolean bl3 = d8 < d6;
        dataSeries.setBoolean(n2, (Object)MovAvgDispEnv$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)MovAvgDispEnv$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d7);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_MADE_PRICE", new Object[]{Util.round((double)d2, (int)2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)MovAvgDispEnv$Signals.SELL, string, (Object)d2);
        }
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d8);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_MADE_PRICE", new Object[]{Util.round((double)d2, (int)2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)MovAvgDispEnv$Signals.BUY, string, (Object)d2);
        }
        dataSeries.setComplete(n2);
    }
}

