/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.j;
import com.motivewave.platform.study.overlay.MovAvgAdaptive$Values;

@StudyHeader(namespace="com.motivewave", id="ID_MAA", rb="com.motivewave.platform.study.nls.strings2", name="NAME_MOVING_AVERAGE_ADAPTIVE", label="LBL_MAA", desc="DESC_MAA", helpLink="http://www.motivewave.com/studies/moving_average_adaptive.htm", requiresVolume=false, signals=false, overlay=true, studyOverlay=true)
public class MovAvgAdaptive
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 34, 1, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("MAA", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("LRV", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true)});
        settingGroup2 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("MAA", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("LRV", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD", new Object[0]), 34, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "line2"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MovAvgAdaptive$Values.MAA, this.get("LBL_MAA", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MovAvgAdaptive$Values.LRV, this.get("LRV", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period"});
        runtimeDescriptor.declarePath((Object)MovAvgAdaptive$Values.MAA, "line");
        runtimeDescriptor.declarePath((Object)MovAvgAdaptive$Values.LRV, "line2");
        runtimeDescriptor.declareIndicator((Object)MovAvgAdaptive$Values.MAA, "ind");
        runtimeDescriptor.declareIndicator((Object)MovAvgAdaptive$Values.LRV, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{MovAvgAdaptive$Values.MAA, MovAvgAdaptive$Values.LRV});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 * 3);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = 0.667;
        double d3 = 0.0645;
        double d4 = dataSeries.getDouble(n2, object, 0.0);
        double d5 = dataSeries.getDouble(n2 - 1, object, 0.0);
        double d6 = Math.abs(d4 - d5);
        dataSeries.setDouble(n2, (Object)MovAvgAdaptive$Values.DIFF, Double.valueOf(d6));
        if (n2 < n3 * 2) {
            return;
        }
        double d7 = dataSeries.getDouble(n2 - n3, object, 0.0);
        double d8 = Math.abs(d4 - d7);
        double d9 = dataSeries.sum(n2, n3, (Object)MovAvgAdaptive$Values.DIFF);
        double d10 = d8 / d9;
        double d11 = Math.pow(d10 * (d2 - d3) + d3, 2.0);
        double d12 = dataSeries.getDouble(n2 - 1, (Object)MovAvgAdaptive$Values.MAA, d4);
        double d13 = d12 + d11 * (d4 - d12);
        dataSeries.setDouble(n2, (Object)MovAvgAdaptive$Values.MAA, Double.valueOf(d13));
        if (n2 < n3 * 3) {
            return;
        }
        double[] dArray = j.a(dataSeries, n2, n3, (Object)MovAvgAdaptive$Values.MAA, 0);
        dataSeries.setDouble(n2, (Object)MovAvgAdaptive$Values.LRV, Double.valueOf(dArray[0]));
        dataSeries.setComplete(n2);
    }
}

