/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.Mama$Signals;
import com.motivewave.platform.study.overlay.Mama$Values;

@StudyHeader(namespace="com.motivewave", id="ID_MAMA", rb="com.motivewave.platform.study.nls.strings2", label="LBL_MAMA", name="NAME_MAMA", desc="DESC_MAMA", menu="MENU_JOHN_EHLERS", helpLink="http://www.motivewave.com/studies/mama.htm", signals=true, overlay=true, studyOverlay=true)
public class Mama
extends Study {
    static final String a = "Fast";
    static final String b = "Slow";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.MIDPOINT)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("FAST_LIMIT", new Object[0]), 0.5, 0.0, 99.01, 0.01)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(b, this.get("SLOW_LIMIT", new Object[0]), 0.05, 0.0, 99.01, 0.01)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_MAMA", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("FAMA", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        settingGroup2 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_MAMA", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("FAMA", new Object[0]), defaults.getRed(), null, false, true, true)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", a, b, "line", "line2"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", a, b});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Mama$Values.MAMA, this.get("LBL_MAMA", new Object[0]), new String[]{"input", a, b}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Mama$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Mama$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declareSignal((Object)Mama$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)Mama$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)Mama$Values.MAMA, "line");
        runtimeDescriptor.declarePath((Object)Mama$Values.FAMA, "line2");
        runtimeDescriptor.declareIndicator((Object)Mama$Values.MAMA, "ind");
        runtimeDescriptor.declareIndicator((Object)Mama$Values.FAMA, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{Mama$Values.MAMA, Mama$Values.FAMA});
        this.setMinBars(25);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        if (n2 < 3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.MIDPOINT);
        double d2 = this.getSettings().getDouble(a);
        double d3 = this.getSettings().getDouble(b);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = dataSeries.getDouble(n2, object, 0.0);
        double d9 = dataSeries.getDouble(n2 - 1, object, 0.0);
        double d10 = dataSeries.getDouble(n2 - 2, object, 0.0);
        double d11 = dataSeries.getDouble(n2 - 3, object, 0.0);
        double d12 = dataSeries.getDouble(n2 - 1, (Object)Mama$Values.PERIOD, 0.0);
        double d13 = (4.0 * d8 + 3.0 * d9 + 2.0 * d10 + d11) / 10.0;
        dataSeries.setDouble(n2, (Object)Mama$Values.SMOOTH, Double.valueOf(d13));
        if (n2 < 9) {
            return;
        }
        double d14 = dataSeries.getDouble(n2 - 2, (Object)Mama$Values.SMOOTH, 0.0);
        double d15 = dataSeries.getDouble(n2 - 4, (Object)Mama$Values.SMOOTH, 0.0);
        double d16 = dataSeries.getDouble(n2 - 6, (Object)Mama$Values.SMOOTH, 0.0);
        double d17 = (0.0962 * d13 + 0.5769 * d14 - 0.5769 * d15 - 0.0962 * d16) * (0.075 * d12 + 0.54);
        dataSeries.setDouble(n2, (Object)Mama$Values.DET, Double.valueOf(d17));
        if (n2 < 15) {
            return;
        }
        double d18 = dataSeries.getDouble(n2 - 2, (Object)Mama$Values.DET, 0.0);
        double d19 = dataSeries.getDouble(n2 - 3, (Object)Mama$Values.DET, 0.0);
        double d20 = dataSeries.getDouble(n2 - 4, (Object)Mama$Values.DET, 0.0);
        double d21 = dataSeries.getDouble(n2 - 6, (Object)Mama$Values.DET, 0.0);
        double d22 = (0.0962 * d17 + 0.5769 * d18 - 0.5769 * d20 - 0.0962 * d21) * (0.075 * d12 + 0.54);
        double d23 = d19;
        dataSeries.setDouble(n2, (Object)Mama$Values.Q1, Double.valueOf(d22));
        dataSeries.setDouble(n2, (Object)Mama$Values.I1, Double.valueOf(d23));
        if (n2 < 21) {
            return;
        }
        double d24 = dataSeries.getDouble(n2 - 2, (Object)Mama$Values.Q1, 0.0);
        double d25 = dataSeries.getDouble(n2 - 4, (Object)Mama$Values.Q1, 0.0);
        double d26 = dataSeries.getDouble(n2 - 6, (Object)Mama$Values.Q1, 0.0);
        double d27 = dataSeries.getDouble(n2 - 2, (Object)Mama$Values.I1, 0.0);
        double d28 = dataSeries.getDouble(n2 - 4, (Object)Mama$Values.I1, 0.0);
        double d29 = dataSeries.getDouble(n2 - 6, (Object)Mama$Values.I1, 0.0);
        double d30 = (0.0962 * d23 + 0.5769 * d27 - 0.5769 * d28 - 0.0962 * d29) * (0.075 * d12 + 0.54);
        double d31 = (0.0962 * d22 + 0.5769 * d24 - 0.5769 * d25 - 0.0962 * d26) * (0.075 * d12 + 0.54);
        double d32 = d23 - d31;
        double d33 = d22 + d30;
        double d34 = dataSeries.getDouble(n2 - 1, (Object)Mama$Values.I2, 0.0);
        double d35 = dataSeries.getDouble(n2 - 1, (Object)Mama$Values.Q2, 0.0);
        d32 = 0.2 * d32 + 0.8 * d34;
        d33 = 0.2 * d33 + 0.8 * d35;
        dataSeries.setDouble(n2, (Object)Mama$Values.Q2, Double.valueOf(d33));
        dataSeries.setDouble(n2, (Object)Mama$Values.I2, Double.valueOf(d32));
        double d36 = d32 * d34 + d33 * d35;
        double d37 = d32 * d35 - d33 * d34;
        double d38 = dataSeries.getDouble(n2 - 1, (Object)Mama$Values.RE, 0.0);
        double d39 = dataSeries.getDouble(n2 - 1, (Object)Mama$Values.IM, 0.0);
        d36 = 0.2 * d36 + 0.8 * d38;
        d37 = 0.2 * d37 + 0.8 * d39;
        dataSeries.setDouble(n2, (Object)Mama$Values.RE, Double.valueOf(d36));
        dataSeries.setDouble(n2, (Object)Mama$Values.IM, Double.valueOf(d37));
        if (d37 != 0.0 && d36 != 0.0) {
            d4 = 360.0 / Math.atan(d37 / d36);
        }
        if (d4 > 1.5 * d12) {
            d4 = 1.5 * d12;
        }
        if (d4 < 0.67 * d12) {
            d4 = 0.67 * d12;
        }
        if (d4 < 6.0) {
            d4 = 6.0;
        }
        if (d4 > 50.0) {
            d4 = 50.0;
        }
        d4 = 0.2 * d4 + 0.8 * d12;
        double d40 = dataSeries.getDouble(n2 - 1, (Object)Mama$Values.SPRD, 0.0);
        double d41 = 0.33 * d4 + 0.67 * d40;
        dataSeries.setDouble(n2, (Object)Mama$Values.SPRD, Double.valueOf(d41));
        if (d23 != 0.0) {
            d5 = Math.atan(d22 / d23);
        }
        dataSeries.setDouble(n2, (Object)Mama$Values.PHASE, Double.valueOf(d5));
        if (n2 < 22) {
            return;
        }
        double d42 = dataSeries.getDouble(n2 - 1, (Object)Mama$Values.PHASE, 0.0);
        d6 = d42 - d5;
        if (d6 < 1.0) {
            d6 = 1.0;
        }
        if ((d7 = d2 / d6) < d3) {
            d7 = d3;
        }
        double d43 = dataSeries.getDouble(n2 - 1, (Object)Mama$Values.MAMA, 0.0);
        double d44 = dataSeries.getDouble(n2 - 1, (Object)Mama$Values.FAMA, 0.0);
        double d45 = d7 * d8 + (1.0 - d7) * d43;
        double d46 = 0.5 * d7 * d45 + (1.0 - 0.5 * d7) * d44;
        dataSeries.setDouble(n2, (Object)Mama$Values.MAMA, Double.valueOf(d45));
        dataSeries.setDouble(n2, (Object)Mama$Values.FAMA, Double.valueOf(d46));
        boolean bl2 = this.crossedAbove(dataSeries, n2, (Object)Mama$Values.MAMA, (Object)Mama$Values.FAMA);
        boolean bl3 = this.crossedBelow(dataSeries, n2, (Object)Mama$Values.MAMA, (Object)Mama$Values.FAMA);
        dataSeries.setBoolean(n2, (Object)Mama$Signals.SELL, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)Mama$Signals.BUY, Boolean.valueOf(bl2));
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d45);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_MAMA", new Object[]{Util.round((double)d8, (int)2), Util.round((double)d45, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)Mama$Signals.SELL, string, (Object)d8);
        }
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d45);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_MAMA", new Object[]{Util.round((double)d8, (int)2), Util.round((double)d45, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)Mama$Signals.BUY, string, (Object)d8);
        }
        dataSeries.setComplete(n2);
    }
}

