/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.MWDXAverage$Values;

@StudyHeader(namespace="com.motivewave", id="ID_MWDX", rb="com.motivewave.platform.study.nls.strings2", name="NAME_MWDX_AVERAGE", desc="DESC_MWDX", helpLink="http://www.motivewave.com/studies/mwdx_average.htm", label="LBL_MWDX", overlay=true, studyOverlay=true)
public class MWDXAverage
extends Study {
    static final String a = "Fac";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("FACTOR", new Object[0]), 0.2, 0.01, 0.99, 0.01)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_MWDX", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", a, "line"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MWDXAverage$Values.MWDX, this.get("LBL_MWDX", new Object[0]), new String[]{"input", a}));
        runtimeDescriptor.declarePath((Object)MWDXAverage$Values.MWDX, "line");
        runtimeDescriptor.declareIndicator((Object)MWDXAverage$Values.MWDX, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{MWDXAverage$Values.MWDX});
        this.setMinBars(20);
    }

    public void calculate(int n2, DataContext dataContext) {
        if (n2 < 1) {
            return;
        }
        Object object = this.getSettings().getInput("input");
        double d2 = this.getSettings().getDouble(a);
        double d3 = 2.0 / d2 - 1.0;
        double d4 = 2.0 / (d3 + 1.0);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d5 = dataSeries.getDouble(n2, object, 0.0);
        double d6 = dataSeries.getDouble(n2 - 1, (Object)MWDXAverage$Values.MWDX, d5);
        double d7 = d4 * d5 + (1.0 - d4) * d6;
        dataSeries.setDouble(n2, (Object)MWDXAverage$Values.MWDX, Double.valueOf(d7));
        dataSeries.setComplete(n2);
    }
}

