/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.common.h;
import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.PathInfo;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Line;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.LinearRegression$Values;
import java.awt.geom.Point2D;
import java.util.ArrayList;

@StudyHeader(namespace="com.motivewave", id="ID_LIN_REG", rb="com.motivewave.platform.study.nls.strings2", name="NAME_LINEAR_REGRESSION", label="LBL_LGL", desc="DESC_LINEAR_REG", helpLink="http://www.motivewave.com/studies/linear_regression.htm", overlay=true, studyOverlay=true)
public class LinearRegression
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("bar", this.get("REGRESSION_BARS", new Object[0]), 40, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("bars", this.get("FUTURE_BARS", new Object[0]), 1, 0, 10, 1)});
        settingGroup = settingTab.addGroup(this.get("PATH", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PATH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("bar", this.get("REGRESSION_BARS", new Object[0]), 40, 1, 9999, true, () -> Enums.Icon.ARROW_LEFT.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("bars", this.get("FUTURE_BARS", new Object[0]), 1, 1, 9999, true, () -> Enums.Icon.ARROW_RIGHT.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.declarePath((Object)LinearRegression$Values.LINREG, "line");
        runtimeDescriptor.setLabelSettings(new String[]{"input", "bar", "bars"});
        runtimeDescriptor.setRangeKeys(new Object[]{LinearRegression$Values.LINREG});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("bar");
        this.setMinBars(n2);
    }

    protected void calculateValues(DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        this.clearFigures();
        PathInfo pathInfo = this.getSettings().getPath("line");
        if (!pathInfo.isEnabled()) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        int n2 = dataSeries.size();
        int n3 = this.getSettings().getInteger("bar", 40);
        int n4 = n2 - n3;
        int n5 = this.getSettings().getInteger("bars");
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        int n6 = 0;
        for (int i2 = n4; i2 < n2; ++i2) {
            Double d2;
            if (i2 < 0 || (d2 = dataSeries.getDouble(i2, object)) == null) continue;
            arrayList.add(new Point2D.Double(n6, this.round(d2)));
            ++n6;
        }
        double[] dArray = h.a(arrayList);
        double d3 = dArray[0];
        double d4 = dArray[1];
        Line line = new Line(new Coordinate(dataSeries.getStartTime(n4), d4), new Coordinate(dataSeries.getStartTime(n2), d3 * (double)n6 + d4), pathInfo);
        line.setExtendRight(n5);
        this.addFigure((Figure)line);
    }
}

