/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.LaguerreFilter$Values;

@StudyHeader(namespace="com.motivewave", id="ID_LAGF", rb="com.motivewave.platform.study.nls.strings2", label="LBL_LAGF", name="NAME_LAGUERRE_FILTER", desc="DESC_LAGF", menu="MENU_JOHN_EHLERS", helpLink="http://www.motivewave.com/studies/laguerre_filter.htm", signals=false, overlay=true, studyOverlay=true)
public class LaguerreFilter
extends Study {
    static final String a = "Alpha";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.MIDPOINT)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("ALPHA", new Object[0]), 0.2, 0.0, 0.99, 0.01)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_LAGF", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("FIR", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingGroup2 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_LAGF", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("FIR", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", a, "line", "line2"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)LaguerreFilter$Values.FILT, this.get("LBL_LAGF", new Object[0]), new String[]{"input", a}));
        runtimeDescriptor.declarePath((Object)LaguerreFilter$Values.FILT, "line");
        runtimeDescriptor.declarePath((Object)LaguerreFilter$Values.FIR, "line2");
        runtimeDescriptor.declareIndicator((Object)LaguerreFilter$Values.FILT, "ind");
        runtimeDescriptor.declareIndicator((Object)LaguerreFilter$Values.FIR, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{LaguerreFilter$Values.FILT, LaguerreFilter$Values.FIR});
        this.setMinBars(20);
    }

    protected void calculate(int n2, DataContext dataContext) {
        if (n2 <= 3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.MIDPOINT);
        double d2 = this.getSettings().getDouble(a);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d3 = dataSeries.getDouble(n2, object, 0.0);
        double d4 = dataSeries.getDouble(n2 - 1, object, 0.0);
        double d5 = dataSeries.getDouble(n2 - 2, object, 0.0);
        double d6 = dataSeries.getDouble(n2 - 3, object, 0.0);
        double d7 = dataSeries.getDouble(n2 - 1, (Object)LaguerreFilter$Values.L0, d3);
        double d8 = dataSeries.getDouble(n2 - 1, (Object)LaguerreFilter$Values.L1, d3);
        double d9 = dataSeries.getDouble(n2 - 1, (Object)LaguerreFilter$Values.L2, d3);
        double d10 = dataSeries.getDouble(n2 - 1, (Object)LaguerreFilter$Values.L3, d3);
        double d11 = d2 * d3 + (1.0 - d2) * d7;
        double d12 = -(1.0 - d2) * d11 + d7 + (1.0 - d2) * d8;
        double d13 = -(1.0 - d2) * d12 + d8 + (1.0 - d2) * d9;
        double d14 = -(1.0 - d2) * d13 + d9 + (1.0 - d2) * d10;
        double d15 = (d11 + 2.0 * d12 + 2.0 * d13 + d14) / 6.0;
        double d16 = (d3 + 2.0 * d4 + 2.0 * d5 + d6) / 6.0;
        dataSeries.setDouble(n2, (Object)LaguerreFilter$Values.FILT, Double.valueOf(d15));
        dataSeries.setDouble(n2, (Object)LaguerreFilter$Values.FIR, Double.valueOf(d16));
        dataSeries.setDouble(n2, (Object)LaguerreFilter$Values.L0, Double.valueOf(d11));
        dataSeries.setDouble(n2, (Object)LaguerreFilter$Values.L1, Double.valueOf(d12));
        dataSeries.setDouble(n2, (Object)LaguerreFilter$Values.L2, Double.valueOf(d13));
        dataSeries.setDouble(n2, (Object)LaguerreFilter$Values.L3, Double.valueOf(d14));
        dataSeries.setComplete(n2);
    }
}

