/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.j;
import com.motivewave.platform.study.overlay.KirshenbaumBands$Values;

@StudyHeader(namespace="com.motivewave", id="ID_KHBB", rb="com.motivewave.platform.study.nls.strings2", label="LBL_KHBB", name="NAME_KIRSHENBAUM_BANDS", desc="DESC_KHBB", menu="MENU_BANDS", helpLink="http://www.motivewave.com/studies/kirshenbaum_bands.htm", signals=false, overlay=true, studyOverlay=true)
public class KirshenbaumBands
extends Study {
    static final String a = "StdErr";
    static final String b = "Ind3";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("MA_PERIOD", new Object[0]), 30, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("SE_PERIOD", new Object[0]), 20, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("STD_ERROR_FAC", new Object[0]), 1.0, 0.0, 10.01, 0.01)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("TOP", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("MA", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line3", this.get("BOTTOM", new Object[0]), defaults.getGreen(), 1.0f, null, true, false, true)});
        settingGroup2 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("TOP", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("MA", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(b, this.get("BOTTOM", new Object[0]), defaults.getGreen(), null, false, true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("MA_PERIOD", new Object[0]), 30, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("SE_PERIOD", new Object[0]), 20, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{a, "line", "line2", "line3"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "period2", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)KirshenbaumBands$Values.TB, this.get("LBL_KHBB", new Object[0]), new String[]{"input", "method", "period", "period2", a}));
        runtimeDescriptor.declarePath((Object)KirshenbaumBands$Values.TB, "line");
        runtimeDescriptor.declarePath((Object)KirshenbaumBands$Values.MA, "line2");
        runtimeDescriptor.declarePath((Object)KirshenbaumBands$Values.BB, "line3");
        runtimeDescriptor.declareIndicator((Object)KirshenbaumBands$Values.TB, "ind");
        runtimeDescriptor.declareIndicator((Object)KirshenbaumBands$Values.MA, "ind2");
        runtimeDescriptor.declareIndicator((Object)KirshenbaumBands$Values.BB, b);
        runtimeDescriptor.setRangeKeys(new Object[]{KirshenbaumBands$Values.TB, KirshenbaumBands$Values.MA, KirshenbaumBands$Values.BB});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 + n3);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        if (n2 < n3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.EMA);
        double d2 = this.getSettings().getDouble(a);
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d3 = dataSeries.ma(mAMethod, n2, n3, object);
        if (d3 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)KirshenbaumBands$Values.MA, d3);
        if (n2 < n3 + n4) {
            return;
        }
        double d4 = j.c(dataSeries, n2, n4, object);
        double d5 = d3 + d4 * d2;
        dataSeries.setDouble(n2, (Object)KirshenbaumBands$Values.TB, Double.valueOf(d5));
        double d6 = d3 - d4 * d2;
        dataSeries.setDouble(n2, (Object)KirshenbaumBands$Values.BB, Double.valueOf(d6));
        dataSeries.setComplete(n2);
    }
}

