/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.X11Colors;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.KeltnerChannel$Signals;
import com.motivewave.platform.study.overlay.KeltnerChannel$Values;

@StudyHeader(namespace="com.motivewave", id="KELTNER_CHANNEL", rb="com.motivewave.platform.study.nls.strings", name="TITLE_KC", desc="DESC_KC", label="LBL_KC", menu="MENU_OVERLAY", overlay=true, studyOverlay=true, signals=true, helpLink="http://www.motivewave.com/studies/keltner_channel.htm")
public class KeltnerChannel
extends Study {
    static final String a = "middlePeriod";
    static final String b = "atrPeriod";
    static final String c = "upperRange";
    static final String d = "lowerRange";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("LBL_MIDDLE_PERIOD", new Object[0]), 20, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(b, this.get("LBL_ATR_PERIOD", new Object[0]), 10, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(c, this.get("LBL_UPPER_RANGE", new Object[0]), 2.0, 0.1, 999.0, 0.1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(d, this.get("LBL_LOWER_RANGE", new Object[0]), 2.0, 0.1, 999.0, 0.1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), X11Colors.CADET_BLUE, 1.0f, null, true, true, false)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("middleLine", this.get("LBL_MIDDLE_LINE", new Object[0]), X11Colors.DARK_SLATE_GRAY, 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("fill", this.get("LBL_FILL_COLOR", new Object[0]), "line", "line", Enums.ShadeType.BOTH, defaults.getFillColor(), false, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_ADVANCED", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("LBL_MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_CROSS_TOP_BAND", new Object[0]), Enums.MarkerType.LINE_ARROW, Enums.Size.SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_CROSS_BOTTOM_BAND", new Object[0]), Enums.MarkerType.LINE_ARROW, Enums.Size.SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_TOP_BOTTOM_IND", new Object[0]), X11Colors.CADET_BLUE, X11Colors.WHITE, false, false, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new IndicatorDescriptor("middleInd", this.get("LBL_MIDDLE_IND", new Object[0]), X11Colors.DARK_SLATE_GRAY, X11Colors.WHITE, false, false, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(a, this.get("LBL_MIDDLE_PERIOD", new Object[0]), 20, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(b, this.get("LBL_ATR_PERIOD", new Object[0]), 10, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{c, d, "line", "middleLine", "fill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{a, b, c, d});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)KeltnerChannel$Values.TOP, this.get("LBL_KC_TOP", new Object[0]), new String[]{a, b, c}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)KeltnerChannel$Values.MIDDLE, this.get("LBL_KC_MID", new Object[0]), new String[]{a, b}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)KeltnerChannel$Values.BOTTOM, this.get("LBL_KC_BOTTOM", new Object[0]), new String[]{a, b, d}));
        runtimeDescriptor.declarePath((Object)KeltnerChannel$Values.TOP, "line");
        runtimeDescriptor.declarePath((Object)KeltnerChannel$Values.MIDDLE, "middleLine");
        runtimeDescriptor.declarePath((Object)KeltnerChannel$Values.BOTTOM, "line");
        runtimeDescriptor.declareIndicator((Object)KeltnerChannel$Values.TOP, "ind");
        runtimeDescriptor.declareIndicator((Object)KeltnerChannel$Values.MIDDLE, "middleInd");
        runtimeDescriptor.declareIndicator((Object)KeltnerChannel$Values.BOTTOM, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{KeltnerChannel$Values.TOP, KeltnerChannel$Values.BOTTOM});
        runtimeDescriptor.declareSignal((Object)KeltnerChannel$Signals.CROSS_ABOVE_TOP_BAND, this.get("LBL_CROSS_TOP_BAND", new Object[0]));
        runtimeDescriptor.declareSignal((Object)KeltnerChannel$Signals.CROSS_BELOW_BOTTOM_BAND, this.get("LBL_CROSS_BOTTOM_BAND", new Object[0]));
    }

    public int getMinBars() {
        int n2 = this.getSettings().getInteger(a);
        int n3 = this.getSettings().getInteger(b);
        return Math.max(n2, n3) * 2;
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3;
        int n4 = this.getSettings().getInteger(a);
        if (n2 < Math.max(n4, n3 = this.getSettings().getInteger(b).intValue())) {
            return;
        }
        double d2 = this.getSettings().getDouble(c);
        double d3 = this.getSettings().getDouble(d);
        Object object = this.getSettings().getInput("input");
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d4 = dataSeries.ma(Enums.MAMethod.EMA, n2, n4, object);
        Double d5 = dataSeries.atr(n2, n3);
        if (d4 == null || d5 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)KeltnerChannel$Values.MIDDLE, d4);
        dataSeries.setDouble(n2, (Object)KeltnerChannel$Values.TOP, Double.valueOf(d4 + d2 * d5));
        dataSeries.setDouble(n2, (Object)KeltnerChannel$Values.BOTTOM, Double.valueOf(d4 - d3 * d5));
        this.a(dataContext, n2);
        this.b(dataContext, n2);
        dataSeries.setComplete(n2);
    }

    private void a(DataContext dataContext, int n2) {
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.getDouble(n2, (Object)KeltnerChannel$Values.TOP);
        if (d2 == null) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d2.doubleValue());
        if (this.crossedAbove(dataSeries, n2, Enums.BarInput.CLOSE, (Object)KeltnerChannel$Values.TOP) && !dataSeries.getBoolean(n2, (Object)KeltnerChannel$Signals.CROSS_ABOVE_TOP_BAND, false)) {
            dataSeries.setBoolean(n2, (Object)KeltnerChannel$Signals.CROSS_ABOVE_TOP_BAND, Boolean.valueOf(true));
            MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
            String string = this.get("CROSS_ABOVE_TOP_BAND", new Object[]{this.format(dataSeries.getClose(n2)), this.format(d2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)KeltnerChannel$Signals.CROSS_ABOVE_TOP_BAND, string, (Object)this.round(dataSeries.getClose(n2)));
        }
    }

    private void b(DataContext dataContext, int n2) {
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.getDouble(n2, (Object)KeltnerChannel$Values.BOTTOM);
        if (d2 == null) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d2.doubleValue());
        if (this.crossedBelow(dataSeries, n2, Enums.BarInput.CLOSE, (Object)KeltnerChannel$Values.BOTTOM) && !dataSeries.getBoolean(n2, (Object)KeltnerChannel$Signals.CROSS_BELOW_BOTTOM_BAND, false)) {
            dataSeries.setBoolean(n2, (Object)KeltnerChannel$Signals.CROSS_BELOW_BOTTOM_BAND, Boolean.valueOf(true));
            MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
            String string = this.get("CROSS_BELOW_BOTTOM_BAND", new Object[]{this.format(dataSeries.getClose(n2)), this.format(d2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)KeltnerChannel$Signals.CROSS_BELOW_BOTTOM_BAND, string, (Object)this.round(dataSeries.getClose(n2)));
        }
    }
}

