/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.FractalAdaptiveMovingAverage$Values;

@StudyHeader(namespace="com.motivewave", id="ID_FRAMA", rb="com.motivewave.platform.study.nls.strings2", label="LBL_FRAMA", name="NAME_FRACTAL_ADAPTIVE_MOVING_AVERAGE", desc="DESC_FRAMA", menu="MENU_JOHN_EHLERS", helpLink="http://www.motivewave.com/studies/fractal_adaptive_moving_average.htm", signals=false, overlay=true, studyOverlay=true)
public class FractalAdaptiveMovingAverage
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.MIDPOINT)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 16, 1, 9999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_FRAMA", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("MA_PERIOD", new Object[0]), 15, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)FractalAdaptiveMovingAverage$Values.FILT, this.get("LBL_FRAMA", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.declarePath((Object)FractalAdaptiveMovingAverage$Values.FILT, "line");
        runtimeDescriptor.declareIndicator((Object)FractalAdaptiveMovingAverage$Values.FILT, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{FractalAdaptiveMovingAverage$Values.FILT});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        double d2;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.MIDPOINT);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d3 = 0.0;
        double d4 = dataSeries.getDouble(n2, object, 0.0);
        double d5 = dataSeries.getDouble(n2 - 1, (Object)FractalAdaptiveMovingAverage$Values.FILT, d4);
        double d6 = dataSeries.highest(n2, n3, (Object)Enums.BarInput.HIGH);
        double d7 = dataSeries.lowest(n2, n3, Enums.BarInput.LOW);
        double d8 = (d6 - d7) / (double)n3;
        int n4 = n3 / 2;
        d6 = dataSeries.highest(n2, n4, (Object)Enums.BarInput.HIGH);
        d7 = dataSeries.lowest(n2, n4, Enums.BarInput.LOW);
        double d9 = (d6 - d7) / (double)n4;
        d6 = dataSeries.highest(n2 - n4, n4, (Object)Enums.BarInput.HIGH);
        d7 = dataSeries.lowest(n2 - n4, n4, Enums.BarInput.LOW);
        double d10 = (d6 - d7) / (double)n4;
        if (d9 > 0.0 && d10 > 0.0 && d8 > 0.0) {
            d3 = (Math.log(d9 + d10) - Math.log(d8)) / Math.log(2.0);
        }
        if ((d2 = Math.exp(-4.6 * (d3 - 1.0))) < 0.01) {
            d2 = 0.01;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        double d11 = d2 * d4 + (1.0 - d2) * d5;
        dataSeries.setDouble(n2, (Object)FractalAdaptiveMovingAverage$Values.FILT, Double.valueOf(d11));
        dataSeries.setComplete(n2);
    }
}

