/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.FibonacciRetrace$Values;

@StudyHeader(namespace="com.motivewave", id="ID_FBCR", rb="com.motivewave.platform.study.nls.strings2", name="NAME_FIBONACCI_RETRACE", label="LBL_FBCR", desc="DESC_FBCR", helpLink="http://www.motivewave.com/studies/fibonacci_retrace.htm", requiresVolume=false, signals=false, overlay=true, studyOverlay=true)
public class FibonacciRetrace
extends Study {
    static final String a = "Retrace";
    static final String b = "Ind3";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("MA_PERIOD", new Object[0]), 15, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("H_L_PERIOD", new Object[0]), 50, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("RET_FAC", new Object[0]), 0.382, 0.01, 1.0, 0.01)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("MA", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("HIGH_RETRACE", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line3", this.get("LOW_RETRACE", new Object[0]), defaults.getGreen(), 1.0f, null, true, true, true)});
        settingGroup2 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("MA", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("HIGH_RETRACE", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(b, this.get("LOW_RETRACE", new Object[0]), defaults.getGreen(), null, false, true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"method", "input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("MA_PERIOD", new Object[0]), 15, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("H_L_PERIOD", new Object[0]), 50, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{a, "line", "line2", "line3"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"method", "input", "period", "period2", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)FibonacciRetrace$Values.MA, this.get("MA", new Object[0]), new String[]{"method", "input", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)FibonacciRetrace$Values.HRET, this.get("HIGH_RETRACE", new Object[0]), new String[]{"method", "period2", a}));
        runtimeDescriptor.declarePath((Object)FibonacciRetrace$Values.MA, "line");
        runtimeDescriptor.declarePath((Object)FibonacciRetrace$Values.HRET, "line2");
        runtimeDescriptor.declarePath((Object)FibonacciRetrace$Values.LRET, "line3");
        runtimeDescriptor.declareIndicator((Object)FibonacciRetrace$Values.MA, "ind");
        runtimeDescriptor.declareIndicator((Object)FibonacciRetrace$Values.HRET, "ind2");
        runtimeDescriptor.declareIndicator((Object)FibonacciRetrace$Values.LRET, b);
        runtimeDescriptor.setRangeKeys(new Object[]{FibonacciRetrace$Values.MA, FibonacciRetrace$Values.HRET, FibonacciRetrace$Values.LRET});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(Math.max(n2, n3));
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3;
        int n4 = this.getSettings().getInteger("period");
        int n5 = Math.max(n4, n3 = this.getSettings().getInteger("period2").intValue());
        if (n2 < n5) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        double d2 = this.getSettings().getDouble(a);
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d3 = dataSeries.ma(mAMethod, n2, n4, object);
        dataSeries.setDouble(n2, (Object)FibonacciRetrace$Values.MA, d3);
        double d4 = dataSeries.highest(n2, n3, (Object)Enums.BarInput.HIGH);
        double d5 = dataSeries.lowest(n2, n3, Enums.BarInput.LOW);
        double d6 = (d4 - d5) * d2;
        double d7 = d4 - d6;
        dataSeries.setDouble(n2, (Object)FibonacciRetrace$Values.HRET, Double.valueOf(d7));
        double d8 = d5 + d6;
        dataSeries.setDouble(n2, (Object)FibonacciRetrace$Values.LRET, Double.valueOf(d8));
        dataSeries.setComplete(n2);
    }
}

