/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.ElderRayIndex$Signals;
import com.motivewave.platform.study.overlay.ElderRayIndex$Values;

@StudyHeader(namespace="com.motivewave", id="ID_ERINDEX", rb="com.motivewave.platform.study.nls.strings2", label="LBL_ERINDEX", name="NAME_ELDER_RAY_INDEX", desc="DESC_ERINDEX", menu="MENU_ALEXANDER_ELDER", helpLink="http://www.motivewave.com/studies/elder_ray_index.htm", signals=true, overlay=true, studyOverlay=true)
public class ElderRayIndex
extends Study {
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 13, 1, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PATH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -9.1, 9.1, 0.01, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD", new Object[0]), 13, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ElderRayIndex$Values.MA, this.get("LBL_EREMA", new Object[0]), new String[]{"input", "method", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ElderRayIndex$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ElderRayIndex$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declareSignal((Object)ElderRayIndex$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)ElderRayIndex$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)ElderRayIndex$Values.MA, "line");
        runtimeDescriptor.declareIndicator((Object)ElderRayIndex$Values.MA, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{ElderRayIndex$Values.MA});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.ma(mAMethod, n2, n3, object);
        if (d2 == null) {
            return;
        }
        double d3 = dataSeries.getDouble(n2, (Object)Enums.BarInput.LOW, 0.0);
        double d4 = dataSeries.getDouble(n2, (Object)Enums.BarInput.HIGH, 0.0);
        double d5 = d4 - d2;
        double d6 = d3 - d2;
        dataSeries.setDouble(n2, (Object)ElderRayIndex$Values.BULL, Double.valueOf(d5));
        dataSeries.setDouble(n2, (Object)ElderRayIndex$Values.BEAR, Double.valueOf(d6));
        dataSeries.setDouble(n2, (Object)ElderRayIndex$Values.MA, d2);
        dataSeries.setComplete(n2);
        if (n2 < n3 + 1) {
            return;
        }
        GuideInfo guideInfo = this.getSettings().getGuide("middleGuide");
        double d7 = guideInfo.getValue();
        double d8 = dataSeries.getDouble(n2 - 1, (Object)ElderRayIndex$Values.BEAR, d6);
        double d9 = dataSeries.getDouble(n2 - 1, (Object)ElderRayIndex$Values.BULL, d5);
        double d10 = dataSeries.getDouble(n2 - 1, (Object)ElderRayIndex$Values.MA, d2.doubleValue());
        boolean bl2 = d5 > d7 && d5 < d9 && d5 > this.a && d2 < d10;
        boolean bl3 = d6 < d7 && d6 > d8 && d6 < this.b && d2 > d10;
        dataSeries.setBoolean(n2, (Object)ElderRayIndex$Signals.BUY, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)ElderRayIndex$Signals.SELL, Boolean.valueOf(bl2));
        if (bl2) {
            this.a = d5;
            this.b = Double.MAX_VALUE;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d4);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_HIGH_BULL", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d5, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)ElderRayIndex$Signals.SELL, string, (Object)d4);
        }
        if (bl3) {
            this.b = d6;
            this.a = Double.NEGATIVE_INFINITY;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d3);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_LOW_BEAR", new Object[]{Util.round((double)d3, (int)2), Util.round((double)d6, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)ElderRayIndex$Signals.BUY, string, (Object)d3);
        }
    }
}

