/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.EhlersFilterDistCoff$Values;

@StudyHeader(namespace="com.motivewave", id="ID_EHLFDC", rb="com.motivewave.platform.study.nls.strings2", label="LBL_EHLFDC", name="NAME_EHLERS_FILTER_DISTANCE_COEFF", desc="DESC_EHLFDC", menu="MENU_JOHN_EHLERS", helpLink="http://www.motivewave.com/studies/ehlers_filter_distance_coeff.htm", signals=false, overlay=true, studyOverlay=true)
public class EhlersFilterDistCoff
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 20, 1, 9999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_EHLFDC", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD", new Object[0]), 20, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)EhlersFilterDistCoff$Values.FILT, this.get("LBL_EHLFDC", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.declarePath((Object)EhlersFilterDistCoff$Values.FILT, "line");
        runtimeDescriptor.declareIndicator((Object)EhlersFilterDistCoff$Values.FILT, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{EhlersFilterDistCoff$Values.FILT});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 * 2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3;
        int n4 = this.getSettings().getInteger("period");
        if (n2 < n4 * 2) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        int n5 = 0;
        for (n3 = n2 - (n4 - 1); n3 <= n2; ++n3) {
            dArray2[n5] = 0.0;
            d2 = dataSeries.getDouble(n3, object, 0.0);
            for (int i2 = 1; i2 < n4; ++i2) {
                d3 = dataSeries.getDouble(n3 - i2, object, 0.0);
                dArray2[n5] = dArray2[n5] + (d2 - d3) * (d2 - d3);
            }
            dArray[n5] = dArray2[n5];
            ++n5;
        }
        n5 = 0;
        for (n3 = n2 - (n4 - 1); n3 <= n2; ++n3) {
            d2 = dataSeries.getDouble(n3, object, 0.0);
            d4 += dArray[n5] * d2;
            d5 += dArray[n5];
            ++n5;
        }
        if (d5 != 0.0) {
            d6 = d4 / d5;
        }
        dataSeries.setDouble(n2, (Object)EhlersFilterDistCoff$Values.FILT, Double.valueOf(d6));
        dataSeries.setComplete(n2);
    }
}

