/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.DisplacedMovingAverage$Signals;
import com.motivewave.platform.study.overlay.DisplacedMovingAverage$Values;

@StudyHeader(namespace="com.motivewave", id="ID_DMA", rb="com.motivewave.platform.study.nls.strings2", name="NAME_DISPLACED_MOVING_AVERAGES", label="LBL_DMA", desc="DESC_DMA", menu="MENU_MOVING_AVERAGE", helpLink="http://www.motivewave.com/studies/displaced_moving_averages.htm", requiresVolume=false, signals=true, overlay=true, studyOverlay=true)
public class DisplacedMovingAverage
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("MA_PERIOD", new Object[0]), 9, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("DISPLACEMENT", new Object[0]), 5, -999, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("DMA", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("MA", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        settingGroup2 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("DMA", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("MA", new Object[0]), defaults.getRed(), null, false, true, true)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("MA_PERIOD", new Object[0]), 9, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("DISPLACEMENT", new Object[0]), 5, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "line2"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"method", "period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DisplacedMovingAverage$Values.DMA, this.get("DMA", new Object[0]), new String[]{"method", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DisplacedMovingAverage$Values.MA, this.get("MA", new Object[0]), new String[]{"method", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DisplacedMovingAverage$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DisplacedMovingAverage$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declarePath((Object)DisplacedMovingAverage$Values.DMA, "line");
        runtimeDescriptor.declarePath((Object)DisplacedMovingAverage$Values.MA, "line2");
        runtimeDescriptor.declareIndicator((Object)DisplacedMovingAverage$Values.DMA, "ind");
        runtimeDescriptor.declareIndicator((Object)DisplacedMovingAverage$Values.MA, "ind2");
        runtimeDescriptor.declareSignal((Object)DisplacedMovingAverage$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)DisplacedMovingAverage$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{DisplacedMovingAverage$Values.DMA, DisplacedMovingAverage$Values.MA});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 + n3);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3;
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        int n4 = this.getSettings().getInteger("period");
        if (n2 < n4 + (n3 = this.getSettings().getInteger("period2").intValue())) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        Double d3 = dataSeries.ma(mAMethod, n2, n4, object);
        Double d4 = dataSeries.ma(mAMethod, n2 - n3, n4, object);
        dataSeries.setDouble(n2, (Object)DisplacedMovingAverage$Values.MA, d3);
        dataSeries.setDouble(n2, (Object)DisplacedMovingAverage$Values.DMA, d4);
        boolean bl2 = this.crossedAbove(dataSeries, n2, (Object)DisplacedMovingAverage$Values.DMA, (Object)DisplacedMovingAverage$Values.MA);
        boolean bl3 = this.crossedBelow(dataSeries, n2, (Object)DisplacedMovingAverage$Values.DMA, (Object)DisplacedMovingAverage$Values.MA);
        dataSeries.setBoolean(n2, (Object)DisplacedMovingAverage$Signals.SELL, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)DisplacedMovingAverage$Signals.BUY, Boolean.valueOf(bl2));
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d4.doubleValue());
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_DMA", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d4, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)DisplacedMovingAverage$Signals.SELL, string, (Object)d2);
        }
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d4.doubleValue());
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_DMA", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d4, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)DisplacedMovingAverage$Signals.BUY, string, (Object)d2);
        }
        dataSeries.setComplete(n2);
    }
}

