/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.DEMA2Lines$Signals;
import com.motivewave.platform.study.overlay.DEMA2Lines$Values;

@StudyHeader(namespace="com.motivewave", id="ID_DEMA", rb="com.motivewave.platform.study.nls.strings2", name="NAME_DEMA_2LINES", label="LBL_DEMA", desc="DESC_DEMA", menu="MENU_BILL_MARS", helpLink="http://www.motivewave.com/studies/dema_2lines.htm", requiresVolume=false, signals=true, overlay=true, studyOverlay=true)
public class DEMA2Lines
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD1", new Object[0]), 10, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("PERIOD2", new Object[0]), 40, 1, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("DEMA1", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("DEMA2", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        settingGroup2 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("DEMA1", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("DEMA2", new Object[0]), defaults.getRed(), null, false, true, true)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD1", new Object[0]), 10, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("PERIOD2", new Object[0]), 40, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "line2"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"method", "period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DEMA2Lines$Values.DEMA1, this.get("DEMA1", new Object[0]), new String[]{"method", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DEMA2Lines$Values.DEMA2, this.get("DEMA2", new Object[0]), new String[]{"method", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DEMA2Lines$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DEMA2Lines$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declareSignal((Object)DEMA2Lines$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)DEMA2Lines$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)DEMA2Lines$Values.DEMA1, "line");
        runtimeDescriptor.declarePath((Object)DEMA2Lines$Values.DEMA2, "line2");
        runtimeDescriptor.declareIndicator((Object)DEMA2Lines$Values.DEMA1, "ind");
        runtimeDescriptor.declareIndicator((Object)DEMA2Lines$Values.DEMA2, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{DEMA2Lines$Values.DEMA1, DEMA2Lines$Values.DEMA2});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(Math.max(n2, n3) * 2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        int n5 = Math.max(n3, n4);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getHigh(n2);
        double d3 = dataSeries.getLow(n2);
        double d4 = (d2 + d3) / 2.0;
        dataSeries.setDouble(n2, (Object)DEMA2Lines$Values.PRICE, Double.valueOf(d4));
        if (n2 < n5) {
            return;
        }
        Double d5 = dataSeries.ma(mAMethod, n2, n3, (Object)DEMA2Lines$Values.PRICE);
        Double d6 = dataSeries.ma(mAMethod, n2, n4, (Object)DEMA2Lines$Values.PRICE);
        dataSeries.setDouble(n2, (Object)DEMA2Lines$Values.EMA1, d5);
        dataSeries.setDouble(n2, (Object)DEMA2Lines$Values.EMA2, d6);
        if (n2 < n5 * 2) {
            return;
        }
        Double d7 = dataSeries.ma(mAMethod, n2, n3, (Object)DEMA2Lines$Values.EMA1);
        Double d8 = dataSeries.ma(mAMethod, n2, n4, (Object)DEMA2Lines$Values.EMA2);
        dataSeries.setDouble(n2, (Object)DEMA2Lines$Values.DEMA1, d7);
        dataSeries.setDouble(n2, (Object)DEMA2Lines$Values.DEMA2, d8);
        boolean bl2 = this.crossedAbove(dataSeries, n2, (Object)DEMA2Lines$Values.DEMA1, (Object)DEMA2Lines$Values.DEMA2);
        boolean bl3 = this.crossedBelow(dataSeries, n2, (Object)DEMA2Lines$Values.DEMA1, (Object)DEMA2Lines$Values.DEMA2);
        dataSeries.setBoolean(n2, (Object)DEMA2Lines$Signals.SELL, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)DEMA2Lines$Signals.BUY, Boolean.valueOf(bl2));
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d7.doubleValue());
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_HIGH_DEMA1", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d7, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)DEMA2Lines$Signals.SELL, string, (Object)d2);
        }
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d7.doubleValue());
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_LOW_DEMA1", new Object[]{Util.round((double)d3, (int)2), Util.round((double)d7, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)DEMA2Lines$Signals.BUY, string, (Object)d3);
        }
        dataSeries.setComplete(n2);
    }
}

