/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.X11Colors;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.BollingerBandsFib$Values;

@StudyHeader(namespace="com.motivewave", id="BB_FIB", rb="com.motivewave.platform.study.nls.strings", name="TITLE_BB_FIB", desc="DESC_BB_FIB", label="LBL_BB_FIB", menu="MENU_OVERLAY", overlay=true, studyOverlay=true, helpLink="http://www.motivewave.com/studies/bollinger_bands_fib_ratios.htm")
public class BollingerBandsFib
extends Study {
    static final String a = "fibRatio1";
    static final String b = "fibRatio2";
    static final String c = "fibRatio3";
    static final String d = "fibLine1";
    static final String e = "fibLine2";
    static final String f = "fibLine3";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 20, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("LBL_FIB_RATIO_1", new Object[0]), 1.618, 0.1, 99.0, 0.001)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(b, this.get("LBL_FIB_RATIO_2", new Object[0]), 2.618, 0.1, 99.0, 0.001)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(c, this.get("LBL_FIB_RATIO_3", new Object[0]), 4.236, 0.1, 99.0, 0.001)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_LINES", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("middleLine", this.get("LBL_MIDDLE_LINE", new Object[0]), X11Colors.DARK_SLATE_GRAY, 1.0f, new float[]{3.0f, 3.0f}, true, true, false)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(d, this.get("LBL_FIB_LINE_1", new Object[0]), X11Colors.CADET_BLUE, 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(e, this.get("LBL_FIB_LINE_2", new Object[0]), X11Colors.DARK_SLATE_GRAY, 1.0f, new float[]{3.0f, 3.0f}, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(f, this.get("LBL_FIB_LINE_3", new Object[0]), defaults.getGreen(), 1.0f, new float[]{3.0f, 3.0f}, true, true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 20, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{a, b, c, "middleLine", d, e, f});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", a, b, c});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)BollingerBandsFib$Values.MIDDLE, this.get("LBL_BB_FIB_MID", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)BollingerBandsFib$Values.FIB_TOP_1, this.get("LBL_BB_FIB_TOP_1", new Object[0]), new String[]{"input", "period", a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)BollingerBandsFib$Values.FIB_BOTTOM_1, this.get("LBL_BB_FIB_BOTTOM_1", new Object[0]), new String[]{"input", "period", a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)BollingerBandsFib$Values.FIB_TOP_2, this.get("LBL_BB_FIB_TOP_2", new Object[0]), new String[]{"input", "period", b}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)BollingerBandsFib$Values.FIB_BOTTOM_2, this.get("LBL_BB_FIB_BOTTOM_2", new Object[0]), new String[]{"input", "period", b}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)BollingerBandsFib$Values.FIB_TOP_3, this.get("LBL_BB_FIB_TOP_3", new Object[0]), new String[]{"input", "period", c}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)BollingerBandsFib$Values.FIB_BOTTOM_3, this.get("LBL_BB_FIB_BOTTOM_3", new Object[0]), new String[]{"input", "period", c}));
        runtimeDescriptor.declarePath((Object)BollingerBandsFib$Values.MIDDLE, "middleLine");
        runtimeDescriptor.declarePath((Object)BollingerBandsFib$Values.FIB_TOP_1, d);
        runtimeDescriptor.declarePath((Object)BollingerBandsFib$Values.FIB_TOP_2, e);
        runtimeDescriptor.declarePath((Object)BollingerBandsFib$Values.FIB_TOP_3, f);
        runtimeDescriptor.declarePath((Object)BollingerBandsFib$Values.FIB_BOTTOM_1, d);
        runtimeDescriptor.declarePath((Object)BollingerBandsFib$Values.FIB_BOTTOM_2, e);
        runtimeDescriptor.declarePath((Object)BollingerBandsFib$Values.FIB_BOTTOM_3, f);
        runtimeDescriptor.setRangeKeys(new Object[]{BollingerBandsFib$Values.FIB_TOP_3, BollingerBandsFib$Values.FIB_BOTTOM_3});
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period", 20);
        DataSeries dataSeries = dataContext.getDataSeries();
        dataSeries.setFloat(n2, (Object)BollingerBandsFib$Values.TR, dataSeries.getTrueRange(n2));
        if (n2 < n3) {
            return;
        }
        Object object = this.getSettings().getInput("input");
        double d2 = this.getSettings().getDouble(a, 1.618);
        double d3 = this.getSettings().getDouble(b, 2.618);
        double d4 = this.getSettings().getDouble(c, 4.236);
        Double d5 = dataSeries.smma(n2, n3, (Object)BollingerBandsFib$Values.TR);
        Double d6 = dataSeries.sma(n2, n3, object);
        if (d5 == null || d6 == null) {
            return;
        }
        double d7 = d5 * d2;
        double d8 = d5 * d3;
        double d9 = d5 * d4;
        dataSeries.setDouble(n2, (Object)BollingerBandsFib$Values.FIB_TOP_3, Double.valueOf(d6 + d9));
        dataSeries.setDouble(n2, (Object)BollingerBandsFib$Values.FIB_TOP_2, Double.valueOf(d6 + d8));
        dataSeries.setDouble(n2, (Object)BollingerBandsFib$Values.FIB_TOP_1, Double.valueOf(d6 + d7));
        dataSeries.setDouble(n2, (Object)BollingerBandsFib$Values.MIDDLE, d6);
        dataSeries.setDouble(n2, (Object)BollingerBandsFib$Values.FIB_BOTTOM_1, Double.valueOf(d6 - d7));
        dataSeries.setDouble(n2, (Object)BollingerBandsFib$Values.FIB_BOTTOM_2, Double.valueOf(d6 - d8));
        dataSeries.setDouble(n2, (Object)BollingerBandsFib$Values.FIB_BOTTOM_3, Double.valueOf(d6 - d9));
        dataSeries.setComplete(n2);
    }
}

