/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.X11Colors;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.BollingerBands$Signals;
import com.motivewave.platform.study.overlay.BollingerBands$Values;

@StudyHeader(namespace="com.motivewave", id="BOLLINGER_BANDS", rb="com.motivewave.platform.study.nls.strings", name="TITLE_BB", menu="MENU_OVERLAY", desc="DESC_BB", label="LBL_BB", overlay=true, studyOverlay=true, signals=true, helpLink="http://www.motivewave.com/studies/bollinger_bands.htm")
public class BollingerBands
extends Study {
    static final String a = "topPeriod";
    static final String b = "topShift";
    static final String c = "bottomPeriod";
    static final String d = "bottomShift";
    static final String e = "topStd";
    static final String f = "bottomStd";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("LBL_TOP_PERIOD", new Object[0]), 20, 1, 9999, 1), new IntegerDescriptor(b, this.get("LBL_SHIFT", new Object[0]), 0, -999, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(c, this.get("LBL_BOTTOM_PERIOD", new Object[0]), 20, 1, 9999, 1), new IntegerDescriptor(d, this.get("LBL_SHIFT", new Object[0]), 0, -999, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(e, this.get("LBL_TOP_STD", new Object[0]), 2.0, 0.1, 999.0, 0.1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(f, this.get("LBL_BOTTOM_STD", new Object[0]), 2.0, 0.1, 999.0, 0.1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_BAND_LINES", new Object[0]), X11Colors.CADET_BLUE, 1.0f, null, true, true, false)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("middleLine", this.get("LBL_MIDDLE_LINE", new Object[0]), X11Colors.DARK_SLATE_GRAY, 1.0f, new float[]{3.0f, 3.0f}, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("fill", this.get("LBL_FILL_COLOR", new Object[0]), "line", "line", Enums.ShadeType.BOTH, defaults.getFillColor(), false, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_ADVANCED", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("LBL_MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_CROSS_TOP_BAND", new Object[0]), Enums.MarkerType.LINE_ARROW, Enums.Size.SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_CROSS_BOTTOM_BAND", new Object[0]), Enums.MarkerType.LINE_ARROW, Enums.Size.SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_TOP_BOTTOM_IND", new Object[0]), X11Colors.CADET_BLUE, X11Colors.WHITE, false, false, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new IndicatorDescriptor("middleInd", this.get("LBL_MIDDLE_IND", new Object[0]), X11Colors.DARK_SLATE_GRAY, X11Colors.WHITE, false, false, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(a, this.get("LBL_TOP_PERIOD", new Object[0]), 20, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(b, this.get("LBL_SHIFT", new Object[0]), 0, -999, 999, true, () -> Enums.Icon.SHIFT.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(c, this.get("LBL_BOTTOM_PERIOD", new Object[0]), 20, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(d, this.get("LBL_SHIFT", new Object[0]), 0, -999, 999, true, () -> Enums.Icon.SHIFT.get())});
        settingsDescriptor.addQuickSettings(new String[]{e, f, "line", "middleLine", "fill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{a, c, e, f});
        runtimeDescriptor.setIDSettings(new String[]{a, c, e, f, b, d, "input", "method", "line", "fill", "middleLine"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)BollingerBands$Values.TOP, this.get("LBL_BB_TOP", new Object[0]), new String[]{"input", a, e, b}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)BollingerBands$Values.MIDDLE, this.get("LBL_BB_MID", new Object[0]), new String[]{"input", a, e, b}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)BollingerBands$Values.BOTTOM, this.get("LBL_BB_BOTTOM", new Object[0]), new String[]{"input", c, f, d}));
        runtimeDescriptor.declarePath((Object)BollingerBands$Values.TOP, "line");
        runtimeDescriptor.declarePath((Object)BollingerBands$Values.MIDDLE, "middleLine");
        runtimeDescriptor.declarePath((Object)BollingerBands$Values.BOTTOM, "line");
        runtimeDescriptor.declareIndicator((Object)BollingerBands$Values.TOP, "ind");
        runtimeDescriptor.declareIndicator((Object)BollingerBands$Values.MIDDLE, "middleInd");
        runtimeDescriptor.declareIndicator((Object)BollingerBands$Values.BOTTOM, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{BollingerBands$Values.TOP, BollingerBands$Values.BOTTOM});
        runtimeDescriptor.declareSignal((Object)BollingerBands$Signals.CROSS_ABOVE_TOP_BAND, this.get("LBL_CROSS_TOP_BAND", new Object[0]));
        runtimeDescriptor.declareSignal((Object)BollingerBands$Signals.CROSS_BELOW_BOTTOM_BAND, this.get("LBL_CROSS_BOTTOM_BAND", new Object[0]));
    }

    public int getMinBars() {
        int n2 = Util.maxInt((int[])new int[]{this.getSettings().getInteger(b), this.getSettings().getInteger(d)});
        return Util.maxInt((int[])new int[]{this.getSettings().getInteger(a), this.getSettings().getInteger(c)}) + (n2 > 0 ? n2 : 0);
    }

    public void onBarUpdate(DataContext dataContext) {
        if (!this.getSettings().isBarUpdates()) {
            return;
        }
        this.a(dataContext);
    }

    public void onBarClose(DataContext dataContext) {
        this.a(dataContext);
    }

    private void a(DataContext dataContext) {
        int n2 = this.getSettings().getInteger(a);
        int n3 = this.getSettings().getInteger(c);
        int n4 = this.getSettings().getInteger(b);
        int n5 = this.getSettings().getInteger(d);
        double d2 = this.getSettings().getDouble(e);
        double d3 = this.getSettings().getDouble(f);
        Object object = this.getSettings().getInput("input");
        DataSeries dataSeries = dataContext.getDataSeries();
        int n6 = dataSeries.size() - 1;
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.SMA);
        Double d4 = dataSeries.std(n6, n2, object);
        Double d5 = dataSeries.std(n6, n3, object);
        Double d6 = dataSeries.ma(mAMethod, n6, n2, object);
        Double d7 = dataSeries.ma(mAMethod, n6, n3, object);
        if (d4 == null || d5 == null || d6 == null || d7 == null) {
            return;
        }
        dataSeries.setDouble(n6 + n4, (Object)BollingerBands$Values.MIDDLE, d6);
        dataSeries.setDouble(n6 + n4, (Object)BollingerBands$Values.TOP, Double.valueOf(d6 + d4 * d2));
        dataSeries.setDouble(n6 + n5, (Object)BollingerBands$Values.BOTTOM, Double.valueOf(d7 - d5 * d3));
        this.a(dataContext, n6);
        this.b(dataContext, n6);
    }

    private void a(DataContext dataContext, int n2) {
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.getDouble(n2, (Object)BollingerBands$Values.TOP);
        if (d2 == null) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d2.doubleValue());
        if (this.crossedAbove(dataSeries, n2, Enums.BarInput.CLOSE, (Object)BollingerBands$Values.TOP) && !dataSeries.getBoolean(n2, (Object)BollingerBands$Signals.CROSS_ABOVE_TOP_BAND, false)) {
            dataSeries.setBoolean(n2, (Object)BollingerBands$Signals.CROSS_ABOVE_TOP_BAND, Boolean.valueOf(true));
            MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
            String string = this.get("CROSS_ABOVE_TOP_BAND", new Object[]{this.format(dataSeries.getClose(n2)), this.format(d2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)BollingerBands$Signals.CROSS_ABOVE_TOP_BAND, string, (Object)this.round(dataSeries.getClose(n2)));
        }
    }

    private void b(DataContext dataContext, int n2) {
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.getDouble(n2, (Object)BollingerBands$Values.BOTTOM);
        if (d2 == null) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d2.doubleValue());
        if (this.crossedBelow(dataSeries, n2, Enums.BarInput.CLOSE, (Object)BollingerBands$Values.BOTTOM) && !dataSeries.getBoolean(n2, (Object)BollingerBands$Signals.CROSS_BELOW_BOTTOM_BAND, false)) {
            dataSeries.setBoolean(n2, (Object)BollingerBands$Signals.CROSS_BELOW_BOTTOM_BAND, Boolean.valueOf(true));
            MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
            String string = this.get("CROSS_BELOW_BOTTOM_BAND", new Object[]{this.format(dataSeries.getClose(n2)), this.format(d2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)BollingerBands$Signals.CROSS_BELOW_BOTTOM_BAND, string, (Object)this.round(dataSeries.getClose(n2)));
        }
    }

    protected synchronized void calculateValues(DataContext dataContext) {
        Double d2;
        Double d3;
        int n2;
        int n3 = this.getSettings().getInteger(a);
        int n4 = this.getSettings().getInteger(c);
        int n5 = this.getSettings().getInteger(b);
        int n6 = this.getSettings().getInteger(d);
        double d4 = this.getSettings().getDouble(e);
        double d5 = this.getSettings().getDouble(f);
        Object object = this.getSettings().getInput("input");
        DataSeries dataSeries = dataContext.getDataSeries();
        int n7 = dataSeries.size() - 1;
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.SMA);
        int n8 = n7;
        if (n5 < 0) {
            n8 -= n5;
        }
        boolean bl2 = this.getSettings().isBarUpdates();
        for (n2 = n3; n2 <= n8; ++n2) {
            if (dataSeries.isComplete(n2, (Object)BollingerBands$Values.TOP) || !bl2 && !dataSeries.isBarComplete(n2)) continue;
            d3 = dataSeries.std(n2, n3, object);
            d2 = dataSeries.ma(mAMethod, n2, n3, object);
            if (d3 == null || d2 == null) continue;
            dataSeries.setDouble(n2 + n5, (Object)BollingerBands$Values.MIDDLE, d2);
            dataSeries.setDouble(n2 + n5, (Object)BollingerBands$Values.TOP, Double.valueOf(d2 + d3 * d4));
            dataSeries.setComplete(n2, (Object)BollingerBands$Values.TOP, n2 >= 0 && n2 < n7);
            this.a(dataContext, n2);
        }
        n8 = n7;
        if (n6 < 0) {
            n8 -= n6;
        }
        for (n2 = n4; n2 <= n8; ++n2) {
            if (dataSeries.isComplete(n2, (Object)BollingerBands$Values.BOTTOM) || !bl2 && !dataSeries.isBarComplete(n2)) continue;
            d3 = dataSeries.std(n2, n4, object);
            d2 = dataSeries.ma(mAMethod, n2, n4, object);
            if (d3 == null || d2 == null) continue;
            dataSeries.setDouble(n2 + n6, (Object)BollingerBands$Values.BOTTOM, Double.valueOf(d2 - d3 * d5));
            dataSeries.setComplete(n2, (Object)BollingerBands$Values.BOTTOM, n2 >= 0 && n2 < n7);
            this.b(dataContext, n2);
        }
    }
}

