/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.FontInfo;
import com.motivewave.platform.sdk.common.PathInfo;
import com.motivewave.platform.sdk.common.Settings;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.X11Colors;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.FontDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Label;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.AtrTrailingStop$Signals;
import com.motivewave.platform.study.overlay.AtrTrailingStop$Values;
import java.awt.Color;
import java.awt.Font;

@StudyHeader(namespace="com.motivewave", id="ID_ATRTS", rb="com.motivewave.platform.study.nls.strings2", label="LBL_ATRTS", name="NAME_ATR_TRAILING_STOPS", desc="DESC_ATRTS", helpLink="http://www.motivewave.com/studies/atr_trailing_stops.htm", signals=true, overlay=true, studyOverlay=true)
public class AtrTrailingStop
extends Study {
    static final String[] a = new String[]{"Long", "Short"};

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup("");
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input2", this.get("POSITION", new Object[0]), (Object[])a, (Object)a[0])});
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("MA_PERIOD", new Object[0]), 63, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("ATR_PERIOD", new Object[0]), 21, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor("fac", this.get("FACTOR", new Object[0]), 3.0, 2.0, 4.1, 0.1)});
        settingGroup.addRow(new SettingDescriptor[]{new FontDescriptor("font", this.get("FONT", new Object[0]), defaults.getFont())});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor("showEntries", this.get("SHOW_ENTRIES", new Object[0]), Boolean.valueOf(false), false)});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor("showLabels", this.get("LBL_SHOW_LABELS", new Object[0]), Boolean.valueOf(true), false)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATHS", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor("path1", this.get("LONG", new Object[0]), defaults.getBlue(), Enums.PointType.DOT, Enums.Size.SMALL, true, true, false);
        pathDescriptor.setSupportsMaxPoints(true);
        pathDescriptor.setSupportsColorPolicy(false);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        pathDescriptor = new PathDescriptor("path2", this.get("SHORT", new Object[0]), defaults.getPurple(), Enums.PointType.DOT, Enums.Size.SMALL, true, true, false);
        pathDescriptor.setSupportsMaxPoints(true);
        pathDescriptor.setSupportsColorPolicy(false);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("MA", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingGroup2 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_ATRTS", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("MA", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "input2", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("MA_PERIOD", new Object[0]), 63, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("ATR_PERIOD", new Object[0]), 21, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"fac", "path1", "path2", "line2", "showEntries", "showLabels"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input2", "input", "method", "period", "period2", "fac"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)AtrTrailingStop$Values.MA, this.get("LBL_CHEXITS", new Object[0]), new String[]{"input2", "input", "method", "period", "period2", "fac"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)AtrTrailingStop$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)AtrTrailingStop$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declareSignal((Object)AtrTrailingStop$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)AtrTrailingStop$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)AtrTrailingStop$Values.ATRTS, "path1");
        runtimeDescriptor.declarePath((Object)AtrTrailingStop$Values.MA, "line2");
        runtimeDescriptor.declareIndicator((Object)AtrTrailingStop$Values.ATRTS, "ind");
        runtimeDescriptor.declareIndicator((Object)AtrTrailingStop$Values.MA, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{AtrTrailingStop$Values.ATRTS, AtrTrailingStop$Values.MA});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(Math.max(n2, n3));
    }

    protected void calculate(int n2, DataContext dataContext) {
        Label label;
        Coordinate coordinate;
        boolean bl2;
        int n3;
        Settings settings = this.getSettings();
        int n4 = settings.getInteger("period");
        if (n2 < Math.max(n4, n3 = settings.getInteger("period2").intValue())) {
            return;
        }
        String string = (String)settings.getInput("input2", (Object)a[0]);
        Object object = settings.getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = settings.getMAMethod("method");
        double d2 = settings.getDouble("fac", 0.0);
        FontInfo fontInfo = settings.getFont("font");
        Font font = fontInfo.getFont();
        boolean bl3 = settings.is("showEntries");
        PathInfo pathInfo = settings.getPath("path1");
        PathInfo pathInfo2 = settings.getPath("path2");
        boolean bl4 = string == "Long";
        boolean bl5 = bl2 = string == "Short";
        if (bl4) {
            settings.setPath("line", pathInfo);
        }
        if (bl2) {
            settings.setPath("line", pathInfo2);
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        double d3 = 0.0;
        double d4 = 0.0;
        Double d5 = dataSeries.ma(mAMethod, n2, n4, object);
        dataSeries.setDouble(n2, (Object)AtrTrailingStop$Values.MA, d5);
        double d6 = dataSeries.getDouble(n2, object, 0.0);
        double d7 = dataSeries.getDouble(n2 - 1, object, 0.0);
        double d8 = dataSeries.getDouble(n2, (Object)AtrTrailingStop$Values.ATRTS, d6);
        boolean bl6 = d6 > d5;
        boolean bl7 = d6 <= d5;
        d4 = dataSeries.atr(n2, n3);
        if (bl6 && (d3 = d6 - d2 * d4) < d8) {
            d3 = d8;
        }
        if (bl7 && (d3 = d6 + d2 * d4) > d8) {
            d3 = d8;
        }
        if (d3 != 0.0) {
            dataSeries.setDouble(n2 + 1, (Object)AtrTrailingStop$Values.ATRTS, Double.valueOf(d3));
        }
        dataSeries.setComplete(n2);
        Defaults defaults = dataContext.getDefaults();
        double d9 = dataSeries.getHigh(n2);
        double d10 = dataSeries.getLow(n2);
        boolean bl8 = false;
        boolean bl9 = false;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (d3 != 0.0) {
            if (bl4 && bl6) {
                bl8 = d6 < d3;
                bl9 = d7 < d3 && d6 > d3 && bl3;
                string4 = "ENTER_BUY";
                string5 = "BUY_PRICE_ATRTS";
                string2 = "EXIT_SELL";
                string3 = "EXIT_SELL_PRICE_SAFEZONE";
            }
            if (bl2 && bl7) {
                bl8 = d7 > d3 && d6 < d3 && bl3;
                bl9 = d6 > d3;
                string2 = "SELL_SHORT";
                string3 = "SELL_SHORT_PRICE_ATRTS";
                string4 = "EXIT_BUY";
                string5 = "EXIT_BUY_PRICE_ATRTS";
            }
        }
        dataSeries.setBoolean(n2, (Object)AtrTrailingStop$Signals.BUY, Boolean.valueOf(bl9));
        dataSeries.setBoolean(n2, (Object)AtrTrailingStop$Signals.SELL, Boolean.valueOf(bl8));
        boolean bl10 = settings.is("showLabels", true);
        if (bl8) {
            if (bl10) {
                coordinate = new Coordinate(dataSeries.getStartTime(n2 + 1), d9);
                label = new Label(this.get(string2, new Object[0]), font, this.a(defaults.getRed()), defaults.getRed());
                label.setLocation(coordinate);
                this.addFigure((Figure)label);
            }
            dataContext.signal(n2, (Object)AtrTrailingStop$Signals.SELL, this.get(string3, new Object[]{Util.round((double)d9, (int)2), Util.round((double)d3, (int)3)}), (Object)d9);
        }
        if (bl9) {
            if (bl10) {
                coordinate = new Coordinate(dataSeries.getStartTime(n2 + 1), d10);
                label = new Label(this.get(string4, new Object[0]), font, this.a(defaults.getGreen()), defaults.getGreen());
                label.setLocation(coordinate);
                this.addFigure((Figure)label);
            }
            dataContext.signal(n2, (Object)AtrTrailingStop$Signals.BUY, this.get(string5, new Object[]{Util.round((double)d10, (int)2), Util.round((double)d3, (int)3)}), (Object)d10);
        }
    }

    private Color a(Color color) {
        int n2 = color.getRed() + color.getBlue() + color.getGreen();
        if (n2 > 220) {
            return X11Colors.BLACK;
        }
        return X11Colors.WHITE;
    }
}

