/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.AdaptiveSmoothingIndicator$Values;

@StudyHeader(namespace="com.motivewave", id="ID_ASI_T3", rb="com.motivewave.platform.study.nls.strings2", name="NAME_ADAPTIVE_SMOOTHING_INDICATOR_T3", label="LBL_ASIT3", desc="DESC_ASIT3", menu="MENU_OVERLAYS", helpLink="http://www.motivewave.com/studies/adaptive_smoothing_indicator.htm", requiresVolume=true, signals=false, overlay=true, studyOverlay=true)
public class AdaptiveSmoothingIndicator
extends Study {
    static final String a = "volFac";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 34, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("VOLUME_FACTOR", new Object[0]), 0.5, 0.01, 1.0, 0.01)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PATH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD", new Object[0]), 34, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{a, "line"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)AdaptiveSmoothingIndicator$Values.T3, this.get("LBL_ASIT3", new Object[0]), new String[]{"input", "method", "period", a}));
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", a});
        runtimeDescriptor.declarePath((Object)AdaptiveSmoothingIndicator$Values.T3, "line");
        runtimeDescriptor.declareIndicator((Object)AdaptiveSmoothingIndicator$Values.T3, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{AdaptiveSmoothingIndicator$Values.T3});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 * 6);
    }

    protected void calculate(int n2, DataContext dataContext) {
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.EMA);
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        double d2 = this.getSettings().getDouble(a);
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d3 = dataSeries.ma(mAMethod, n2, n3, object);
        dataSeries.setDouble(n2, (Object)AdaptiveSmoothingIndicator$Values.EMA1, d3);
        if (n2 < n3 * 2) {
            return;
        }
        Double d4 = dataSeries.ma(mAMethod, n2, n3, (Object)AdaptiveSmoothingIndicator$Values.EMA1);
        dataSeries.setDouble(n2, (Object)AdaptiveSmoothingIndicator$Values.EMA2, d4);
        if (d3 == null || d4 == null) {
            return;
        }
        double d5 = d3 * (1.0 + d2) - d4 * d2;
        dataSeries.setDouble(n2, (Object)AdaptiveSmoothingIndicator$Values.GD1, Double.valueOf(d5));
        if (n2 < n3 * 3) {
            return;
        }
        Double d6 = dataSeries.ma(mAMethod, n2, n3, (Object)AdaptiveSmoothingIndicator$Values.GD1);
        dataSeries.setDouble(n2, (Object)AdaptiveSmoothingIndicator$Values.EMA3, d6);
        if (n2 < n3 * 4) {
            return;
        }
        Double d7 = dataSeries.ma(mAMethod, n2, n3, (Object)AdaptiveSmoothingIndicator$Values.EMA3);
        dataSeries.setDouble(n2, (Object)AdaptiveSmoothingIndicator$Values.EMA4, d7);
        if (d6 == null || d7 == null) {
            return;
        }
        double d8 = d6 * (1.0 + d2) - d7 * d2;
        dataSeries.setDouble(n2, (Object)AdaptiveSmoothingIndicator$Values.GD2, Double.valueOf(d8));
        if (n2 < n3 * 5) {
            return;
        }
        Double d9 = dataSeries.ma(mAMethod, n2, n3, (Object)AdaptiveSmoothingIndicator$Values.GD2);
        dataSeries.setDouble(n2, (Object)AdaptiveSmoothingIndicator$Values.EMA5, d9);
        if (n2 < n3 * 6) {
            return;
        }
        Double d10 = dataSeries.ma(mAMethod, n2, n3, (Object)AdaptiveSmoothingIndicator$Values.EMA5);
        dataSeries.setDouble(n2, (Object)AdaptiveSmoothingIndicator$Values.EMA6, d10);
        if (d9 == null || d10 == null) {
            return;
        }
        double d11 = d9 * (1.0 + d2) - d10 * d2;
        dataSeries.setDouble(n2, (Object)AdaptiveSmoothingIndicator$Values.T3, Double.valueOf(d11));
        dataSeries.setComplete(n2);
    }
}

