/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general3;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general3.WilliamsADLine$Values;

@StudyHeader(namespace="com.motivewave", id="WILLIAMS_AD_LINE", rb="com.motivewave.platform.study.nls.strings2", name="NAME_WILLIAMS_A/D_LINE", label="LBL_WADL", desc="DESC_WADL", helpLink="http://www.motivewave.com/studies/williams_ad_line.htm", overlay=false, requiresVolume=true, studyOverlay=true)
public class WilliamsADLine
extends Study {
    static final String a = "UseVol";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup("Inputs");
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(a, this.get("USE_VOLUME", new Object[0]), Boolean.valueOf(true))});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PATH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, false)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("INDICATOR", new Object[0]), null, null, false, true, true)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -9999.0, 9999.0, 1.0, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup2 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{a, "line", "topFill", "bottomFill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)WilliamsADLine$Values.WADL, this.get("LBL_WADL", new Object[0]), new String[0]));
        runtimeDescriptor.setLabelSettings(new String[]{a});
        runtimeDescriptor.declarePath((Object)WilliamsADLine$Values.WADL, "line");
        runtimeDescriptor.declareIndicator((Object)WilliamsADLine$Values.WADL, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{WilliamsADLine$Values.WADL});
        this.setMinBars(21);
    }

    protected void calculate(int n2, DataContext dataContext) {
        if (n2 < 1) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        boolean bl2 = this.getSettings().getBoolean(a);
        double d2 = dataSeries.getHigh(n2);
        double d3 = dataSeries.getLow(n2);
        double d4 = dataSeries.getClose(n2);
        double d5 = dataSeries.getClose(n2 - 1);
        long l2 = 0L;
        if (bl2) {
            l2 = dataSeries.getVolume(n2);
        }
        double d6 = Math.max(d2, d5);
        double d7 = Math.min(d3, d5);
        double d8 = 0.0;
        if (d4 > d5) {
            d8 = d4 - d7;
        }
        if (d4 < d5) {
            d8 = d4 - d6;
        }
        if (d4 == d5) {
            d8 = 0.0;
        }
        double d9 = dataSeries.getDouble(n2 - 1, (Object)WilliamsADLine$Values.WADL, 0.0);
        double d10 = 0.0;
        d10 = d8 + d9;
        if (bl2) {
            d10 = d8 * (double)l2 + d9;
        }
        dataSeries.setDouble(n2, (Object)WilliamsADLine$Values.WADL, Double.valueOf(d10));
        dataSeries.setComplete(n2);
    }
}

