/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general3;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.X11Colors;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.Plot;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.j;
import com.motivewave.platform.study.general3.TMV$Signals;
import com.motivewave.platform.study.general3.TMV$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="TREND_MOM_VOLT_VOL", rb="com.motivewave.platform.study.nls.strings2", name="NAME_TMV", desc="DESC_TMV", label="LBL_TMV", helpLink="http://www.motivewave.com/studies/trend_momentum_volatility_volume.htm", overlay=false, studyOverlay=true)
public class TMV
extends Study {
    static final String a = "kPeriod";
    static final String b = "vfPeriod";
    static final String c = "vsPeriod";
    static final String d = "adxPeriod";
    static final String e = "smaPeriod";
    static final String f = "kTopPath";
    static final String g = "kMidPath";
    static final String h = "kBottPath";
    static final String i = "kTopInd";
    static final String j = "kMidInd";
    static final String k = "kBottInd";
    static final String l = "kUpper";
    static final String m = "kLower";
    static final String n = "adxPath";
    static final String o = "pdiPath";
    static final String p = "ndiPath";
    static final String q = "smaPath";
    static final String r = "adxInd";
    static final String s = "pdiInd";
    static final String t = "ndiInd";
    static final String u = "smaInd";
    static final String v = "adxPlot";
    static final String w = "voPath";
    static final String x = "voInd";
    static final String y = "voPlot";
    static final String z = "adxTopG";
    static final String A = "adxMidG";
    static final String B = "adxBottG";
    static final String C = "upColor";
    static final String D = "downColor";
    static final String E = "neutralColor";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("CCI_PERIOD", new Object[0]), 13, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("KELTNER_PERIOD", new Object[0]), 13, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(l, this.get("KELTNER_UPPER_RANGE", new Object[0]), 2.0, 0.1, 999.0, 0.1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(m, this.get("KELTNER_LOWER_RANGE", new Object[0]), 2.0, 0.1, 999.0, 0.1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("VOLUME_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(b, this.get("VOLUME_FAST_PERIOD", new Object[0]), 1, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(c, this.get("VOLUME_SLOW_PERIOD", new Object[0]), 20, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(d, this.get("ADX_PERIOD", new Object[0]), 10, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(e, this.get("SMA_PERIOD", new Object[0]), 8, 1, 9999, 1)});
        settingTab = settingsDescriptor.addTab(this.get("COLORS1", new Object[0]));
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("CCI_PATH_AND_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("CCI_PATH", new Object[0]), X11Colors.CADET_BLUE, 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("CCI_INDICATOR", new Object[0]), X11Colors.CADET_BLUE, X11Colors.WHITE, false, true, true)});
        settingGroup2 = settingTab.addGroup(this.get("KELTNER_PATHS_AND_INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(f, this.get("TOP_PATH", new Object[0]), X11Colors.CADET_BLUE, 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(g, this.get("MIDDLE_PATH", new Object[0]), X11Colors.DARK_SLATE_GRAY, 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(h, this.get("BOTTOM_PATH", new Object[0]), X11Colors.DARK_SLATE_GRAY, 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(i, this.get("TOP_INDICATOR", new Object[0]), X11Colors.CADET_BLUE, X11Colors.WHITE, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(j, this.get("MIDDLE_INDICATOR", new Object[0]), X11Colors.DARK_SLATE_GRAY, X11Colors.WHITE, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(k, this.get("BOTTOM_INDICATOR", new Object[0]), X11Colors.DARK_SLATE_GRAY, X11Colors.WHITE, false, true, true)});
        settingGroup2 = settingTab.addGroup(this.get("VO_PATH_AND_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(w, this.get("VO_PATH", new Object[0]), X11Colors.CADET_BLUE, 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(x, this.get("VO_INDICATOR", new Object[0]), X11Colors.CADET_BLUE, X11Colors.WHITE, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("COLORS2", new Object[0]));
        settingGroup2 = settingTab.addGroup(this.get("ADX_PATHS_AND_INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(n, this.get("ADX_PATH", new Object[0]), X11Colors.CADET_BLUE, 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(o, this.get("PDI_PATH", new Object[0]), X11Colors.RED, 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(p, this.get("NDI_PATH", new Object[0]), X11Colors.GREEN, 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(r, this.get("ADX_INDICATOR", new Object[0]), X11Colors.CADET_BLUE, X11Colors.WHITE, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(s, this.get("PDI_INDICATOR", new Object[0]), X11Colors.RED, X11Colors.WHITE, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(t, this.get("NDI_INDICATOR", new Object[0]), X11Colors.GREEN, X11Colors.WHITE, false, true, true)});
        settingGroup2 = settingTab.addGroup(this.get("SMA_PATH_AND_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(q, this.get("SMA_PATH", new Object[0]), X11Colors.RED, 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(u, this.get("SMA_INDICATOR", new Object[0]), X11Colors.RED, X11Colors.WHITE, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("COLORS3", new Object[0]));
        settingGroup2 = settingTab.addGroup(this.get("PRICE_BAR_COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(C, this.get("UP_COLOR", new Object[0]), defaults.getBlue())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(D, this.get("DOWN_COLOR", new Object[0]), defaults.getYellow())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(E, this.get("NEUTRAL_COLOR", new Object[0]), defaults.getGrey())});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("CCI_GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("CCI_TOP_GUIDE", new Object[0]), 100.0, 0.0, 999.0, 1.0, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("CCI_MIDDLE_GUIDE", new Object[0]), 0.0, -999.0, 999.0, 1.0, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("CCI_BOTTOM_GUIDE", new Object[0]), -100.0, 0.0, -999.0, 1.0, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("ADX_GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor4 = new GuideDescriptor(z, this.get("ADX_TOP_GUIDE", new Object[0]), 40.0, 0.0, 999.1, 0.1, true);
        guideDescriptor4.setLineColor(defaults.getRed());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor4});
        GuideDescriptor guideDescriptor5 = new GuideDescriptor(A, this.get("ADX_MIDDLE_GUIDE", new Object[0]), 30.0, 0.0, 999.1, 0.1, true);
        guideDescriptor5.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor5});
        GuideDescriptor guideDescriptor6 = new GuideDescriptor(B, this.get("ADX_BOTTOM_GUIDE", new Object[0]), 20.0, 0.0, 999.1, 0.1, true);
        guideDescriptor6.setLineColor(defaults.getGreen());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor6});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("CCI_PERIOD", new Object[0]), 13, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("KELTNER_PERIOD", new Object[0]), 13, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{l, m, "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(b, this.get("VOLUME_FAST_PERIOD", new Object[0]), 1, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(c, this.get("VOLUME_SLOW_PERIOD", new Object[0]), 20, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(d, this.get("ADX_PERIOD", new Object[0]), 10, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(e, this.get("SMA_PERIOD", new Object[0]), 8, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"period", l, m});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TMV$Values.TOP, this.get("K_TOP", new Object[0]), new String[]{"period", l}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TMV$Values.MIDDLE, this.get("K_MID", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TMV$Values.BOTTOM, this.get("K_BOTTOM", new Object[0]), new String[]{"period", m}));
        runtimeDescriptor.declareSignal((Object)TMV$Signals.BUY, this.get("BUY_SIGNAL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)TMV$Signals.SELL, this.get("SELL_SIGNAL", new Object[0]));
        runtimeDescriptor.getPricePlot().setLabelSettings(new String[]{"input", "period", l, m});
        runtimeDescriptor.getPricePlot().setLabelPrefix("KC");
        runtimeDescriptor.getPricePlot().declarePath((Object)TMV$Values.TOP, f);
        runtimeDescriptor.getPricePlot().declarePath((Object)TMV$Values.MIDDLE, g);
        runtimeDescriptor.getPricePlot().declarePath((Object)TMV$Values.BOTTOM, h);
        runtimeDescriptor.getPricePlot().declarePath((Object)TMV$Values.SMA, q);
        runtimeDescriptor.getPricePlot().declareIndicator((Object)TMV$Values.TOP, i);
        runtimeDescriptor.getPricePlot().declareIndicator((Object)TMV$Values.MIDDLE, j);
        runtimeDescriptor.getPricePlot().declareIndicator((Object)TMV$Values.BOTTOM, k);
        runtimeDescriptor.getPricePlot().declareIndicator((Object)TMV$Values.SMA, u);
        runtimeDescriptor.setLabelSettings(new String[]{"period"});
        runtimeDescriptor.setLabelPrefix("CCI");
        runtimeDescriptor.setTabName("CCI");
        runtimeDescriptor.declarePath((Object)TMV$Values.CCI, "line");
        runtimeDescriptor.declareIndicator((Object)TMV$Values.CCI, "ind");
        runtimeDescriptor.getDefaultPlot().declareGuide("topGuide");
        runtimeDescriptor.getDefaultPlot().declareGuide("middleGuide");
        runtimeDescriptor.getDefaultPlot().declareGuide("bottomGuide");
        runtimeDescriptor.setRangeKeys(new Object[]{TMV$Values.CCI});
        Plot plot = new Plot();
        plot.setAllowDisable(true);
        runtimeDescriptor.addPlot(v, plot);
        plot.setLabelSettings(new String[]{"input", "period"});
        plot.setLabelPrefix("ADX");
        plot.setTabName("ADX");
        plot.declarePath((Object)TMV$Values.ADX, n);
        plot.declarePath((Object)TMV$Values.PDI, o);
        plot.declarePath((Object)TMV$Values.NDI, p);
        plot.declareIndicator((Object)TMV$Values.ADX, r);
        plot.declareIndicator((Object)TMV$Values.PDI, s);
        plot.declareIndicator((Object)TMV$Values.NDI, t);
        plot.declareGuide(z);
        plot.declareGuide(A);
        plot.declareGuide(B);
        plot.setMaxBottomValue(Integer.valueOf(15));
        plot.setMinTopValue(Integer.valueOf(85));
        plot.setRangeKeys(new Object[]{TMV$Values.ADX});
        Plot plot2 = new Plot();
        plot2.setAllowDisable(true);
        runtimeDescriptor.addPlot(y, plot2);
        plot2.setLabelSettings(new String[]{"input", "period"});
        plot2.setLabelPrefix("VO");
        plot2.setTabName("VO");
        plot2.declarePath((Object)TMV$Values.VO, w);
        plot2.declareIndicator((Object)TMV$Values.VO, x);
        plot2.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
        plot2.setRangeKeys(new Object[]{TMV$Values.VO});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger(b);
        int n5 = this.getSettings().getInteger(c);
        int n6 = this.getSettings().getInteger(d);
        int n7 = this.getSettings().getInteger(e);
        int n8 = Math.max(Math.max(Math.max(Math.max(Math.max(n2, n3), n4), n5), n6), n7);
        this.setMinBars(n8);
    }

    protected void calculate(int n2, DataContext dataContext) {
        boolean bl2;
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger(b);
        int n6 = this.getSettings().getInteger(c);
        int n7 = this.getSettings().getInteger(d);
        int n8 = this.getSettings().getInteger(e);
        int n9 = Math.max(Math.max(Math.max(Math.max(Math.max(n3, n4), n5), n6), n7), n8);
        if (n2 < n9) {
            return;
        }
        Object object = this.getSettings().getInput("input");
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        Color color = this.getSettings().getColor(E);
        Color color2 = this.getSettings().getColor(C);
        Color color3 = this.getSettings().getColor(D);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        Double d3 = dataSeries.sma(n2, n8, object);
        if (d3 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)TMV$Values.SMA, d3);
        double d4 = com.motivewave.platform.study.general.j.a(dataSeries, n2, n3);
        dataSeries.setDouble(n2, (Object)TMV$Values.CCI, Double.valueOf(d4));
        Float f2 = dataSeries.getPositiveDM(n2);
        Float f3 = dataSeries.getNegativeDM(n2);
        Float f4 = dataSeries.getTrueRange(n2);
        if (f2 == null || f3 == null || f4 == null) {
            return;
        }
        dataSeries.setFloat(n2, (Object)TMV$Values.PDM, f2);
        dataSeries.setFloat(n2, (Object)TMV$Values.NDM, f3);
        dataSeries.setFloat(n2, (Object)TMV$Values.TR, f4);
        Double d5 = dataSeries.smma(n2, n7, (Object)TMV$Values.PDM);
        Double d6 = dataSeries.smma(n2, n7, (Object)TMV$Values.NDM);
        Double d7 = dataSeries.smma(n2, n7, (Object)TMV$Values.TR);
        if (d5 == null || d6 == null || d7 == null) {
            return;
        }
        double d8 = d5 / d7 * 100.0;
        double d9 = d6 / d7 * 100.0;
        double d10 = Math.abs(d5 - d6) / (d5 + d6) * 100.0;
        dataSeries.setDouble(n2, (Object)TMV$Values.DX, Double.valueOf(d10));
        dataSeries.setDouble(n2, (Object)TMV$Values.PDI, Double.valueOf(d8));
        dataSeries.setDouble(n2, (Object)TMV$Values.NDI, Double.valueOf(d9));
        Double d11 = dataSeries.smma(n2, n7, (Object)TMV$Values.DX);
        if (d11 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)TMV$Values.ADX, d11);
        double d12 = dataSeries.getDouble(n2 - 1, (Object)TMV$Values.ADX, 0.0);
        double d13 = this.getSettings().getDouble(l);
        double d14 = this.getSettings().getDouble(m);
        Double d15 = dataSeries.ma(Enums.MAMethod.EMA, n2, n4, object);
        Double d16 = dataSeries.atr(n2, n4);
        if (d15 == null || d16 == null) {
            return;
        }
        double d17 = d15 + d13 * d16;
        double d18 = d15 - d14 * d16;
        dataSeries.setDouble(n2, (Object)TMV$Values.MIDDLE, d15);
        dataSeries.setDouble(n2, (Object)TMV$Values.TOP, Double.valueOf(d17));
        dataSeries.setDouble(n2, (Object)TMV$Values.BOTTOM, Double.valueOf(d18));
        Double d19 = dataSeries.ma(mAMethod, n2, n5, (Object)Enums.BarInput.VOLUME);
        Double d20 = dataSeries.ma(mAMethod, n2, n6, (Object)Enums.BarInput.VOLUME);
        if (d19 == null || d20 == null) {
            return;
        }
        double d21 = d19 - d20;
        dataSeries.setDouble(n2, (Object)TMV$Values.VO, Double.valueOf(d21));
        boolean bl3 = d11 > d12 && d2 > d3;
        boolean bl4 = bl2 = d11 > d12 && d2 < d3;
        if (bl3) {
            dataSeries.setPriceBarColor(n2, color2);
        }
        if (bl2) {
            dataSeries.setPriceBarColor(n2, color3);
        }
        if (!bl3 && !bl2) {
            dataSeries.setPriceBarColor(n2, color);
        }
        dataSeries.setComplete(n2);
    }
}

